/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISNativeObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString2;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwCMISClassDescription {
    private static final Logger LOG = OwLog.getLogger(OwCMISClassDescription.class);
    private LinkedHashMap<String, OwCMISPropertyClass> m_localQualifiedPropertyClasses = new LinkedHashMap();
    private LinkedHashMap<String, OwCMISPropertyClass> m_localShortNamePropertyClasses = new LinkedHashMap();
    private Set<OwCMISPropertyClass> queryableProperties = null;
    private OwCMISObjectClass clazz;
    private OwCMISObjectClass parent;
    private List<OwCMISObjectClass> subclasses = new LinkedList<OwCMISObjectClass>();
    private List<OwCMISObjectClass> instantiableSubclasses = new LinkedList<OwCMISObjectClass>();
    private List<String> preferredPropertyOrder;

    public OwCMISClassDescription(OwCMISObjectClass objectClass_p, OwCMISObjectClass parent_p) {
        this.clazz = objectClass_p;
        this.parent = parent_p;
    }

    public OwCMISObjectClass getParentClass() {
        return this.parent;
    }

    public OwCMISObjectClass getDescribedClass() {
        return this.clazz;
    }

    public void addLocalPropertyClass(OwCMISPropertyClass propertyClass_p) {
        this.m_localQualifiedPropertyClasses.put(propertyClass_p.getClassName(), propertyClass_p);
        this.m_localShortNamePropertyClasses.put(propertyClass_p.getNonQualifiedName(), propertyClass_p);
    }

    public Map<String, OwCMISPropertyClass> getLocalPropertyClasses() throws OwException {
        return this.m_localQualifiedPropertyClasses;
    }

    public Map<String, OwCMISPropertyClass> getPropertyClasses() throws OwException {
        Map<String, OwCMISPropertyClass> hierarchyProperties = null;
        if (this.parent != null) {
            hierarchyProperties = this.parent.getPropertyClasses();
            HashSet<String> hierarchyKeys = new HashSet<String>(hierarchyProperties.keySet());
            for (String classKey : hierarchyKeys) {
                OwCMISPropertyClass property = hierarchyProperties.get(classKey);
                String shortName = property.getNonQualifiedName();
                if (!this.m_localShortNamePropertyClasses.containsKey(shortName)) continue;
                hierarchyProperties.remove(classKey);
                OwCMISPropertyClass localProperty = this.m_localShortNamePropertyClasses.get(shortName);
                hierarchyProperties.put(localProperty.getFullQualifiedName(), localProperty);
            }
        } else {
            hierarchyProperties = new LinkedHashMap<String, OwCMISPropertyClass>();
        }
        hierarchyProperties.putAll(this.getLocalPropertyClasses());
        return this.reorderProperties(hierarchyProperties);
    }

    public OwCMISPropertyClass getPropertyClass(String strClassName_p) throws OwException {
        OwCMISPropertyClass propertyClass = this.getLocalPropertyClasses().get(strClassName_p);
        if (propertyClass == null && (propertyClass = this.m_localShortNamePropertyClasses.get(strClassName_p)) == null) {
            if (this.parent != null) {
                try {
                    propertyClass = this.parent.getPropertyClass(strClassName_p);
                }
                catch (OwObjectNotFoundException e) {
                    throw new OwObjectNotFoundException((OwString)new OwString2("ecmimpl.cmis.OwCMISClassDescription.invalid.property.class.tree", "Property %1 is not defined by object class tree of %2", strClassName_p, this.clazz.getClassName()), (Throwable)e);
                }
            } else {
                throw new OwObjectNotFoundException((OwString)new OwString2("ecmimpl.cmis.OwCMISClassDescription.invalid.property.class.tree", "Property %1 is not defined by object class tree of %2", strClassName_p, this.clazz.getClassName()));
            }
        }
        return propertyClass;
    }

    public Set<OwCMISPropertyClass> getQueryablePropertyClasses(OwCMISQueryContext context_p) throws OwException {
        if (this.queryableProperties == null) {
            this.queryableProperties = new HashSet<OwCMISPropertyClass>();
            Map<String, OwCMISPropertyClass> propertyClasses = this.getPropertyClasses();
            Set<Map.Entry<String, OwCMISPropertyClass>> propClasseseEntries = propertyClasses.entrySet();
            for (Map.Entry<String, OwCMISPropertyClass> propertyEntry : propClasseseEntries) {
                OwCMISPropertyClass propertyClass = propertyEntry.getValue();
                if (!propertyClass.isQueryable(context_p)) continue;
                this.queryableProperties.add(propertyClass);
            }
        }
        return this.queryableProperties;
    }

    public Map<String, OwCMISObjectClass> getNamedSubclasses(boolean excludeHiddenAndNonInstantiable_p) {
        List<OwCMISObjectClass> subclasses = this.getSubclasses(excludeHiddenAndNonInstantiable_p);
        HashMap<String, OwCMISObjectClass> namedSubclasses = new HashMap<String, OwCMISObjectClass>();
        for (OwCMISObjectClass subclass : subclasses) {
            namedSubclasses.put(subclass.getClassName(), subclass);
        }
        return namedSubclasses;
    }

    public List<OwCMISObjectClass> getSubclasses(boolean excludeHiddenAndNonInstantiable_p) {
        if (excludeHiddenAndNonInstantiable_p) {
            return new LinkedList<OwCMISObjectClass>(this.instantiableSubclasses);
        }
        return new LinkedList<OwCMISObjectClass>(this.subclasses);
    }

    public void subclassedBy(OwCMISObjectClass subclass_p) throws OwInvalidOperationException {
        OwCMISObjectClass subclassParent = null;
        try {
            subclassParent = subclass_p.getParent();
        }
        catch (OwException e) {
            LOG.error((Object)("OwCMISClassDescription.subclassedBy(): Subclass error! Could not create subclass description information " + this.clazz.getClassName() + "<-" + subclass_p.getClassName()), (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISClassDescription.sublcass.retreiveParentError", "Parent class could not be found."), (Throwable)e);
        }
        if (subclassParent != this.clazz) {
            LOG.error((Object)("OwCMISClassDescription.subclassedBy(): Subclass error!" + this.clazz.getClassName() + " is not the parent of " + subclass_p.getClassName()));
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISClassDescription.sublcass.error", "Requested class is not the appropriate parent class."));
        }
        this.subclasses.add(subclass_p);
        if (subclass_p.getClass().isAssignableFrom(OwCMISNativeObjectClass.class)) {
            try {
                ((OwCMISNativeObjectClass)subclass_p).getClassDescription().setPreferredPropertyOrder(this.getPreferredPropertyOrder());
            }
            catch (OwException e) {
                LOG.error((Object)("OwCMISClassDescription.subclassedBy(): Subclass error!" + this.clazz.getClassName() + " is not the parent of " + subclass_p.getClassName()));
            }
        }
        try {
            if (subclass_p.canCreateNewObject()) {
                this.instantiableSubclasses.add(subclass_p);
            }
        }
        catch (OwException e) {
            LOG.error((Object)("OwCMISClassDescription.subclassedBy(): Subclass error! Could not create subclass description information " + this.clazz.getClassName() + "<-" + subclass_p.getClassName()), (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISClassDescription.sublcass.error", "Requested class is not the appropriate parent class."), (Throwable)e);
        }
    }

    protected Map<String, OwCMISPropertyClass> reorderProperties(Map<String, OwCMISPropertyClass> allProperties_p) throws OwException {
        LinkedHashMap<String, OwCMISPropertyClass> orderedProperties = new LinkedHashMap<String, OwCMISPropertyClass>();
        block0: for (String temp : this.getPreferredPropertyOrder()) {
            OwCMISPropertyClass propertyClass = allProperties_p.get(temp);
            if (propertyClass != null) {
                orderedProperties.put(temp, propertyClass);
                continue;
            }
            for (Map.Entry<String, OwCMISPropertyClass> entry : allProperties_p.entrySet()) {
                propertyClass = entry.getValue();
                if (!propertyClass.getClassName().equalsIgnoreCase(temp) && !propertyClass.getNonQualifiedName().equalsIgnoreCase(temp)) continue;
                orderedProperties.put(entry.getKey(), propertyClass);
                continue block0;
            }
        }
        orderedProperties.putAll(allProperties_p);
        return orderedProperties;
    }

    public List<String> getPreferredPropertyOrder() {
        return this.preferredPropertyOrder == null ? new LinkedList() : this.preferredPropertyOrder;
    }

    public void setPreferredPropertyOrder(List<String> preferedPropertyOrder) {
        this.preferredPropertyOrder = preferedPropertyOrder;
    }
}

