/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSimpleDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.content.OwCMISStandardContentConverter;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISObjectExtension;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISClassDescription;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.permissions.OwCMISPermissionCollection;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISConvertFilterChain;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISFilterInternal;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISFilterReadonly;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISStandardPropertyCollectionConverter;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwPropertyDefinitionHelper;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.util.OwObjectIDCodeUtil;
import com.wewebu.ow.server.util.OwString;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlListType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumBaseObjectTypeIds;
import org.oasis_open.docs.ns.cmis.core._200908.EnumVersioningState;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisTypeContainer;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;

public abstract class OwCMISNativeObjectClass
implements OwCMISObjectClass {
    private static final Logger LOG = OwLog.getLogger(OwCMISNativeObjectClass.class);
    private OwCMISClassDescription classDescription = null;
    private OwCMISObjectModel objectModel;
    private CmisTypeDefinitionType m_type;
    private int m_itype;
    private String m_mimetype;
    private OwCMISPropertyClassFactory propertyClassFactory;
    private boolean hierarchyInitialized = false;

    public OwCMISNativeObjectClass(OwCMISObjectModel objectModel_p, OwCMISPropertyClassFactory propertyClassFactory_p, CmisTypeDefinitionType type_p) throws OwException {
        this.m_type = type_p;
        this.propertyClassFactory = propertyClassFactory_p;
        this.objectModel = objectModel_p;
        this.setObjectType(type_p.getBaseId());
        String parentId = this.m_type.getParentId();
        OwCMISObjectClass parent = this.objectModel.getObjectClass(parentId);
        this.classDescription = new OwCMISClassDescription(this, parent);
        this.initializeProperties();
        if (parent != null) {
            parent.subclassedBy(this);
        }
    }

    @Override
    public String getMimetype() {
        return this.m_mimetype;
    }

    protected void setObjectType(EnumBaseObjectTypeIds base_p) {
        switch (base_p) {
            case CMIS_DOCUMENT: {
                this.m_itype = 4097;
                this.m_mimetype = null;
                break;
            }
            case CMIS_FOLDER: {
                this.m_itype = 8193;
                this.m_mimetype = "ow_folder/" + this.m_type.getId();
                break;
            }
            case CMIS_POLICY: {
                this.m_itype = 12289;
                this.m_mimetype = "ow_policy/" + this.m_type.getId();
                break;
            }
            case CMIS_RELATIONSHIP: {
                this.m_itype = 12289;
                this.m_mimetype = "ow_relationship/" + this.m_type.getId();
            }
        }
    }

    protected void initializeProperties() throws OwException {
        List propdefinitions = this.m_type.getPropertyDefinition();
        boolean trace = LOG.isTraceEnabled();
        for (CmisPropertyDefinitionType proptype : propdefinitions) {
            OwCMISPropertyClass propertyClass;
            if (this.getParent() == null || !proptype.isInherited().booleanValue()) {
                OwCMISPropertyClass propertyClass2 = this.propertyClassFactory.createPropertyClass(proptype, this);
                this.classDescription.addLocalPropertyClass(propertyClass2);
                if (!trace) continue;
                LOG.trace((Object)("ADDED PROPERTY " + this.getClassName() + " @ " + propertyClass2.toString()));
                continue;
            }
            if (!proptype.isInherited().booleanValue()) continue;
            try {
                OwCMISNativePropertyClass parentProperty = (OwCMISNativePropertyClass)this.getParent().getPropertyClass(proptype.getId());
                if (OwPropertyDefinitionHelper.isInheritanceDifferent(proptype, parentProperty.getNativeType())) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("OwCMISAbstractNativeObjectClass.getNativePropertyClasses: Inherited but different prop-definition: " + proptype));
                    }
                    propertyClass = this.propertyClassFactory.createPropertyClass(proptype, this);
                    this.classDescription.addLocalPropertyClass(propertyClass);
                    continue;
                }
                if (!trace) continue;
                LOG.trace((Object)("INHERITED PROPERTY " + this.getClassName() + " @ " + parentProperty.toString()));
            }
            catch (OwObjectNotFoundException e) {
                if (trace) {
                    String msg = "property " + proptype.getId() + " SHOULD BE INHERITED from object class " + this.getParent().getClassName() + " in " + this.getClassName() + "(exception " + e.getMessage() + ")";
                    LOG.trace((Object)("OwCMISNativeObjectClass.initializeProperties:" + msg));
                }
                propertyClass = this.propertyClassFactory.createPropertyClass(proptype, this);
                this.classDescription.addLocalPropertyClass(propertyClass);
                if (!trace) continue;
                LOG.trace((Object)("ADDED MISSINHERITED PROPERTY  " + this.getClassName() + " @ " + propertyClass.toString()));
            }
        }
        Set<OwCMISPropertyClass> customPropertyClasses = this.createCustomPropertyClasses();
        for (OwCMISPropertyClass propertyClass2 : customPropertyClasses) {
            this.classDescription.addLocalPropertyClass(propertyClass2);
            if (!trace) continue;
            LOG.trace((Object)("ADDED INTERNAL PROPERTY " + this.getClassName() + " @ " + propertyClass2.toString()));
        }
    }

    protected Set<OwCMISPropertyClass> createCustomPropertyClasses() throws OwException {
        if (this.getParent() == null) {
            HashSet<OwCMISPropertyClass> customProperties = new HashSet<OwCMISPropertyClass>();
            return customProperties;
        }
        return new HashSet<OwCMISPropertyClass>();
    }

    protected OwCMISClassDescription getClassDescription() throws OwException {
        return this.classDescription;
    }

    @Override
    public Map<String, OwCMISPropertyClass> getPropertyClasses() throws OwException {
        OwCMISClassDescription description = this.getClassDescription();
        return description.getPropertyClasses();
    }

    @Override
    public boolean canCreateNewObject() throws OwException {
        return this.getNativeObject().isCreatable();
    }

    public Map<?, ?> getChildNames(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p) throws OwException {
        List<?> lst = this.getChilds(network_p, excludeHiddenAndNonInstantiable_p);
        HashMap<String, OwCMISObjectClass> map = new HashMap<String, OwCMISObjectClass>();
        for (OwCMISObjectClass child : lst) {
            map.put(child.getClassName(), child);
        }
        return map;
    }

    public synchronized List<?> getChilds(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p) throws OwException {
        if (!this.hierarchyInitialized) {
            OwCMISNetwork cmisNetwork = (OwCMISNetwork)network_p;
            try {
                List lst = cmisNetwork.getRepositoryServicePort().getTypeDescendants(this.getResource().getID(), this.getClassName(), BigInteger.ONE, Boolean.valueOf(false), null);
                Hashtable<String, OwCMISObjectClass> objClassChildren = new Hashtable<String, OwCMISObjectClass>();
                for (CmisTypeContainer con : lst) {
                    OwCMISObjectClass child = cmisNetwork.getObjectClass(con.getType().getId(), this.getResource());
                    if (this.getClassName().equals(child.getClassName())) continue;
                    objClassChildren.put(child.getClassName(), child);
                }
                this.hierarchyInitialized = true;
            }
            catch (CmisException e) {
                OwNetworkContext context = cmisNetwork.getContext();
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                LOG.error((Object)("OwCMISNativeObjectClass.getChilds(): Could not retrieve class descendants! A CMIS error occurred : " + catcher.getLogMessage()));
                throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISNativeObjectClass.getChilds.error", "Could not retrieve class descendants!"), true);
            }
        }
        return this.classDescription.getSubclasses(excludeHiddenAndNonInstantiable_p);
    }

    public String getClassName() {
        return this.m_type.getId();
    }

    public String getDescription(Locale locale_p) {
        return OwString.localize((Locale)locale_p, (String)(this.getClassName() + ".Desc"), (String)this.m_type.getDescription());
    }

    public String getDisplayName(Locale locale_p) {
        return OwString.localizeLabel((Locale)locale_p, (String)this.getClassName(), (String)this.m_type.getDisplayName());
    }

    public List<?> getModes(int operation_p) throws OwException {
        return null;
    }

    @Override
    public String getNamePropertyName() throws OwException {
        return this.getPropertyClass(OwCMISPropertyNames.NAME.getId()).getClassName();
    }

    @Override
    public OwCMISObjectClass getParent() throws OwException {
        return this.classDescription.getParentClass();
    }

    @Override
    public OwCMISPropertyClass getPropertyClass(String strClassName_p) throws OwException {
        OwCMISClassDescription description = this.getClassDescription();
        return description.getPropertyClass(strClassName_p);
    }

    @Override
    public Collection<String> getPropertyClassNames() throws OwException {
        return this.getPropertyClasses().keySet();
    }

    public int getType() {
        return this.m_itype;
    }

    public boolean hasChilds(OwNetwork network_p, boolean excludeHiddenAndNonInstantiable_p, int context_p) throws OwException {
        return !this.getChilds(network_p, excludeHiddenAndNonInstantiable_p).isEmpty();
    }

    public boolean isHidden() throws OwException {
        return false;
    }

    @Override
    public OwCMISResource getResource() {
        return this.objectModel.getResource();
    }

    public OwCMISObjectModel getObjectModel() {
        return this.objectModel;
    }

    @Override
    public CmisTypeDefinitionType getNativeObject() {
        return this.m_type;
    }

    @Override
    public boolean isContentRequired() throws OwException {
        return false;
    }

    @Override
    public String getQueryName() {
        String queryName = this.m_type.getQueryName();
        if (queryName.equals("cmis:document") && !"cmis:document".equals(this.m_type.getId()) || queryName.equals("cmis:folder") && !"cmis:folder".equals(this.m_type.getId())) {
            LOG.warn((Object)("OwCMISNativeObjectClass.getQueryName():Inavlid query name : " + queryName + " for cmis object class " + this.m_type.getId() + ". Ingnoring the query name and proceeding with the id " + this.m_type.getId() + "."));
            queryName = this.m_type.getId();
            if ((queryName.startsWith("D:") || queryName.startsWith("F:")) && queryName.length() > 2 && queryName.indexOf(58, 2) != -1) {
                LOG.warn((Object)("OwCMISNativeObjectClass.getQueryName():Inavlid ID name : " + queryName + " for cmis object class " + this.m_type.getId() + ". Removing Alfresco-like 2 character type mark!"));
                queryName = queryName.substring(2);
            }
        }
        return queryName;
    }

    @Override
    public boolean isQueryable() {
        return this.m_type.isQueryable();
    }

    @Override
    public Set<OwCMISPropertyClass> getQueryablePropertyClasses(OwCMISQueryContext context_p) throws OwException {
        OwCMISClassDescription description = this.getClassDescription();
        return description.getQueryablePropertyClasses(context_p);
    }

    public OwPropertyCollection getClassProperties(OwCMISNetwork network_p) throws OwException {
        OwCMISPropertyClass propClass = this.getPropertyClass(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());
        OwCMISProperty objectIDProperty = propClass.newProperty(null, this.m_type.getId(), network_p);
        OwCMISPropertyClass idClass = objectIDProperty.getPropertyClass();
        OwStandardPropertyCollection classProperties = new OwStandardPropertyCollection();
        classProperties.put((Object)idClass.getClassName(), (Object)objectIDProperty);
        return classProperties;
    }

    protected abstract String createNewObjectCMISObject(OwCMISNetwork var1, EnumVersioningState var2, CmisPropertiesType var3, CmisAccessControlListType var4, CmisAccessControlListType var5, CmisContentStreamType var6, String var7, boolean var8) throws OwException;

    @Override
    public String createNewObject(OwCMISNetwork network_p, boolean promote_p, Object mode_p, OwResource resource_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p, boolean keepCheckedOut_p) throws OwException {
        OwStandardPropertyCollection propertyCollectionCopy = new OwStandardPropertyCollection();
        propertyCollectionCopy.putAll((Map)properties_p);
        OwPropertyCollection classPropertiesMap = this.getClassProperties(network_p);
        Collection classProperties = classPropertiesMap.values();
        for (OwProperty classProperty : classProperties) {
            OwPropertyClass classPropertyClass = null;
            try {
                classPropertyClass = classProperty.getPropertyClass();
            }
            catch (OwException e) {
                throw e;
            }
            catch (Exception e) {
                OwNetworkContext context = network_p.getContext();
                LOG.fatal((Object)"OwCMISNativeObjectClass.createNewObject():Invalid property found while creating object! Could not retrieve property class!", (Throwable)e);
                throw new OwInvalidOperationException(context.localize("ecmimpl.cmis.OwCMISNativeObjectClass.createNewObject.invalid.property.error", "Invalid property found while creating object!"), (Throwable)e);
            }
            propertyCollectionCopy.put((Object)classPropertyClass.getClassName(), (Object)classProperty);
        }
        try {
            EnumVersioningState state = promote_p ? EnumVersioningState.MAJOR : EnumVersioningState.MINOR;
            state = keepCheckedOut_p ? EnumVersioningState.CHECKEDOUT : state;
            OwCMISResource resource = this.getResource();
            OwCMISObjectExtension objectExtension = resource.getExtension("cmis.object.filter.property.extensions", OwCMISObjectExtension.class, null);
            OwPropertyCollection propertyExtensions = objectExtension.filterPropertyExtensions(this.getResource(), this.getClassName(), (OwPropertyCollection)propertyCollectionCopy);
            OwStandardPropertyCollection basicProperties = new OwStandardPropertyCollection();
            basicProperties.putAll((Map)propertyCollectionCopy);
            if (propertyExtensions != null) {
                Set extensionKeys = propertyExtensions.keySet();
                for (Object object : extensionKeys) {
                    basicProperties.remove(object);
                }
            }
            OwCMISConvertFilterChain convertFilter = new OwCMISFilterReadonly(1);
            convertFilter = new OwCMISFilterInternal(convertFilter);
            CmisPropertiesType nativeProperties = new OwCMISStandardPropertyCollectionConverter(convertFilter).createCmisProperties((OwPropertyCollection)basicProperties, null, resource_p.getID(), network_p);
            objectExtension = resource.getExtension("cmis.object.add.property.extensions", OwCMISObjectExtension.class, nativeProperties);
            nativeProperties = objectExtension.addPropertyExtensions(nativeProperties, propertyExtensions, null, resource.getID(), network_p);
            CmisContentStreamType contendDataHandler = new OwCMISStandardContentConverter().createCmisContentStream(content_p);
            CmisAccessControlListType addedACL = null;
            CmisAccessControlListType removedACL = null;
            if (permissions_p != null) {
                if (permissions_p instanceof OwCMISPermissionCollection) {
                    OwCMISPermissionCollection cmisPermission = (OwCMISPermissionCollection)permissions_p;
                    CmisAccessControlListType zeroACL = new CmisAccessControlListType();
                    CmisAccessControlListType[] operations = cmisPermission.diff(zeroACL);
                    removedACL = operations[0];
                    addedACL = operations[1];
                } else {
                    LOG.error((Object)("OwCMISNativeObjectClass.createNewObject : Invalid permissions class: " + permissions_p.getClass() + " instead of " + OwCMISPermissionCollection.class));
                    throw new OwInvalidOperationException("Internal error on create object");
                }
            }
            String newID = this.createNewObjectCMISObject(network_p, state, nativeProperties, addedACL, removedACL, contendDataHandler, this.getParentId(parent_p), keepCheckedOut_p);
            return OwCMISSimpleDMSID.createDMSID(network_p.getDMSPrefix(), resource.getID(), newID);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            OwNetworkContext context = network_p.getContext();
            LOG.fatal((Object)"OwCMISNativeObjectClass.createNewObject():Could not create object class!", (Throwable)e);
            throw new OwInvalidOperationException(context.localize("ecmimpl.cmis.OwCMISNativeObjectClass.createNewObject.error", "Could not create object!"), (Throwable)e);
        }
    }

    @Override
    public void subclassedBy(OwCMISObjectClass subclass_p) throws OwInvalidOperationException {
        this.classDescription.subclassedBy(subclass_p);
    }

    @Override
    public boolean isAssignableFrom(OwCMISObjectClass class_p) throws OwException {
        OwCMISResource resource = this.getResource();
        OwCMISResource classResource = class_p.getResource();
        if (resource.getID().equals(classResource.getID())) {
            if (this.getClassName().equals(class_p.getClassName())) {
                return true;
            }
            for (OwCMISObjectClass cpParent = class_p.getParent(); cpParent != null; cpParent = cpParent.getParent()) {
                if (!cpParent.getClassName().equals(this.getClassName())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected String getParentId(OwObject parent_p) throws OwException {
        if (parent_p == null) {
            return null;
        }
        String id = parent_p.getID();
        if (id.startsWith(this.getResource().getID())) {
            id = this.getResource().getRepsitoryRootFolderId();
        }
        return OwObjectIDCodeUtil.decode((String)id);
    }
}

