/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.objectclasses;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISBaseClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISDocumentClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISFolderClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISNativeObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClassFactory;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISPolicyClass;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISRelationshipClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClassFactory;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import java.util.List;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisTypeDocumentDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumBaseObjectTypeIds;

public class OwCMISStandardObjectClassFactory
implements OwCMISObjectClassFactory {
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardObjectClassFactory.class);
    private OwCMISPropertyClassFactory propertyClassFactory;
    private List<String> propertyOrder;

    public OwCMISStandardObjectClassFactory(OwCMISPropertyClassFactory propertyClassFactory_p) {
        this.propertyClassFactory = propertyClassFactory_p;
    }

    public OwCMISStandardObjectClassFactory(OwCMISPropertyClassFactory propertyClassFactory_p, List<String> propertyOrder_p) {
        this(propertyClassFactory_p);
        this.propertyOrder = propertyOrder_p;
    }

    @Override
    public OwCMISNativeObjectClass createClass(CmisTypeDefinitionType typeDefinition_p, OwCMISObjectModel objectModel_p) throws OwException {
        OwCMISNativeObjectClass objectClass;
        EnumBaseObjectTypeIds baseID = typeDefinition_p.getBaseId();
        switch (baseID) {
            case CMIS_DOCUMENT: {
                objectClass = new OwCMISDocumentClass(objectModel_p, this.propertyClassFactory, (CmisTypeDocumentDefinitionType)typeDefinition_p);
                break;
            }
            case CMIS_FOLDER: {
                objectClass = new OwCMISFolderClass(objectModel_p, this.propertyClassFactory, typeDefinition_p);
                break;
            }
            case CMIS_POLICY: {
                objectClass = new OwCMISPolicyClass(objectModel_p, this.propertyClassFactory, typeDefinition_p);
                break;
            }
            case CMIS_RELATIONSHIP: {
                objectClass = new OwCMISRelationshipClass(objectModel_p, this.propertyClassFactory, typeDefinition_p);
                break;
            }
            default: {
                LOG.error((Object)("OwCMISStandardObjectClassFactory.createClass(): Unknown base ID from CMIS Respository: " + baseID));
                throw new OwServerException("Invalid base ID " + baseID);
            }
        }
        if (objectClass != null) {
            objectClass.getClassDescription().setPreferredPropertyOrder(this.getPreferredPropertyOrder());
        }
        return objectClass;
    }

    @Override
    public OwCMISObjectClass createVirtualBaseClass(OwCMISObjectModel objectModel_p) throws OwException {
        return new OwCMISBaseClass(objectModel_p, this.propertyClassFactory);
    }

    @Override
    public void setPreferredPropertyOrder(List<String> propertyOrder) {
        this.propertyOrder = propertyOrder;
    }

    public List<String> getPreferredPropertyOrder() {
        return this.propertyOrder;
    }
}

