/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.permissions;

import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwPolicy;
import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.OwReason;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.OwStandardReason;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.permissions.OwCMISPrivilegeSet;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwString;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlEntryType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlListType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlPrincipalType;

public class OwCMISPermissionCollection
implements OwPermissionCollection {
    private static final Logger LOG = OwLog.getLogger(OwCMISPermissionCollection.class);
    private CmisAccessControlListType acl;
    private OwCMISResource resource;

    public OwCMISPermissionCollection(CmisAccessControlListType acl_p, OwCMISResource resource_p) {
        this.resource = resource_p;
        this.reset(acl_p);
    }

    private CmisAccessControlListType deepCopy(CmisAccessControlListType acl_p) {
        CmisAccessControlListType copy = new CmisAccessControlListType();
        List permissionsCopy = copy.getPermission();
        List permissions = acl_p.getPermission();
        for (CmisAccessControlEntryType ace : permissions) {
            CmisAccessControlEntryType aceCopy = new CmisAccessControlEntryType();
            aceCopy.setPrincipal(ace.getPrincipal());
            aceCopy.setDirect(ace.isDirect());
            List acePermissionsCopy = aceCopy.getPermission();
            acePermissionsCopy.addAll(ace.getPermission());
            permissionsCopy.add(aceCopy);
        }
        return copy;
    }

    public void reset(CmisAccessControlListType acl_p) {
        this.acl = this.deepCopy(acl_p);
    }

    private Map<String, Set<String>> mergePermissions(List<CmisAccessControlEntryType> aceList_p, Map<String, CmisAccessControlPrincipalType> principals_p) {
        HashMap<String, Set<String>> mergedPermissions = new HashMap<String, Set<String>>();
        for (CmisAccessControlEntryType ace : aceList_p) {
            CmisAccessControlPrincipalType principal = ace.getPrincipal();
            String principalDirectKey = principal.getPrincipalId() + (ace.isDirect() ? "D" : "I");
            HashSet mergedSet = (HashSet)mergedPermissions.get(principalDirectKey);
            if (mergedSet == null) {
                mergedSet = new HashSet();
                mergedPermissions.put(principalDirectKey, mergedSet);
                principals_p.put(principalDirectKey, principal);
            }
            mergedSet.addAll(ace.getPermission());
        }
        return mergedPermissions;
    }

    public CmisAccessControlListType[] diff(CmisAccessControlListType acl_p) {
        CmisAccessControlListType removedACL = new CmisAccessControlListType();
        List removedACEList = removedACL.getPermission();
        CmisAccessControlListType addedACL = new CmisAccessControlListType();
        List addedACEList = addedACL.getPermission();
        HashMap<String, CmisAccessControlPrincipalType> principals = new HashMap<String, CmisAccessControlPrincipalType>();
        List permissions = this.acl.getPermission();
        Map<String, Set<String>> mergedPermissions = this.mergePermissions(permissions, principals);
        HashMap<String, CmisAccessControlPrincipalType> principalsReference = new HashMap<String, CmisAccessControlPrincipalType>();
        List permissionsReference = acl_p.getPermission();
        Map<String, Set<String>> mergedPermissionsReference = this.mergePermissions(permissionsReference, principalsReference);
        HashSet<String> principalsSet = new HashSet<String>(mergedPermissionsReference.keySet());
        principalsSet.addAll(mergedPermissions.keySet());
        for (String principalDirectKey : principalsSet) {
            Set<String> currentPermissions = mergedPermissions.get(principalDirectKey);
            Set<String> referencePermissionsList = mergedPermissionsReference.get(principalDirectKey);
            if (currentPermissions != null && referencePermissionsList != null) {
                HashSet<String> difference = new HashSet<String>(referencePermissionsList);
                HashSet<String> added = new HashSet<String>(currentPermissions);
                HashSet<String> currentReference = new HashSet<String>(referencePermissionsList);
                currentReference.retainAll(currentPermissions);
                difference.removeAll(currentReference);
                added.removeAll(referencePermissionsList);
                if (!difference.isEmpty()) {
                    CmisAccessControlEntryType removedACE = new CmisAccessControlEntryType();
                    removedACE.setPrincipal((CmisAccessControlPrincipalType)principalsReference.get(principalDirectKey));
                    removedACE.getPermission().addAll(difference);
                    removedACE.setDirect(principalDirectKey.endsWith("D"));
                    removedACEList.add(removedACE);
                }
                if (added.isEmpty()) continue;
                CmisAccessControlEntryType addedACE = new CmisAccessControlEntryType();
                addedACE.setPrincipal((CmisAccessControlPrincipalType)principals.get(principalDirectKey));
                addedACE.getPermission().addAll(added);
                addedACE.setDirect(principalDirectKey.endsWith("D"));
                addedACEList.add(addedACE);
                continue;
            }
            if (currentPermissions == null) {
                CmisAccessControlEntryType removedACE = new CmisAccessControlEntryType();
                removedACE.setPrincipal((CmisAccessControlPrincipalType)principalsReference.get(principalDirectKey));
                removedACE.getPermission().addAll(referencePermissionsList);
                removedACE.setDirect(principalDirectKey.endsWith("D"));
                removedACEList.add(removedACE);
                continue;
            }
            CmisAccessControlEntryType addedACE = new CmisAccessControlEntryType();
            addedACE.setPrincipal((CmisAccessControlPrincipalType)principals.get(principalDirectKey));
            addedACE.getPermission().addAll(currentPermissions);
            addedACE.setDirect(principalDirectKey.endsWith("D"));
            addedACEList.add(addedACE);
        }
        return new CmisAccessControlListType[]{removedACL, addedACL};
    }

    public boolean canGetPrivileges() {
        return true;
    }

    public boolean canSetPrivileges() {
        return true;
    }

    public boolean canDenyPrivileges() {
        return false;
    }

    public Collection<OwPrivilege> getAvailablePrivileges(OwUserInfo principal_p) {
        Map<String, OwPrivilege> privilegesMap = this.resource.getAvailablePrivileges(principal_p);
        return privilegesMap.values();
    }

    public Map getAvailableInheritanceDepths() {
        return null;
    }

    public OwPrivilegeSet addPrivilegeSet(OwUserInfo principal_p, Collection privileges_p, boolean deny_p, int inheritancedepth_p) throws OwException {
        try {
            List aces = this.acl.getPermission();
            CmisAccessControlEntryType ace = new CmisAccessControlEntryType();
            ace.setDirect(true);
            CmisAccessControlPrincipalType principal = new CmisAccessControlPrincipalType();
            principal.setPrincipalId(principal_p.getUserName());
            ace.setPrincipal(principal);
            List permissions = ace.getPermission();
            for (OwPrivilege privilege : privileges_p) {
                permissions.add(privilege.getName());
            }
            aces.add(ace);
            return new OwCMISPrivilegeSet(ace, this.resource.getAvailablePrivileges());
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwInvalidOperationException("Could not add privileges", (Throwable)e);
        }
    }

    public Collection<OwCMISPrivilegeSet> getAppliedPrivilegeSets() {
        LinkedList<OwCMISPrivilegeSet> privilegeSets = new LinkedList<OwCMISPrivilegeSet>();
        List accessControlEntries = this.acl.getPermission();
        Map<String, OwPrivilege> availablePrivileges = this.resource.getAvailablePrivileges();
        for (CmisAccessControlEntryType cmisAccessControlEntry : accessControlEntries) {
            OwCMISPrivilegeSet privilegeSet = new OwCMISPrivilegeSet(cmisAccessControlEntry, availablePrivileges);
            privilegeSets.add(privilegeSet);
        }
        return privilegeSets;
    }

    public void removePrivilegeSet(OwPrivilegeSet privilegeset_p) throws OwException {
        String principalName;
        LinkedList<String> removedPermissions = new LinkedList<String>();
        Collection privileges = privilegeset_p.getPrivileges();
        for (OwPrivilege privilege : privileges) {
            removedPermissions.add(privilege.getName());
        }
        OwUserInfo principalUserInfo = privilegeset_p.getPrincipal();
        try {
            principalName = principalUserInfo.getUserName();
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException(new OwString("ecmimpl.cmis.Permissions.error", "An error occured during permissions handling."), (Throwable)e);
        }
        List accessControlEntries = this.acl.getPermission();
        LinkedList<CmisAccessControlEntryType> emptyACEs = new LinkedList<CmisAccessControlEntryType>();
        for (CmisAccessControlEntryType accessControlEntry : accessControlEntries) {
            CmisAccessControlPrincipalType principal = accessControlEntry.getPrincipal();
            if (!principal.getPrincipalId().equals(principalName)) continue;
            List livePermissions = accessControlEntry.getPermission();
            livePermissions.removeAll(removedPermissions);
            if (!livePermissions.isEmpty()) continue;
            emptyACEs.add(accessControlEntry);
        }
        accessControlEntries.removeAll(emptyACEs);
    }

    public boolean canGetPolicies() {
        return false;
    }

    public boolean canSetPolicies() {
        return false;
    }

    public boolean canAddMultiPolicy() {
        return false;
    }

    public Collection getAvailablePolicies(OwUserInfo principal_p) {
        return null;
    }

    public void addPolicy(OwPolicy policy_p) throws OwException {
    }

    public Collection getAppliedPolicies() {
        return null;
    }

    public void removePolicy(OwPolicy policy_p) throws OwException {
    }

    public OwReason canEditPermissions() {
        return OwStandardReason.ALLOWED;
    }
}

