/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.permissions;

import com.wewebu.ow.server.ecm.OwPrivilege;
import com.wewebu.ow.server.ecm.OwPrivilegeSet;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.permissions.OwCMISACLPrincipal;
import com.wewebu.ow.server.ecmimpl.cmis.permissions.OwCMISPrivilege;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlEntryType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisAccessControlPrincipalType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPermissionDefinition;

public class OwCMISPrivilegeSet
implements OwPrivilegeSet {
    private static final Logger LOG = OwLog.getLogger(OwCMISPrivilegeSet.class);
    private CmisAccessControlEntryType accessControlEntry;
    private Map<String, OwPrivilege> availablePrivileges;

    public OwCMISPrivilegeSet(CmisAccessControlEntryType accessControlEntry_p, Map<String, OwPrivilege> availablePrivileges_p) {
        this.accessControlEntry = accessControlEntry_p;
        this.availablePrivileges = availablePrivileges_p;
    }

    public OwUserInfo getPrincipal() {
        CmisAccessControlPrincipalType principal = this.accessControlEntry.getPrincipal();
        return new OwCMISACLPrincipal(principal);
    }

    public boolean isDenied() {
        return false;
    }

    public Collection<OwPrivilege> getPrivileges() {
        LinkedList<OwPrivilege> privileges = new LinkedList<OwPrivilege>();
        List acePermissions = this.accessControlEntry.getPermission();
        for (String acePermission : acePermissions) {
            OwPrivilege privilege = this.availablePrivileges.get(acePermission);
            if (privilege == null) {
                CmisAccessControlPrincipalType principal = this.accessControlEntry.getPrincipal();
                LOG.error((Object)("Invalid privilege found " + acePermission + " for principal " + principal.getPrincipalId()));
                CmisPermissionDefinition nullDefinition = new CmisPermissionDefinition();
                nullDefinition.setPermission(acePermission);
                nullDefinition.setDescription(acePermission);
                privilege = new OwCMISPrivilege(nullDefinition);
            }
            privileges.add(privilege);
        }
        return privileges;
    }

    public int getInheritanceDepth() {
        return 0;
    }

    public String toString() {
        String principal = "<null>";
        String privileges = "<null>";
        if (this.accessControlEntry != null) {
            principal = this.accessControlEntry.getPrincipal().getPrincipalId();
            privileges = this.accessControlEntry.getPermission().toString();
        }
        return "CMISPrivilegeSet[" + principal + "->" + privileges + "]";
    }
}

