/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.property;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISInternalProperty;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISInternalPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;

public class OwCMISStandardInternalProperty
extends OwCMISInternalProperty {
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardInternalProperty.class);
    private Object value;

    public OwCMISStandardInternalProperty(OwCMISObject ownerObject_p, OwCMISInternalPropertyClass internalPropertyClass_p) {
        this(ownerObject_p, internalPropertyClass_p, null);
    }

    public OwCMISStandardInternalProperty(OwCMISObject ownerObject_p, OwCMISInternalPropertyClass internalPropertyClass_p, Object initialValue_p) {
        super(ownerObject_p, internalPropertyClass_p);
        this.value = initialValue_p;
    }

    @Override
    public void addTo(CmisPropertiesType cmisPropertiesType_p) throws OwException {
        LOG.error((Object)"standard internal properties can not be added to CMIS native collections!");
        throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardInternalProperty.non.cmis.value.error", "Standard internal properties can not be added to CMIS native collections!"));
    }

    @Override
    public Object getValue() throws OwException {
        return this.value;
    }

    @Override
    public void setValue(Object value_p) throws OwException {
        this.value = value_p;
    }

    public Object getNativeObject() throws Exception {
        return this.value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("cmis-property(internal-std,");
        builder.append(this.getPropertyClass().toString());
        builder.append("),");
        Object value = "<err-value>";
        try {
            value = this.getValue();
            if (value == null) {
                value = "<null-value>";
            }
        }
        catch (OwException e) {
            LOG.error((Object)"Could not retrieve value!", (Throwable)e);
        }
        builder.append("value=");
        builder.append(value.toString());
        builder.append(")");
        return builder.toString();
    }
}

