/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.property;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISConvertFilter;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyCollectionConverter;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import java.util.Map;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;

public class OwCMISStandardPropertyCollectionConverter
implements OwCMISPropertyCollectionConverter {
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardPropertyCollectionConverter.class);
    private OwCMISConvertFilter filter;

    public OwCMISStandardPropertyCollectionConverter() {
        this(null);
    }

    public OwCMISStandardPropertyCollectionConverter(OwCMISConvertFilter filter_p) {
        this.filter = filter_p;
    }

    @Override
    public CmisPropertiesType createCmisProperties(OwPropertyCollection propertyCollection_p, OwCMISObject object_p, String resourceID_p, OwCMISNetwork network_p) throws OwException {
        try {
            ObjectFactory cmisObjectFactory = new ObjectFactory();
            CmisPropertiesType propertiesType = cmisObjectFactory.createCmisPropertiesType();
            if (propertyCollection_p != null && !propertyCollection_p.isEmpty()) {
                for (Map.Entry entry : propertyCollection_p.entrySet()) {
                    OwCMISPropertyClass cmisPropertyClass;
                    OwPropertyClass propertyClass;
                    OwProperty property = (OwProperty)entry.getValue();
                    if (this.filter != null && !this.filter.accept(property)) continue;
                    if (!(property instanceof OwCMISProperty)) {
                        propertyClass = property.getPropertyClass();
                        if (!(propertyClass instanceof OwCMISNativePropertyClass)) {
                            propertyClass = network_p.getPropertyClass(propertyClass.getClassName(), resourceID_p);
                        }
                        cmisPropertyClass = (OwCMISPropertyClass)propertyClass;
                        property = cmisPropertyClass.newProperty(object_p, property.getValue(), network_p);
                    }
                    if (property instanceof OwCMISProperty) {
                        OwCMISProperty cmisProperty = (OwCMISProperty)property;
                        cmisProperty.addTo(propertiesType);
                        continue;
                    }
                    propertyClass = property.getPropertyClass();
                    if (propertyClass instanceof OwCMISPropertyClass) {
                        cmisPropertyClass = (OwCMISPropertyClass)propertyClass;
                        OwCMISProperty cmisProperty = cmisPropertyClass.newProperty(null, property.getValue(), network_p);
                        cmisProperty.addTo(propertiesType);
                        continue;
                    }
                    String propertyClassName = "<null class>";
                    if (propertyClass != null) {
                        propertyClassName = propertyClass.getClassName();
                    }
                    LOG.debug((Object)("OwCMISStandardPropertyCollectionConverter.createCmisProperties(): skipped non CMIS property " + propertyClassName));
                }
            }
            return propertiesType;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.fatal((Object)"OwCMISStandardPropertyCollectionConverter.createCmisProperties(): Invalid property collection!", (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardPropertyCollectionConverter.invalid.property.collection.error", "Invalid property collection!"), (Throwable)e);
        }
    }
}

