/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.property;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString2;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyBoolean;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyId;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyString;

public class OwCMISStaticProperty {
    private static final Logger LOG = OwLog.getLogger(OwCMISStaticProperty.class);

    private static void checkType(CmisProperty cmisProperty_p, Class<? extends CmisProperty> expectedClass_p) throws OwInvalidOperationException {
        if (cmisProperty_p != null && !expectedClass_p.isAssignableFrom(cmisProperty_p.getClass())) {
            String msg = "Invalid property class " + cmisProperty_p.getClass() + " - " + expectedClass_p + " was expected!";
            LOG.fatal((Object)("OwCMISStaticProperty.checkType():" + msg));
            throw new OwInvalidOperationException((OwString)new OwString2("ecmimpl.cmis.OwCMISStaticProperty.checkType.error", "Invalid property class %1 - %2 was expected!", cmisProperty_p.getClass().getName(), expectedClass_p.getName()));
        }
    }

    private static <T> T getOne(List<T> valueList_p) {
        if (valueList_p == null || valueList_p.isEmpty()) {
            return null;
        }
        return valueList_p.get(0);
    }

    public static List<String> getIdValues(CmisProperty cmisProperty_p) throws OwInvalidOperationException {
        if (cmisProperty_p == null) {
            return new LinkedList<String>();
        }
        OwCMISStaticProperty.checkType(cmisProperty_p, CmisPropertyId.class);
        List values = ((CmisPropertyId)cmisProperty_p).getValue();
        return values;
    }

    public static String getIdValue(CmisProperty cmisProperty_p) throws OwInvalidOperationException {
        List<String> ids = OwCMISStaticProperty.getIdValues(cmisProperty_p);
        return OwCMISStaticProperty.getOne(ids);
    }

    public static List<Boolean> getBooleanValues(CmisProperty cmisProperty_p) throws OwInvalidOperationException {
        OwCMISStaticProperty.checkType(cmisProperty_p, CmisPropertyBoolean.class);
        List values = null;
        if (cmisProperty_p != null) {
            values = ((CmisPropertyBoolean)cmisProperty_p).getValue();
        }
        return values;
    }

    public static Boolean getBooleanValue(CmisProperty cmisProperty_p) throws OwInvalidOperationException {
        List<Boolean> booleans = OwCMISStaticProperty.getBooleanValues(cmisProperty_p);
        return OwCMISStaticProperty.getOne(booleans);
    }

    public static List<String> getStringValues(CmisProperty cmisProperty_p) throws OwInvalidOperationException {
        OwCMISStaticProperty.checkType(cmisProperty_p, CmisPropertyString.class);
        List values = null;
        if (cmisProperty_p != null) {
            values = ((CmisPropertyString)cmisProperty_p).getValue();
        }
        return values;
    }

    public static String getStringValue(CmisProperty cmisProperty_p) throws OwInvalidOperationException {
        List<String> strings = OwCMISStaticProperty.getStringValues(cmisProperty_p);
        return OwCMISStaticProperty.getOne(strings);
    }
}

