/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObject;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativeFormat;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.field.OwEnumCollection;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString2;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;
import org.oasis_open.docs.ns.cmis.core._200908.EnumUpdatability;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class OwCMISNativePropertyClass
implements OwCMISPropertyClass {
    private static final Logger LOG = OwLog.getLogger(OwCMISNativePropertyClass.class);
    private OwEnumCollection m_enums;
    private OwCMISObjectClass m_objectClass;
    private OwCMISQuerySchema propertyQuerySchema;
    private static final List<String> NAME_PROPERTY_IDS = new ArrayList<String>();

    public OwCMISNativePropertyClass(OwCMISObjectClass objectClass_p, OwCMISQuerySchema querySchema_p) {
        this.m_objectClass = objectClass_p;
        this.propertyQuerySchema = querySchema_p;
    }

    @Override
    public OwCMISNativeProperty newProperty(OwCMISObject object_p, Object value_p, OwCMISNetwork netowrk_p) throws OwException {
        OwCMISNativeProperty property = this.createProperty(null, netowrk_p);
        property.setValue(value_p);
        return property;
    }

    public abstract OwCMISNativeProperty createProperty(CmisProperty var1, OwCMISNetwork var2) throws OwInvalidOperationException;

    protected abstract OwEnumCollection createEnums() throws OwException;

    public String getCategory() throws OwException {
        return "";
    }

    public boolean isHidden(int context_p) throws OwException {
        return Boolean.FALSE;
    }

    public boolean isNameProperty() throws OwException {
        return NAME_PROPERTY_IDS.contains(this.getNativeType().getId());
    }

    public boolean isReadOnly(int context_p) throws OwException {
        boolean readonly = false;
        if (this.getNativeType().getUpdatability() != null) {
            switch (this.getNativeType().getUpdatability()) {
                case READONLY: {
                    readonly = true;
                    break;
                }
                case READWRITE: {
                    break;
                }
                case WHENCHECKEDOUT: {
                    readonly = context_p != 2;
                    break;
                }
                case ONCREATE: {
                    readonly = context_p != 1;
                    break;
                }
            }
        } else {
            LOG.debug((Object)("OwCMISNativeProperty.isReadOnly: getNativeType().getUpdatability() == null for " + this.getNonQualifiedName() + " returning default true"));
            readonly = true;
        }
        return readonly;
    }

    public boolean isSystemProperty() throws OwException {
        if (this.getNativeType().getUpdatability() == EnumUpdatability.READONLY) {
            return Boolean.TRUE;
        }
        return OwCMISPropertyNames.OBJECT_TYPE_ID.getId().equals(this.getNonQualifiedName()) || OwCMISPropertyNames.CONTENT_STREAM_FILENAME.getId().equals(this.getNonQualifiedName());
    }

    @Override
    public String getNonQualifiedName() {
        return this.getNativeType().getId();
    }

    public String getClassName() {
        return this.getFullQualifiedName();
    }

    public List<?> getComplexChildClasses() throws OwException {
        return null;
    }

    public Object getDefaultValue() throws OwException {
        return null;
    }

    public String getDescription(Locale locale_p) {
        return OwString.localize((Locale)locale_p, (String)("owlabel." + this.getClassName() + ".Desc"), (String)this.getNativeType().getDescription());
    }

    public String getDisplayName(Locale locale_p) {
        return OwString.localize((Locale)locale_p, (String)("owlabel." + this.getClassName()), (String)this.getNativeType().getDisplayName());
    }

    public OwEnumCollection getEnums() throws OwException {
        if (this.m_enums == null) {
            this.m_enums = this.createEnums();
        }
        return this.m_enums;
    }

    public abstract OwCMISNativeFormat getFormat();

    public abstract CmisPropertyDefinitionType getNativeType();

    public Node getNodeFromValue(Object value_p, Document doc_p) throws OwException {
        return value_p != null ? doc_p.createTextNode(value_p.toString()) : null;
    }

    public Object getValueFromNode(Node node_p) throws OwException {
        if (null == node_p) {
            return null;
        }
        if (node_p.getNodeType() == 3) {
            return this.getValueFromString(node_p.getNodeValue());
        }
        LOG.fatal((Object)("OwCMISNativePropertyClass.getValueFromNode(): Unsupported node type : " + node_p.getNodeType()));
        throw new OwNotSupportedException(new OwString("ecmimpl.cmis.unsupported.object.operation", "Unsupported CMIS adapter object operation!"));
    }

    public Object getValueFromString(String text_p) throws OwException {
        OwCMISNativeFormat format = this.getFormat();
        if (format == null) {
            String msg = "No OwFormat found for property class " + this.getClassName() + " @ java implementation " + this.getClass().getName();
            LOG.error((Object)("OwCMISNativePropertyClass.getValueFromString():" + msg));
            throw new OwInvalidOperationException((OwString)new OwString2("ecmimpl.cmis.OwCMISNativePropertyClass.noformat.error", "No OwFormat found for property class %1  @ java implementation %2", this.getClassName(), this.getClass().getName()));
        }
        return format.parse(text_p, this.isArray());
    }

    public boolean isArray() throws OwException {
        switch (this.getNativeType().getCardinality()) {
            case MULTI: {
                return true;
            }
        }
        return false;
    }

    public boolean isComplex() {
        return Boolean.FALSE;
    }

    public boolean isEnum() throws OwException {
        return this.getEnums() != null && !this.getEnums().isEmpty();
    }

    public boolean isRequired() throws OwException {
        return this.getNativeType().isRequired();
    }

    @Override
    public String getQueryName(OwCMISQueryContext context_p) {
        return this.propertyQuerySchema.getQueryName(context_p);
    }

    @Override
    public String getFullQualifiedName() {
        OwCMISObjectClass objectClass = this.getObjectClass();
        String objectClassName = objectClass.getClassName();
        return objectClassName + "." + this.getNonQualifiedName();
    }

    @Override
    public OwCMISObjectClass getObjectClass() {
        return this.m_objectClass;
    }

    @Override
    public boolean isQueryable(OwCMISQueryContext context_p) {
        return this.propertyQuerySchema.isQueryable(context_p);
    }

    @Override
    public boolean isOrderable() {
        return this.getNativeType().isOrderable();
    }

    public int hashCode() {
        return this.getClassName().hashCode();
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwCMISNativePropertyClass) {
            OwCMISNativePropertyClass nativeClassObject = (OwCMISNativePropertyClass)obj_p;
            return nativeClassObject.getClassName().equals(this.getClassName());
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("class(native,");
        builder.append(this.getClassName());
        builder.append(",");
        builder.append(this.getClass().getSimpleName());
        String hiddenString = "<err-hidden-status>";
        try {
            hiddenString = this.isHidden(2) ? "hidden" : "visible";
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrieve the hidden status of the class !", (Throwable)e);
        }
        builder.append(",");
        builder.append(hiddenString);
        builder.append(",queryable=");
        builder.append(this.isQueryable(OwCMISQueryContext.SQL));
        builder.append(")");
        return builder.toString();
    }

    static {
        NAME_PROPERTY_IDS.add(OwCMISPropertyNames.NAME.getId());
        NAME_PROPERTY_IDS.add("bpm:description");
    }
}

