/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetworkConfiguration;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISPreferredPropertyTypeCfg;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISChoiceBinding;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISNativePropertyBinding;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISPropertyDefinition;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQuerySchema;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativeProperty;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISNativePropertyTemplate;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISEnumTemplate;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISNativePropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwEnumCollection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

public abstract class OwCMISNativePropertyClassTemplate<L, O>
extends OwCMISNativePropertyClass {
    private static final Logger LOG = OwLog.getLogger(OwCMISNativePropertyClassTemplate.class);
    private OwCMISPropertyDefinition<L> propertyDefinition;
    private OwCMISValueConverterClass<L, O> converterClass;
    private OwCMISNetworkConfiguration networkCfg;
    private OwCMISPreferredPropertyTypeCfg.PropertyType prefferedType;

    public OwCMISNativePropertyClassTemplate(OwCMISPropertyDefinition<L> propertyDefinition_p, OwCMISValueConverterClass<L, O> converterClass_p, OwCMISObjectClass objectClass_p, OwCMISQuerySchema querySchema_p) {
        super(objectClass_p, querySchema_p);
        this.propertyDefinition = propertyDefinition_p;
        this.converterClass = converterClass_p;
    }

    public OwCMISNativePropertyClassTemplate(OwCMISPropertyDefinition<L> propertyDefinition_p, OwCMISValueConverterClass<L, O> converterClass_p, OwCMISObjectClass objectClass_p, OwCMISNetworkConfiguration networkCfg, OwCMISQuerySchema querySchema_p) {
        super(objectClass_p, querySchema_p);
        this.propertyDefinition = propertyDefinition_p;
        this.converterClass = converterClass_p;
        this.networkCfg = networkCfg;
    }

    private OwCMISPreferredPropertyTypeCfg.PropertyType getPreferredType() {
        OwCMISPreferredPropertyTypeCfg.PropertyType preferredType = null;
        if (null != this.networkCfg) {
            OwCMISPreferredPropertyTypeCfg preferredPropCfg = this.networkCfg.getPreferredPropertyTypeCfg();
            try {
                preferredType = preferredPropCfg.getPreferredType(this);
            }
            catch (OwException e) {
                LOG.error((Object)"Could not process preferred type configuration.", (Throwable)e);
            }
        }
        if (null == preferredType) {
            preferredType = OwCMISPreferredPropertyTypeCfg.PropertyType.UNSET;
        }
        return preferredType;
    }

    @Override
    public boolean isSystemProperty() throws OwException {
        if (null == this.prefferedType) {
            this.prefferedType = this.getPreferredType();
        }
        if (OwCMISPreferredPropertyTypeCfg.PropertyType.UNSET == this.prefferedType) {
            return super.isSystemProperty();
        }
        return OwCMISPreferredPropertyTypeCfg.PropertyType.SYSTEM == this.prefferedType;
    }

    @Override
    protected OwEnumCollection createEnums() throws OwException {
        OwCMISEnumTemplate booleanEnumTemplate = new OwCMISEnumTemplate();
        List<OwCMISChoiceBinding<L>> choices = this.propertyDefinition.getChoice();
        OwEnumCollection enumCollection = booleanEnumTemplate.createEnumCollection(choices, this.converterClass, this.isArray());
        return enumCollection;
    }

    @Override
    public OwCMISNativeProperty createProperty(CmisProperty property_p, OwCMISNetwork network_p) throws OwInvalidOperationException {
        OwCMISNativePropertyBinding<L> propertyBinding = this.propertyDefinition.createBoundProperty(property_p);
        OwCMISValueConverter<L, O> converter = this.converterClass.newConverter(network_p);
        OwCMISNativePropertyTemplate<L, O> templateProperty = new OwCMISNativePropertyTemplate<L, O>(propertyBinding, converter, this);
        return templateProperty;
    }

    public String getJavaClassName() {
        return this.converterClass.getOClass().getName();
    }

    @Override
    public CmisPropertyDefinitionType getNativeType() {
        return this.propertyDefinition.getNativeDefinition();
    }

    public Object getMaxValue() throws OwInvalidOperationException {
        L maxValue = this.propertyDefinition.getMaxValue();
        LinkedList<L> cmisVList = new LinkedList<L>();
        if (maxValue != null) {
            cmisVList.add(maxValue);
        }
        return this.converterClass.toStaticValue(cmisVList);
    }

    public Object getMinValue() throws OwInvalidOperationException {
        L minValue = this.propertyDefinition.getMinValue();
        LinkedList<L> cmisVList = new LinkedList<L>();
        if (minValue != null) {
            cmisVList.add(minValue);
        }
        return this.converterClass.toStaticValue(cmisVList);
    }

    protected OwCMISValueConverterClass<L, O> getConverterClass() {
        return this.converterClass;
    }
}

