/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.propertyclasses;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class OwISOSimpleFormatAdapter
extends Format {
    private static final long serialVersionUID = 1L;
    protected static final String PATTERN_FULL = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private SimpleDateFormat zoneFormat;
    private SimpleDateFormat noZoneFormat;
    private String currentZoneOffset;

    public OwISOSimpleFormatAdapter(SimpleDateFormat zoneFormat_p, SimpleDateFormat noZoneFormat_p) {
        this.zoneFormat = zoneFormat_p;
        this.noZoneFormat = noZoneFormat_p;
    }

    @Override
    public final StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return this.zoneFormat.format(obj, toAppendTo, pos);
    }

    @Override
    public final Object parseObject(String source, ParsePosition pos) {
        char zoneMark;
        Date result = null;
        String adaptedSource = source;
        SimpleDateFormat format = this.zoneFormat;
        if (source.endsWith("Z")) {
            adaptedSource = source.replace("Z", "+0000");
        }
        if (source.length() > 5 && '-' != (zoneMark = source.charAt(source.length() - 5)) && '+' != zoneMark) {
            format = this.noZoneFormat;
        }
        if ((result = format.parse(adaptedSource, pos)) != null) {
            return result;
        }
        pos.setIndex(0);
        return this.parseObjectByIdentification(source, pos);
    }

    protected Object parseObjectByIdentification(String source, ParsePosition pos) {
        String[] split = source.split("T");
        Object result = null;
        if (split.length == 2) {
            String zone;
            String time;
            StringBuilder src = new StringBuilder(split[0]);
            src.append("T");
            int idxZone = split[1].indexOf(45);
            if (idxZone > 0 || (idxZone = split[1].indexOf(43)) > 0) {
                time = split[1].substring(0, idxZone);
                zone = split[1].substring(idxZone);
            } else if (split[1].endsWith("Z")) {
                time = split[1].substring(0, split[1].length() - 1);
                zone = "+0000";
            } else {
                time = split[1];
                zone = this.currentZoneOffset;
            }
            if (time.indexOf(58) > 0) {
                src.append(time);
                if (time.indexOf(46) < 0) {
                    src.append(".000");
                }
            } else {
                for (int i = 0; i < 3; ++i) {
                    src.append(time.substring(i * 2, i * 2 + 2));
                    src.append(i == 2 ? "." : ":");
                }
                if (time.length() > 6) {
                    src.append("000");
                } else {
                    src.append(time.substring(6));
                }
            }
            SimpleDateFormat s = new SimpleDateFormat(PATTERN_FULL);
            s.setTimeZone(this.parseTimeZone(zone));
            result = s.parseObject(src.toString(), pos);
        }
        return result;
    }

    protected TimeZone parseTimeZone(String zone) {
        StringBuilder zoneDef = new StringBuilder("GMT");
        String[] split = zone.split(":");
        if (split.length == 2) {
            zoneDef.append(split[0]);
            zoneDef.append(split[1]);
        } else {
            zoneDef.append(zone);
        }
        return TimeZone.getTimeZone(zoneDef.toString());
    }
}

