/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.search;

import com.wewebu.ow.csqlc.OwCSQLCException;
import com.wewebu.ow.csqlc.OwCSQLCProcessor;
import com.wewebu.ow.csqlc.OwSQLEntitiesResolver;
import com.wewebu.ow.csqlc.ast.OwCharacterStringLiteral;
import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwColumnReference;
import com.wewebu.ow.csqlc.ast.OwCorrelatedTableName;
import com.wewebu.ow.csqlc.ast.OwFolderPredicateFormat;
import com.wewebu.ow.csqlc.ast.OwFunctionFolderFormat;
import com.wewebu.ow.csqlc.ast.OwPredicateFormat;
import com.wewebu.ow.csqlc.ast.OwSQLDateTimeLiteral;
import com.wewebu.ow.csqlc.ast.OwTextSearchPredicate;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISDateTime;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;

public class OwCMISCSQLCProcessor
extends OwCSQLCProcessor {
    private static final Logger LOG = OwLog.getLogger(OwCMISCSQLCProcessor.class);
    private static final OwFolderPredicateFormat FOLDER_FORMAT = new OwFunctionFolderFormat("IN_FOLDER", "IN_TREE");
    private static final OwPredicateFormat IN_FORMAT = new OwPredicateFormat(null, null, "IN", "NOT IN", null, null);
    private static final OwPredicateFormat QUANTIIFED_IN_FORMAT = new OwPredicateFormat("ANY", "ANY", "IN", "NOT IN", null, null);
    private static final OwPredicateFormat QUANTIIFED_COPMARISON_FORMAT = new OwPredicateFormat(null, "NOT", "= ANY", "= ANY", null, null);
    private static final OwPredicateFormat LIKE_FORMAT = new OwPredicateFormat(null, null, "LIKE", "NOT LIKE", null, null);

    public OwCMISCSQLCProcessor(OwSQLEntitiesResolver entitiesResolver_p) {
        super(entitiesResolver_p);
    }

    protected OwColumnQualifier createFromTableQualifier(String tableName_p, String typeName_p) {
        return new OwColumnQualifier(tableName_p, typeName_p);
    }

    protected OwColumnQualifier createColumnQualifier(String propertyName_p, String repositoryID_p) throws OwException {
        int dotIndex = propertyName_p.indexOf(46);
        String tableNamePart = null;
        tableNamePart = dotIndex != -1 ? propertyName_p.substring(0, dotIndex) : propertyName_p;
        String tableName = this.m_entitiesResolver.resolveQueryTableName(tableNamePart, repositoryID_p);
        if (tableName != null) {
            return new OwColumnQualifier(tableName, tableNamePart);
        }
        return null;
    }

    protected OwColumnQualifier createQueryColumnQualifier(String tableName_p, String typeName_p) {
        return new OwColumnQualifier(tableName_p, typeName_p);
    }

    protected OwColumnQualifier createQueryFieldQualifier(OwFieldDefinition fieldDefinition_p, OwCSQLCProcessor.OwProcessContext context_p) throws OwException {
        String fieldClassName = fieldDefinition_p.getClassName();
        int dotIndex = fieldClassName.indexOf(46);
        String tableNamePart = null;
        tableNamePart = dotIndex != -1 ? fieldClassName.substring(0, dotIndex) : fieldClassName;
        String tableName = this.m_entitiesResolver.resolveQueryTableName(tableNamePart, context_p.repositoryID);
        if (tableName == null) {
            String message = "The filed definition " + fieldClassName + " is not qualifiable! ";
            LOG.error((Object)("OwCMISSearchNodeSQLProcessor.createQueryFieldQualifier():" + message));
            throw new OwInvalidOperationException((OwString)new OwString1("ecmimpl.cmis.OwCMISSearchNodeSQLProcessor.non.queryable.field.error", "Invalid search field. The field %1 can not be queried.", fieldClassName));
        }
        return new OwColumnQualifier(tableName, tableNamePart);
    }

    protected OwSQLDateTimeLiteral createLiteral(OwSearchCriteria criteria_p, Date date_p) throws OwCSQLCException {
        return new OwSQLDateTimeLiteral(this.convertDate(date_p)){

            protected String asString(XMLGregorianCalendar calendar_p) {
                OwCMISDateTime cmisDateTime = new OwCMISDateTime(calendar_p);
                return cmisDateTime.toCMISDateTimeString();
            }

            protected String createLiteral(String dateString_p) {
                return "TIMESTAMP" + "'" + dateString_p + "'";
            }
        };
    }

    protected XMLGregorianCalendar convertDate(Date definedDate_p) throws OwCSQLCException {
        TimeZone from = this.m_entitiesResolver.getNetworkContext().getClientTimeZone();
        TimeZone to = TimeZone.getTimeZone("UTC");
        try {
            return OwDateTimeUtil.convertToXMLGregorianCalendar((Date)definedDate_p, (TimeZone)from, (TimeZone)to);
        }
        catch (DatatypeConfigurationException e) {
            LOG.warn((Object)"Could not convert into XMLGregorianCalendar", (Throwable)e);
            throw new OwCSQLCException("XMLGregorianCalendar error.", (Throwable)e);
        }
    }

    protected String createJoinColumnName(OwColumnQualifier qualifier_p) {
        return "cmis:objectId";
    }

    protected OwPredicateFormat getInFormat() {
        return IN_FORMAT;
    }

    protected OwPredicateFormat getQuantifiedInFormat() {
        return QUANTIIFED_IN_FORMAT;
    }

    protected OwPredicateFormat getQuantifiedComparisonFormat() {
        return QUANTIIFED_COPMARISON_FORMAT;
    }

    protected OwFolderPredicateFormat getFolderPredicateFormat() {
        return FOLDER_FORMAT;
    }

    protected OwTextSearchPredicate createTextSearchPredicate(OwCharacterStringLiteral searchExpression_p, OwColumnReference columnReference_p) throws OwException {
        if (columnReference_p != null) {
            throw new OwInvalidOperationException("Property based text search predicates are not supported.");
        }
        return new OwTextSearchPredicate(searchExpression_p, null, new OwColumnQualifier(), null);
    }

    protected String joinType(OwCorrelatedTableName joinedTable_p) {
        return "";
    }

    protected OwPredicateFormat createLikeFormat() {
        return LIKE_FORMAT;
    }

    protected String escapeNativeWildCardRepresentation(String value_p, Collection<OwWildCardDefinition> wildCardDefs) {
        for (OwWildCardDefinition def : wildCardDefs) {
            value_p = OwString.replaceAll((String)value_p, (String)def.getNativeWildCard(), (String)("\\" + def.getNativeWildCard()));
        }
        return value_p;
    }

    protected boolean isMultipleTextSearchSyntax() {
        return false;
    }
}

