/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.ui;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISLDAPCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwCMISUIUserSelectionModul
extends OwUIUserSelectModul {
    protected static final String SEARCH_FIELD_ID = "OwCMISUserSelect";
    protected static final String SEARCH_USER_LST = "OwCMISUserList";
    private static final Logger LOG = OwLog.getLogger(OwCMISUIUserSelectionModul.class);
    private String currentUserID;
    private int[] filter;
    private String lastEnteredString;
    private List<OwCMISInfoItem> infoList;

    public String getCurrentUserID() {
        return this.currentUserID;
    }

    protected void init() throws Exception {
        super.init();
        this.infoList = new LinkedList<OwCMISInfoItem>();
    }

    public void setCurrentUserID(String currentUserID_p) {
        this.currentUserID = currentUserID_p;
    }

    public int[] getFilter() {
        return this.filter;
    }

    public void setFilter(int[] filter_p) {
        this.filter = filter_p;
    }

    public void onRender(Writer w_p) throws Exception {
        w_p.write("<div id=\"OwMainContent\" class=\"OwUIUserSelectModul OwCMISUserSelectModul\">\n");
        this.renderSearchCriteriaBox(w_p);
        this.renderResultList(w_p);
        this.renderUserSelectButton(w_p);
        w_p.write("</div>");
    }

    protected void renderUserSelectButton(Writer w_p) throws IOException {
        w_p.write("<div class=\"block\"><input type=\"button\" onclick=\"");
        w_p.write(this.getFormEventURL("SelectUser", null));
        w_p.write("\" onKeyDown=\"event.cancelBubble=true\" value=\"");
        w_p.write(this.getContext().localize("cmis.ui.OwCMISUserSelectionModul.select", "Select"));
        w_p.write("\" name=\"selectUser\"/></div>\n");
    }

    protected void renderSearchCriteriaBox(Writer w_p) throws Exception {
        w_p.write("<div class=\"block\">\n");
        w_p.write("     <input type=\"text\" value=\"");
        if (this.lastEnteredString != null) {
            OwHTMLHelper.writeSecureHTML((Writer)w_p, (String)this.lastEnteredString);
        }
        w_p.write("\" name=\"");
        w_p.write(SEARCH_FIELD_ID);
        w_p.write("\"/>&nbsp;&nbsp;");
        String sSearchEventURL = this.getFormEventURL("Search", null);
        w_p.write("<input type=\"button\" name=\"Search\" onClick=\"");
        w_p.write(sSearchEventURL);
        w_p.write("\" value=\"");
        w_p.write(this.getContext().localize("cmis.ui.OwCMISUserSelectionModul.search", "Search"));
        w_p.write("\" /></div>\n");
        this.getContext().setFocusControlID(SEARCH_FIELD_ID);
        this.getContext().registerKeyEvent(13, 0, sSearchEventURL, this.getContext().localize("fncm.ui.OwFNCMUIUserSelectModul.search", "Search"));
    }

    protected void renderResultList(Writer w_p) throws OwException {
        String selectUserEvent = this.getFormEventURL("SelectUser", null);
        try {
            w_p.write("<div class=\"block\" ondblclick=\"");
            w_p.write(selectUserEvent);
            w_p.write("\">");
            w_p.write("<select class=\"OwInputfield_minWidth\" size=\"10\" ");
            w_p.write("onkeydown=\"onKey(event,13,true,function(event){");
            w_p.write(selectUserEvent);
            w_p.write("});\" name=\"");
            w_p.write(SEARCH_USER_LST);
            w_p.write("\"");
            if (this.getMultiselect()) {
                w_p.write(" multiple>");
            }
            w_p.write(">");
            List<OwCMISInfoItem> lst = this.getInfoList();
            if (lst != null) {
                for (int i = 0; i < lst.size(); ++i) {
                    OwCMISInfoItem item = lst.get(i);
                    w_p.write("<option value=\"");
                    w_p.write(Integer.toString(i));
                    w_p.write("\">");
                    w_p.write(item.getUserDisplayName());
                    w_p.write("</option>");
                }
            }
            w_p.write("</select>");
            w_p.write("</div>");
        }
        catch (IOException e) {
            LOG.fatal((Object)"Cannot write to outputstream.", (Throwable)e);
            throw new OwServerException(this.getContext().localize("cmis.ui.OwCMISUserSelectionModul.ioEx", "Cannot write to outputstream."), (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot get displayname for rendering.", (Throwable)e);
            throw new OwServerException(this.getContext().localize("cmis.ui.OwCMISUserSelectionModul.renderEx", "Cannot get displayname for rendering."), (Throwable)e);
        }
    }

    protected String usesFormWithAttributes() {
        return "";
    }

    protected String getLastEnteredString() {
        return this.lastEnteredString;
    }

    protected void setLastEneteredString(String content_p) {
        this.lastEnteredString = content_p;
    }

    protected List<OwCMISInfoItem> getInfoList() {
        return this.infoList;
    }

    public void onSearch(HttpServletRequest request_p) throws OwException {
        int[] filter;
        this.getInfoList().clear();
        this.setLastEneteredString(request_p.getParameter(SEARCH_FIELD_ID));
        if (this.getLastEnteredString() != null && (filter = this.getFilter()) != null && filter.length > 0) {
            block5: for (int i = 0; i < filter.length; ++i) {
                switch (filter[i]) {
                    case 1: {
                        this.getInfoList().addAll(this.getTypeUser());
                        continue block5;
                    }
                    case 3: {
                        this.getInfoList().addAll(this.getTypeRole());
                        continue block5;
                    }
                    case 2: {
                        this.getInfoList().addAll(this.getTypeGroup());
                        continue block5;
                    }
                    default: {
                        this.getInfoList().addAll(this.getExtendedType(filter[i]));
                    }
                }
            }
        }
    }

    public void onSelectUser(HttpServletRequest request_p) throws Exception {
        String selection = request_p.getParameter(SEARCH_USER_LST);
        if (selection.length() == 0) {
            return;
        }
        OwCMISInfoItem info = this.getInfoList().get(Integer.parseInt(selection));
        if (this.isRoleSelection()) {
            LinkedList<String> roles = new LinkedList<String>();
            roles.add(info.getUserName());
            this.getEventListner().onSelectRoles(roles);
        } else {
            LinkedList<OwUserInfo> users = new LinkedList<OwUserInfo>();
            OwUserInfo selectedUser = this.getNetwork().getUserFromID(info.getUserName());
            users.add(selectedUser);
            this.getEventListner().onSelectUsers(users);
        }
    }

    public List<OwCMISInfoItem> getTypeUser() throws OwException {
        String pattern = this.getLastEnteredString().trim();
        if (!pattern.contains("*") && 0 != pattern.length()) {
            pattern = "*" + pattern + "*";
        }
        return this.findUsersMatching(pattern);
    }

    public List<OwCMISInfoItem> getTypeGroup() throws OwException {
        return this.requestLdap(3);
    }

    private List<OwCMISInfoItem> requestLdap(int type_p) throws OwException {
        OwCMISNetwork network = this.getCurrentNetwork();
        OwCMISLDAPCredentials cred = (OwCMISLDAPCredentials)network.getCredentials();
        OwLdapConnector con = cred.getLdapConnector();
        String val = con.findDistinguishedNameAnonymously(this.getLastEnteredString());
        LinkedList<OwCMISInfoItem> lst = new LinkedList<OwCMISInfoItem>();
        if (val != null) {
            if (type_p == 3) {
                lst.add(this.createGroupInfo(val));
            } else {
                lst.add(this.createUserInfo(val));
            }
        }
        return lst;
    }

    private List<OwCMISInfoItem> findUsersMatching(String pattern) throws OwException {
        OwCMISNetwork network = this.getCurrentNetwork();
        OwCMISLDAPCredentials cred = (OwCMISLDAPCredentials)network.getCredentials();
        OwLdapConnector con = cred.getLdapConnector();
        OwObjectCollection dnames = con.findUserDNsMatching(pattern);
        LinkedList<OwCMISInfoItem> lst = new LinkedList<OwCMISInfoItem>();
        for (Object dname : dnames) {
            String displayName = con.getUserDisplayName((String)dname);
            lst.add(new OwCMISInfoItem((String)dname, displayName, 2));
        }
        try {
            if (!dnames.isComplete()) {
                OwMainAppContext ctx = (OwMainAppContext)this.getContext();
                String msg = ctx.localize1("owsearch.OwResultListView.notcomplete", "The result list does not contain all results. Only the first %1 are displayed.", String.valueOf(dnames.size()));
                ctx.postMessage(msg);
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new OwServerException("Fata; error!", (Throwable)e);
        }
        return lst;
    }

    public List<OwCMISInfoItem> getTypeRole() throws OwException {
        OwCMISNetwork network = this.getCurrentNetwork();
        OwCMISLDAPCredentials cred = (OwCMISLDAPCredentials)network.getCredentials();
        OwLdapConnector con = cred.getLdapConnector();
        try {
            LinkedList<OwCMISInfoItem> lst = new LinkedList<OwCMISInfoItem>();
            String last = this.getLastEnteredString().replaceAll("[:*:]", ".+");
            for (String val : this.getDefaultRoleNames()) {
                if (!val.matches(last)) continue;
                lst.add(this.createRoleInfo(val));
            }
            Collection col = con.getAllShortGroupNames();
            if (col != null) {
                for (String val : col) {
                    OwCMISInfoItem group;
                    if (!val.matches(last) || lst.contains(group = this.createGroupInfo(val))) continue;
                    lst.add(group);
                }
            }
            return lst;
        }
        catch (Exception e) {
            throw new OwServerException("Cannot retrieve RoleInformation", (Throwable)e);
        }
    }

    public boolean isRoleSelection() {
        int[] filter = this.getFilter();
        for (int i = 0; i < filter.length; ++i) {
            if (filter[i] != 3) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List<OwCMISInfoItem> getExtendedType(int extendedType_p) {
        return new LinkedList<OwCMISInfoItem>();
    }

    protected OwCMISNetwork getCurrentNetwork() {
        return (OwCMISNetwork)this.getNetwork();
    }

    protected OwCMISInfoItem createGroupInfo(String name_p) {
        return new OwCMISInfoItem(name_p, 3);
    }

    protected OwCMISInfoItem createUserInfo(String name_p) {
        return new OwCMISInfoItem(name_p, 2);
    }

    protected OwCMISInfoItem createRoleInfo(String name_p) {
        return new OwCMISInfoItem(name_p, 1);
    }

    protected static class OwCMISInfoItem {
        public static final int ROLE = 1;
        public static final int USER = 2;
        public static final int GROUP = 3;
        private int type;
        private String name;
        private String displayName;

        public OwCMISInfoItem(String name_p, int type) {
            this(name_p, name_p, type);
        }

        public OwCMISInfoItem(String name_p, String displayName, int type) {
            this.name = name_p;
            this.type = type;
            this.displayName = displayName;
        }

        public String getUserDisplayName() throws Exception {
            return this.displayName;
        }

        public String getUserName() throws Exception {
            return this.name;
        }

        public boolean isGroup() throws Exception {
            return this.type == 3;
        }

        public int getType() {
            return this.type;
        }

        public int hashCode() {
            return 31 * (31 + (this.name == null ? 0 : this.name.hashCode())) + this.type;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            OwCMISInfoItem other = (OwCMISInfoItem)obj;
            if (this.getType() != other.getType()) {
                return false;
            }
            if (this.name == null) {
                return other.name == null;
            }
            return this.name.equals(other.name);
        }
    }
}

