/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.util;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Logger;

public class OwCMISDateTime {
    private static Logger LOG = OwLog.getLogger(OwCMISDateTime.class);
    private static final int MS_PER_MIN = 60000;
    private XMLGregorianCalendar m_calendar;

    public OwCMISDateTime(String dateLexicalRepresentation_p) throws OwInvalidOperationException {
        try {
            char middleZoneMark;
            char zoneMark;
            String representation = dateLexicalRepresentation_p;
            if (representation != null && representation.length() > 5 && ((zoneMark = representation.charAt(representation.length() - 5)) == '+' || zoneMark == '-') && (middleZoneMark = representation.charAt(representation.length() - 3)) != ':') {
                representation = new StringBuffer(representation).insert(representation.length() - 2, ":").toString();
            }
            DatatypeFactory factory = DatatypeFactory.newInstance();
            this.m_calendar = factory.newXMLGregorianCalendar(representation);
        }
        catch (Exception e) {
            String msg = "Could not parse date lexical representation :" + dateLexicalRepresentation_p;
            LOG.error((Object)("OwCMISDateTime.OwCMISDateTime():" + msg));
            throw new OwInvalidOperationException((OwString)new OwString1("ecmimpl.cmis.OwCMISDateTime.date.parse.error", "Invalid date/time format: %1", dateLexicalRepresentation_p), (Throwable)e);
        }
    }

    public OwCMISDateTime(XMLGregorianCalendar calendar_p) {
        this.m_calendar = calendar_p;
    }

    public OwCMISDateTime(Date date_p) throws OwInvalidOperationException {
        this(date_p, TimeZone.getDefault(), false);
    }

    public OwCMISDateTime(Date date_p, TimeZone timeZone_p) throws OwInvalidOperationException {
        this(date_p, timeZone_p, false);
    }

    public OwCMISDateTime(Date date_p, TimeZone timeZone_p, boolean ignoreDateZone_p) throws OwInvalidOperationException {
        DatatypeFactory factory;
        try {
            factory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            LOG.error((Object)"OwCMISDateTime.<init>(Date date_p, TimeZone timeZone_p, boolean ignoreDateZone_p):", (Throwable)e);
            throw new OwInvalidOperationException("Cannot create Datatype Factory for conversion.", (Throwable)e);
        }
        Calendar calendar = Calendar.getInstance();
        Date theDate = date_p;
        if (!ignoreDateZone_p) {
            int zoneRawOffset = timeZone_p.getRawOffset();
            int dateRawOffset = calendar.getTimeZone().getRawOffset();
            long zoneTime = date_p.getTime() + (long)zoneRawOffset - (long)dateRawOffset;
            theDate.setTime(zoneTime);
        }
        calendar.setTime(theDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int millisecond = calendar.get(14);
        int offsetInMinutes = timeZone_p.getRawOffset() / 60000;
        this.m_calendar = factory.newXMLGregorianCalendar(year, month, day, hour, minute, second, millisecond, offsetInMinutes);
    }

    public String toCMISDateTimeString() {
        return this.toCMISDateTimeString(false);
    }

    public String toISODateTimeString() {
        return this.toISODateTimeString(false);
    }

    public String toISODateTimeString(boolean omitTimeZone_p) {
        String isoString = this.toCMISDateTimeString(omitTimeZone_p);
        if (!omitTimeZone_p) {
            int mark = isoString.length() - 3;
            isoString = new StringBuffer(isoString).replace(mark, mark + 1, "").toString();
        }
        return isoString;
    }

    public String toCMISDateTimeString(boolean omitTimeZone_p) {
        XMLGregorianCalendar calendar = this.getXMLGregorianCalendar(omitTimeZone_p);
        return calendar.toXMLFormat();
    }

    public Date getDate(boolean ignoreTimeZone_p) {
        Calendar calendar = this.getCalendar();
        calendar.setTimeZone(TimeZone.getDefault());
        if (!ignoreTimeZone_p) {
            calendar.setTimeZone(this.getTimeZone());
        }
        return calendar.getTime();
    }

    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        TimeZone timeZone = this.m_calendar.getTimeZone(Integer.MIN_VALUE);
        calendar.setTimeZone(timeZone);
        calendar.set(1, this.m_calendar.getYear());
        calendar.set(2, this.m_calendar.getMonth() - 1);
        calendar.set(5, this.m_calendar.getDay());
        calendar.set(11, this.m_calendar.getHour());
        calendar.set(12, this.m_calendar.getMinute());
        calendar.set(13, this.m_calendar.getSecond());
        calendar.set(14, this.m_calendar.getMillisecond());
        return calendar;
    }

    public XMLGregorianCalendar getXMLGregorianCalendar() {
        return this.m_calendar;
    }

    public XMLGregorianCalendar getXMLGregorianCalendar(boolean ignoreTimeZone_p) {
        if (ignoreTimeZone_p) {
            XMLGregorianCalendar calendarCopy = (XMLGregorianCalendar)this.m_calendar.clone();
            calendarCopy.setTimezone(Integer.MIN_VALUE);
            return calendarCopy;
        }
        return this.m_calendar;
    }

    public TimeZone getTimeZone() {
        return this.m_calendar.getTimeZone(Integer.MIN_VALUE);
    }

    public String toString() {
        return this.m_calendar == null ? "<null calendar>" : this.toCMISDateTimeString();
    }

    public int hashCode() {
        return this.m_calendar.hashCode();
    }

    public boolean equals(Object obj_p) {
        if (obj_p instanceof OwCMISDateTime) {
            OwCMISDateTime dateTimeObj = (OwCMISDateTime)obj_p;
            if (this.m_calendar == null || dateTimeObj.m_calendar == null) {
                return this.m_calendar == dateTimeObj.m_calendar;
            }
            return this.m_calendar.equals(dateTimeObj.m_calendar);
        }
        return false;
    }
}

