/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.util;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISDMSIDDecoder;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISSimpleDMSID;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwCMISIDDMSIDConverter
implements OwCMISValueConverter<String, String>,
OwCMISValueConverterClass<String, String> {
    private static final Logger LOG = OwLog.getLogger(OwCMISIDDMSIDConverter.class);
    protected OwCMISDMSIDDecoder dmsidDecoder;
    protected String resourceID;

    public OwCMISIDDMSIDConverter(OwCMISDMSIDDecoder dmsidDecoder_p, String resourceID_p) {
        this.dmsidDecoder = dmsidDecoder_p;
        this.resourceID = resourceID_p;
    }

    public List<String> fromArrayValue(String[] owdValue_p) throws OwInvalidOperationException {
        if (owdValue_p != null) {
            LinkedList<String> list = new LinkedList<String>();
            for (int i = 0; i < owdValue_p.length; ++i) {
                try {
                    OwCMISDMSID dmsid = this.dmsidDecoder.createDMSID(owdValue_p[i]);
                    list.add(dmsid.getCMISID());
                    continue;
                }
                catch (OwException e) {
                    LOG.error((Object)("OwCMISIdDMSIDConverter.fromArrayValue(): Invalid DMSID value : " + owdValue_p[i]));
                    throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISIdDMSIDConverter.invalid.dmsid.error", "Invalid DMSID found!"), (Throwable)e);
                }
            }
            return list;
        }
        return null;
    }

    @Override
    public List<String> fromValue(String owdValue_p) throws OwInvalidOperationException {
        if (owdValue_p != null) {
            try {
                OwCMISDMSID dmsid = this.dmsidDecoder.createDMSID(owdValue_p);
                LinkedList<String> list = new LinkedList<String>();
                list.add(dmsid.getCMISID());
                return list;
            }
            catch (OwException e) {
                LOG.error((Object)("OwCMISIdDMSIDConverter.fromArrayValue(): Invalid DMSID value : " + owdValue_p));
                throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISIdDMSIDConverter.invalid.dmsid.error", "Invalid DMSID found!"), (Throwable)e);
            }
        }
        return new LinkedList<String>();
    }

    @Override
    public Class<String> getOClass() {
        return String.class;
    }

    public String[] toArrayValue(List<String> cmisValue_p) {
        if (cmisValue_p.isEmpty()) {
            return null;
        }
        String[] stringValues = new String[cmisValue_p.size()];
        for (int i = 0; i < stringValues.length; ++i) {
            String id = cmisValue_p.get(i);
            OwCMISDMSID dmsid = this.fromID(id);
            stringValues[i] = dmsid.getDMSIDString();
        }
        return stringValues;
    }

    protected OwCMISDMSID fromID(String id_p) {
        return new OwCMISSimpleDMSID(this.dmsidDecoder.getDMSIDPrefix(), this.resourceID, id_p);
    }

    @Override
    public String toValue(List<String> cmisValue_p) {
        if (cmisValue_p.isEmpty()) {
            return null;
        }
        String id = cmisValue_p.get(0);
        OwCMISDMSID dmsid = this.fromID(id);
        return dmsid.getDMSIDString();
    }

    @Override
    public OwCMISValueConverterClass<String, String> getConverterClass() {
        return this;
    }

    @Override
    public OwCMISValueConverter<String, String> newConverter(OwCMISNetwork network_p) {
        return this;
    }

    public String[] toStaticArrayValue(List<String> cmisValue_p) throws OwInvalidOperationException {
        if (cmisValue_p.isEmpty()) {
            return null;
        }
        String[] stringValues = new String[cmisValue_p.size()];
        for (int i = 0; i < stringValues.length; ++i) {
            String id = cmisValue_p.get(i);
            OwCMISSimpleDMSID dmsid = new OwCMISSimpleDMSID(this.dmsidDecoder.getDMSIDPrefix(), this.resourceID, id);
            stringValues[i] = dmsid.getDMSIDString();
        }
        return stringValues;
    }

    @Override
    public String toStaticValue(List<String> cmisValue_p) throws OwInvalidOperationException {
        if (cmisValue_p.isEmpty()) {
            return null;
        }
        String id = cmisValue_p.get(0);
        OwCMISSimpleDMSID dmsid = new OwCMISSimpleDMSID(this.dmsidDecoder.getDMSIDPrefix(), this.resourceID, id);
        return dmsid.getDMSIDString();
    }
}

