/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.util;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISObjectModel;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISResource;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISQueryContext;
import com.wewebu.ow.server.ecmimpl.cmis.objectclasses.OwCMISObjectClass;
import com.wewebu.ow.server.ecmimpl.cmis.propertyclasses.OwCMISPropertyClass;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwString;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class OwCMISPropertiesFilter {
    private static final Logger LOG = OwLog.getLogger(OwCMISPropertiesFilter.class);
    private Map<String, String> queryNamesToRequestNames = new HashMap<String, String>();
    private Set<String> queryNames = new HashSet<String>();
    private boolean ignoreNonQueryable = true;
    private boolean ignoreDuplicates = true;

    public OwCMISPropertiesFilter() {
        this(true, true);
    }

    public OwCMISPropertiesFilter(boolean ignoreNonQueryable_p, boolean ignoreDuplicates_p) {
        this.ignoreDuplicates = ignoreDuplicates_p;
        this.ignoreNonQueryable = ignoreNonQueryable_p;
    }

    public Set<String> getQueryNames() {
        return this.queryNames;
    }

    public Map<String, String> getActualNamesMap() {
        return this.queryNamesToRequestNames;
    }

    public String getFilterString() {
        StringBuilder filter = new StringBuilder();
        for (String rString : this.queryNames) {
            if (rString != null && rString.length() > 0 && filter.length() != 0) {
                filter.append(',');
            }
            filter.append(rString);
        }
        return filter.toString();
    }

    private void addAll(OwCMISQueryContext context_p, Map<String, OwCMISPropertyClass> propertyClasses_p) throws OwInvalidOperationException {
        Set<Map.Entry<String, OwCMISPropertyClass>> propertyEntries = propertyClasses_p.entrySet();
        for (Map.Entry<String, OwCMISPropertyClass> entry : propertyEntries) {
            String actualName = entry.getKey();
            OwCMISPropertyClass propertyClass = entry.getValue();
            if (propertyClass.isQueryable(context_p)) {
                String queryName = propertyClass.getQueryName(context_p);
                this.add(queryName, actualName);
                continue;
            }
            String msg = "Non qeryable property added " + propertyClass.toString() + " with context " + (Object)((Object)context_p);
            LOG.warn((Object)("OwCMISPropertiesFilter.addAll(): " + msg));
            if (this.ignoreNonQueryable) continue;
            throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISPropertiesFilter.non.queryable.property.error", "Invalid property used for CMIS filtering!"));
        }
    }

    private void add(String queryName_p, String actualName_p) throws OwInvalidOperationException {
        if (this.queryNamesToRequestNames.containsKey(queryName_p)) {
            if (LOG.isDebugEnabled()) {
                StringBuffer msg = new StringBuffer("Duplicate property ").append(queryName_p).append("->").append(this.queryNamesToRequestNames.get(queryName_p));
                LOG.debug((Object)("OwCMISPropertiesFilter.add(): " + msg));
            }
            if (!this.ignoreDuplicates) {
                throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISPropertiesFilter.duplicate.property.error", "Duplicate property used for CMIS filtering!"));
            }
        }
        this.queryNames.add(queryName_p);
        this.queryNamesToRequestNames.put(queryName_p, actualName_p);
    }

    public void add(String queryName_p) throws OwInvalidOperationException {
        this.add(queryName_p, queryName_p);
    }

    public void addAll(OwCMISQueryContext context_p, OwCMISObjectClass objectClass_p, Collection<String> propertyClasses_p) throws OwException {
        HashMap<String, OwCMISPropertyClass> propertiesMap = new HashMap<String, OwCMISPropertyClass>();
        for (String propertyString : propertyClasses_p) {
            OwCMISPropertyClass propertyClass = objectClass_p.getPropertyClass(propertyString);
            propertiesMap.put(propertyString, propertyClass);
        }
        this.addAll(context_p, propertiesMap);
    }

    public void addAll(OwCMISQueryContext context_p, String className_p, Collection<String> propertyClasses_p, OwCMISResource resource_p) throws OwException {
        OwCMISObjectModel objectModel = resource_p.getObjectModel();
        OwCMISObjectClass objectClass = objectModel.getObjectClass(className_p);
        this.addAll(context_p, objectClass, propertyClasses_p);
    }

    public void addAll(OwCMISQueryContext context_p, Collection<String> propertyClasses_p, OwCMISObjectClass defaultClass_p, OwCMISResource resource_p) throws OwException {
        if (propertyClasses_p == null) {
            return;
        }
        HashMap<String, OwCMISPropertyClass> propertiesMap = new HashMap<String, OwCMISPropertyClass>();
        OwCMISObjectModel objectModel = resource_p.getObjectModel();
        for (String propertyClassName : propertyClasses_p) {
            OwCMISPropertyClass propertyClass = null;
            propertyClass = propertyClassName.contains(".") ? objectModel.getPropertyClass(propertyClassName) : (defaultClass_p != null ? defaultClass_p.getPropertyClass(propertyClassName) : objectModel.getPropertyClass(propertyClassName));
            propertiesMap.put(propertyClassName, propertyClass);
        }
        this.addAll(context_p, propertiesMap);
    }

    public void addAll(OwCMISQueryContext context_p, Collection<OwCMISPropertyClass> propertyClasses_p) throws OwException {
        HashMap<String, OwCMISPropertyClass> propertiesMap = new HashMap<String, OwCMISPropertyClass>();
        for (OwCMISPropertyClass propertyClass : propertyClasses_p) {
            propertiesMap.put(propertyClass.getClassName(), propertyClass);
        }
        this.addAll(context_p, propertiesMap);
    }
}

