/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.util;

import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverter;
import com.wewebu.ow.server.ecmimpl.cmis.generic.OwCMISValueConverterClass;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISDateTime;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import javax.xml.datatype.XMLGregorianCalendar;

public class OwCMISStandardDateConverter
implements OwCMISValueConverter<XMLGregorianCalendar, Date>,
OwCMISValueConverterClass<XMLGregorianCalendar, Date> {
    private TimeZone timeZone;

    public OwCMISStandardDateConverter(TimeZone timezone) {
        this.timeZone = timezone;
    }

    private XMLGregorianCalendar toXMLGregorianCalendar(Date date_p) throws OwInvalidOperationException {
        OwCMISDateTime cmisDateTime = new OwCMISDateTime(date_p);
        XMLGregorianCalendar xlmGCalendar = cmisDateTime.getXMLGregorianCalendar(true);
        xlmGCalendar.setTimezone(this.getTimeZone().getOffset(date_p.getTime()) / 60000);
        return xlmGCalendar;
    }

    private Date toDate(XMLGregorianCalendar xmlCalendar_p) {
        if (xmlCalendar_p == null) {
            return null;
        }
        OwCMISDateTime cmisDateTime = new OwCMISDateTime(xmlCalendar_p);
        TimeZone tzServer = xmlCalendar_p.getTimeZone(0);
        return OwDateTimeUtil.convert((Date)cmisDateTime.getDate(true), (TimeZone)tzServer, (TimeZone)this.getTimeZone());
    }

    public List<XMLGregorianCalendar> fromArrayValue(Date[] owdValue_p) throws OwInvalidOperationException {
        if (owdValue_p != null) {
            LinkedList<XMLGregorianCalendar> cmisCalendarList = new LinkedList<XMLGregorianCalendar>();
            for (int i = 0; i < owdValue_p.length; ++i) {
                XMLGregorianCalendar xlmGCalendar = this.toXMLGregorianCalendar(owdValue_p[i]);
                cmisCalendarList.add(xlmGCalendar);
            }
            return cmisCalendarList;
        }
        return new LinkedList<XMLGregorianCalendar>();
    }

    @Override
    public List<XMLGregorianCalendar> fromValue(Date owdValue_p) throws OwInvalidOperationException {
        LinkedList<XMLGregorianCalendar> cmisCalendarList = new LinkedList<XMLGregorianCalendar>();
        if (owdValue_p != null) {
            cmisCalendarList.add(this.toXMLGregorianCalendar(owdValue_p));
        }
        return cmisCalendarList;
    }

    public Date[] toArrayValue(List<XMLGregorianCalendar> cmisValue_p) {
        return this.toStaticArrayValue(cmisValue_p);
    }

    @Override
    public Date toValue(List<XMLGregorianCalendar> cmisValue_p) {
        return this.toStaticValue((List)cmisValue_p);
    }

    @Override
    public Class<Date> getOClass() {
        return Date.class;
    }

    @Override
    public OwCMISValueConverter<XMLGregorianCalendar, Date> newConverter(OwCMISNetwork network_p) {
        return this;
    }

    public Date[] toStaticArrayValue(List<XMLGregorianCalendar> cmisValue_p) {
        if (cmisValue_p.isEmpty()) {
            return null;
        }
        Date[] dateValues = new Date[cmisValue_p.size()];
        for (int i = 0; i < dateValues.length; ++i) {
            XMLGregorianCalendar calendarValue = cmisValue_p.get(i);
            dateValues[i] = this.toDate(calendarValue);
        }
        return dateValues;
    }

    @Override
    public Date toStaticValue(List<XMLGregorianCalendar> cmisValue_p) {
        if (cmisValue_p.isEmpty()) {
            return null;
        }
        return this.toDate(cmisValue_p.get(0));
    }

    @Override
    public OwCMISValueConverterClass<XMLGregorianCalendar, Date> getConverterClass() {
        return this;
    }

    protected TimeZone getTimeZone() {
        return this.timeZone;
    }
}

