/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyDefinitionType;

public class OwPropertyDefinitionHelper {
    public static boolean isDifferent(CmisPropertyDefinitionType a, CmisPropertyDefinitionType b) {
        if (a.getId().equals(b.getId()) && a.getPropertyType().equals((Object)b.getPropertyType()) && a.getCardinality().equals((Object)b.getCardinality()) && a.getQueryName() != null && b.getQueryName() != null && a.getQueryName().equals(b.getQueryName())) {
            return OwPropertyDefinitionHelper.isInheritanceDifferent(a, b);
        }
        return true;
    }

    public static boolean isInheritanceDifferent(CmisPropertyDefinitionType a, CmisPropertyDefinitionType b) {
        if (a.getUpdatability().equals((Object)b.getUpdatability()) && a.isOrderable() == b.isOrderable() && a.isRequired() == b.isRequired()) {
            List<?> choicesA = OwPropertyDefinitionHelper.getChoices(a);
            List<?> choicesB = OwPropertyDefinitionHelper.getChoices(b);
            if ((choicesA == null || choicesA.isEmpty()) && (choicesB == null || choicesB.isEmpty())) {
                List<?> alst = OwPropertyDefinitionHelper.getDefaultValue(a);
                List<?> blst = OwPropertyDefinitionHelper.getDefaultValue(b);
                if (alst == null && blst == null) {
                    return false;
                }
                if (alst != null && blst != null && alst.size() == blst.size()) {
                    return false;
                }
            } else if (choicesA != null && choicesB != null) {
                if (a.isOpenChoice() != null && b.isOpenChoice() != null && a.isOpenChoice().equals(b.isOpenChoice())) {
                    List<?> aChoice = choicesA;
                    List<?> bChoice = choicesB;
                    if (aChoice.size() == bChoice.size()) {
                        return false;
                    }
                } else if (a.isOpenChoice() == null && b.isOpenChoice() == null) {
                    return false;
                }
            }
        }
        return true;
    }

    private static List<?> getChoices(CmisPropertyDefinitionType a) {
        try {
            Method getChoicesM = a.getClass().getMethod("getChoice", new Class[0]);
            List result = (List)getChoicesM.invoke((Object)a, new Object[0]);
            return result;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private static List<?> getDefaultValue(CmisPropertyDefinitionType a) {
        try {
            Method getChoicesM = a.getClass().getMethod("getDefaultValue", new Class[0]);
            Object def = getChoicesM.invoke((Object)a, new Object[0]);
            if (null == def) {
                return null;
            }
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(def);
            return result;
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }
}

