/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.version;

import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISCredentials;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISExceptionCatcher;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISNetwork;
import com.wewebu.ow.server.ecmimpl.cmis.OwCMISUserInfo;
import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import com.wewebu.ow.server.ecmimpl.cmis.object.OwCMISDocumentObject;
import com.wewebu.ow.server.ecmimpl.cmis.property.OwCMISPropertyNames;
import com.wewebu.ow.server.ecmimpl.cmis.util.OwCMISPropertiesFilter;
import com.wewebu.ow.server.ecmimpl.cmis.version.OwCMISStandardVersion;
import com.wewebu.ow.server.ecmimpl.cmis.version.OwCMISStandardVersionSeries;
import com.wewebu.ow.server.ecmimpl.cmis.version.OwCMISVersionModel;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.util.OwString;
import java.util.List;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertiesType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisProperty;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.ws._200908.CmisException;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;
import org.oasis_open.docs.ns.cmis.ws._200908.VersioningServicePort;

public class OwCMISStandardVersionModel
implements OwCMISVersionModel {
    private static final Logger LOG = OwLog.getLogger(OwCMISStandardVersionModel.class);
    public static final String STANDARD_VERSION_FILTER;

    @Override
    public OwVersionSeries createVersionSeries(OwCMISDocumentObject documentObject_p, OwCMISNetwork network_p) throws OwException {
        return new OwCMISStandardVersionSeries(documentObject_p, network_p);
    }

    @Override
    public CmisObjectType retriveOWDObjectVersion(OwCMISNetwork network_p, String repositoryId_p, CmisObjectType cmisObject_p) throws OwException {
        Boolean versionCheckedOut = OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getBooleanValue(cmisObject_p);
        if (versionCheckedOut == null) {
            String id = OwCMISPropertyNames.OBJECT_ID.getIdValue(cmisObject_p);
            if (id == null) {
                LOG.error((Object)"Object is incomplete loaded, even cmis:objectId is missing");
                throw new OwInvalidOperationException(network_p.getContext().localize("OwCMISStandardVersionModel.retriveOWDObjectVersion.error.noId", "Object is incomplete loaded, even cmis:objectId is missing"));
            }
            try {
                CmisPropertiesType lst = network_p.getObjectServicePort().getProperties(repositoryId_p, id, STANDARD_VERSION_FILTER.toString(), null);
                List properties = lst.getProperty();
                cmisObject_p.getProperties().getProperty().addAll(properties);
            }
            catch (CmisException e) {
                OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, network_p.getLocale());
                throw catcher.toOwException();
            }
            versionCheckedOut = OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getBooleanValue(cmisObject_p);
            if (versionCheckedOut == null) {
                LOG.error((Object)"Object is incomplete loaded, cmis server does not return cmis:isVersionSeriesCheckedOut property!");
                throw new OwServerException(network_p.getContext().localize("OwCMISStandardVersionModel.retriveOWDObjectVersion.error.missingProp", "Object is incomplete loaded, cmis server does not return cmis:isVersionSeriesCheckedOut property!"));
            }
        }
        if (versionCheckedOut.booleanValue()) {
            OwCMISUserInfo userInfo;
            String checkedOutUserId = OwCMISPropertyNames.VERSION_SERIES_CHECKED_OUT_BY.getStringValue(cmisObject_p);
            OwCMISCredentials credentials = network_p.getCredentials();
            try {
                userInfo = credentials.getUserInfo();
            }
            catch (OwException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)"OwCMISStandardVersionModel.retriveOWDObjectVersion():Could not retrieve Workdesk version beacause the user info could not be accessed!", (Throwable)e);
                throw new OwInvalidOperationException(new OwString("ecmimpl.cmis.OwCMISStandardVersionModel.retriveOWDObjectVersion.cmis.error", "Could not retrieve Workdesk version!"), (Throwable)e);
            }
            String userName = userInfo.getUserName();
            if (checkedOutUserId != null && checkedOutUserId.equals(userName)) {
                String versioSeriesId = OwCMISPropertyNames.VERSION_SERIES_ID.getIdValue(cmisObject_p);
                VersioningServicePort versionService = network_p.getVersionServicePort();
                try {
                    cmisObject_p = versionService.getObjectOfLatestVersion(repositoryId_p, versioSeriesId, Boolean.valueOf(false), "cmis:objectId,cmis:objectTypeId", Boolean.valueOf(true), EnumIncludeRelationships.BOTH, "", Boolean.valueOf(true), Boolean.valueOf(true), null);
                }
                catch (CmisException e) {
                    OwNetworkContext context = network_p.getContext();
                    OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
                    LOG.error((Object)("OwCMISStandardVersionModel.retriveOWDObjectVersion(): Could not retrieve Workdesk version! A CMIS error occurred : " + catcher.getLogMessage()));
                    throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersionModel.retriveOWDObjectVersion.cmis.error", "Could not retrieve Workdesk version!"), true);
                }
            }
        }
        return cmisObject_p;
    }

    @Override
    public OwVersion createVersion(OwCMISNetwork network_p, OwCMISDocumentObject documentObject_p) throws OwException {
        String resourceId = documentObject_p.getResourceID();
        String objectId = documentObject_p.getDecodedID();
        ObjectServicePort objectService = network_p.getObjectServicePort();
        OwCMISPropertiesFilter filter = new OwCMISPropertiesFilter();
        filter.add(OwCMISPropertyNames.OBJECT_ID.getId());
        filter.add(OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getId());
        filter.add(OwCMISPropertyNames.VERSION_SERIES_CHECKED_OUT_BY.getId());
        filter.add(OwCMISPropertyNames.VERSION_SERIES_ID.getId());
        filter.add(OwCMISPropertyNames.IS_IMMUTABLE.getId());
        filter.add(OwCMISPropertyNames.IS_MAJOR_VERSION.getId());
        filter.add(OwCMISPropertyNames.VERSION_LABEL.getId());
        filter.add(OwCMISPropertyNames.CHANGE_TOKEN.getId());
        CmisPropertiesType props = documentObject_p.getNativeObject().getProperties();
        for (CmisProperty prop : props.getProperty()) {
            if (!filter.getQueryNames().contains(prop.getQueryName()) && !filter.getQueryNames().contains(prop.getPropertyDefinitionId())) continue;
            filter.getQueryNames().remove(prop.getQueryName());
            filter.getQueryNames().remove(prop.getPropertyDefinitionId());
            if (filter.getQueryNames().size() != 0) continue;
            break;
        }
        try {
            if (filter.getQueryNames().size() > 0) {
                String strFilter = filter.getFilterString();
                LOG.debug((Object)("OwCMISStandardVersionModel.createVersion: requesting additional infos for versioning props = " + strFilter));
                props = objectService.getProperties(resourceId, objectId, strFilter, null);
                documentObject_p.getNativeObject().getProperties().getProperty().addAll(props.getProperty());
            }
            return new OwCMISStandardVersion(documentObject_p.getNativeObject(), network_p, resourceId);
        }
        catch (CmisException e) {
            OwNetworkContext context = network_p.getContext();
            OwCMISExceptionCatcher catcher = new OwCMISExceptionCatcher(e, context.getLocale());
            LOG.error((Object)("Could not create version! A CMIS error occurred : " + catcher.getLogMessage()), (Throwable)e);
            throw catcher.toOwException(context.localize("ecmimpl.cmis.OwCMISStandardVersionModel.createVersion.cmis.error", "Could not create version!"), true);
        }
    }

    static {
        try {
            OwCMISPropertiesFilter filter = new OwCMISPropertiesFilter();
            filter.add(OwCMISPropertyNames.OBJECT_ID.getId());
            filter.add(OwCMISPropertyNames.OBJECT_TYPE_ID.getId());
            filter.add(OwCMISPropertyNames.IS_VERSION_SERIES_CHECKED_OUT.getId());
            filter.add(OwCMISPropertyNames.VERSION_SERIES_ID.getId());
            filter.add(OwCMISPropertyNames.VERSION_SERIES_CHECKED_OUT_BY.getId());
            filter.add(OwCMISPropertyNames.VERSION_LABEL.getId());
            filter.add(OwCMISPropertyNames.IS_LATEST_VERSION.getId());
            filter.add(OwCMISPropertyNames.IS_MAJOR_VERSION.getId());
            filter.add(OwCMISPropertyNames.CONTENT_STREAM_MIME_TYPE.getId());
            filter.add(OwCMISPropertyNames.CONTENT_STREAM_ID.getId());
            filter.add(OwCMISPropertyNames.CHANGE_TOKEN.getId());
            STANDARD_VERSION_FILTER = filter.getFilterString();
        }
        catch (OwInvalidOperationException e) {
            throw new RuntimeException("Could not initialize the standard version property filter !", e);
        }
    }
}

