/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.cmis.wshandler;

import com.wewebu.ow.server.ecmimpl.cmis.log.OwLog;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.apache.log4j.Logger;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisContentStreamType;

public class OwCMISContentHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger LOG = OwLog.getLogger(OwCMISContentHandler.class);
    public static final String SYS_PROP_OWD_CMIS_SKIPMETROSOAPATTACHMENTFIX = "owd.cmis.skipMetroSOAPAttachmentFix";

    public static boolean isSkipMetroSOAPAttachmentFix() {
        boolean result = Boolean.getBoolean(SYS_PROP_OWD_CMIS_SKIPMETROSOAPATTACHMENTFIX);
        return result;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext msgCtx_p) {
    }

    public boolean handleFault(SOAPMessageContext msgCtx_p) {
        return false;
    }

    public boolean handleMessage(SOAPMessageContext msgCtx_p) {
        block6: {
            if (Boolean.TRUE.equals(msgCtx_p.get((Object)"javax.xml.ws.handler.message.outbound"))) {
                try {
                    if (OwCMISContentHandler.isSkipMetroSOAPAttachmentFix() || !this.processContent(msgCtx_p) || !msgCtx_p.containsKey((Object)"CMIS_CONTENT_TRANSFER")) break block6;
                    DataHandler dh = (DataHandler)msgCtx_p.get((Object)"CMIS_CONTENT_TRANSFER");
                    try {
                        SOAPMessage soapMessage = msgCtx_p.getMessage();
                        AttachmentPart attPart = soapMessage.createAttachmentPart(dh);
                        String attachID = Long.toHexString(System.currentTimeMillis()) + "@alfresco.com";
                        attPart.setContentId(attachID);
                        SOAPBody body = soapMessage.getSOAPBody();
                        SOAPElement elem = (SOAPElement)body.getFirstChild();
                        Iterator it = elem.getChildElements();
                        while (it.hasNext() && !(elem = (SOAPElement)it.next()).getLocalName().equals("contentStream")) {
                        }
                        elem = elem.getPrefix() == null ? elem.addChildElement(new QName(elem.getNamespaceURI(), "stream")) : elem.addChildElement(new QName(elem.getNamespaceURI(), "stream", elem.getPrefix()));
                        elem = elem.addChildElement(new QName("http://www.w3.org/2004/08/xop/include", "Include", "xop"));
                        elem.addNamespaceDeclaration("xop", "http://www.w3.org/2004/08/xop/include");
                        elem.addAttribute(new QName("href"), "cid:" + attachID);
                        soapMessage.addAttachmentPart(attPart);
                        msgCtx_p.remove((Object)"CMIS_CONTENT_TRANSFER");
                    }
                    catch (SOAPException soapEx) {
                        msgCtx_p.remove((Object)"CMIS_CONTENT_TRANSFER");
                        LOG.error((Object)"Could not create SOAP Attachment", (Throwable)soapEx);
                        return Boolean.FALSE;
                    }
                }
                catch (SOAPException soapEx) {
                    LOG.error((Object)"Could not request SOAP operation, processing for content stopped!", (Throwable)soapEx);
                    return false;
                }
            }
        }
        return Boolean.TRUE;
    }

    protected String getMethods() {
        return "createDocument, setContentStream, checkIn";
    }

    protected boolean processContent(SOAPMessageContext msgCtx_p) throws SOAPException {
        QName qnMethod = (QName)msgCtx_p.get((Object)"javax.xml.ws.wsdl.operation");
        if (qnMethod != null) {
            return this.getMethods().contains(qnMethod.getLocalPart());
        }
        SOAPMessage soapMessage = msgCtx_p.getMessage();
        return this.getMethods().contains(soapMessage.getSOAPBody().getFirstChild().getLocalName());
    }

    public static void setAttachmentToContext(CmisContentStreamType content_p, BindingProvider bindingProvider) {
        if (OwCMISContentHandler.isSkipMetroSOAPAttachmentFix()) {
            return;
        }
        Map map = bindingProvider.getRequestContext();
        if (content_p != null) {
            DataHandler dh = content_p.getStream();
            map.put("CMIS_CONTENT_TRANSFER", dh);
            content_p.setStream(null);
        } else if (map.containsKey("CMIS_CONTENT_TRANSFER")) {
            map.remove("CMIS_CONTENT_TRANSFER");
        }
    }
}

