/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwSelectList;
import com.wewebu.ow.csqlc.ast.OwSelectSublist;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;

public class OwCompoundSelectList
implements OwSelectList {
    private List<OwSelectSublist> m_sublists = new ArrayList<OwSelectSublist>();

    public void add(OwSelectSublist sublist_p) {
        this.m_sublists.add(sublist_p);
    }

    @Override
    public StringBuilder createSelectListSQLString() {
        if (this.m_sublists.size() > 0) {
            OwSelectSublist zeroSublist = this.m_sublists.get(0);
            StringBuilder zeroBuilder = zeroSublist.createSelectListSQLString();
            LinkedHashSet<String> uniqueSublists = new LinkedHashSet<String>();
            uniqueSublists.add(zeroBuilder.toString());
            for (int i = 1; i < this.m_sublists.size(); ++i) {
                OwSelectSublist sublist = this.m_sublists.get(i);
                StringBuilder subString = sublist.createSelectListSQLString();
                uniqueSublists.add(subString.toString());
            }
            StringBuilder builder = new StringBuilder();
            Iterator ui = uniqueSublists.iterator();
            String firstSub = (String)ui.next();
            builder.append(firstSub);
            while (ui.hasNext()) {
                String sub = (String)ui.next();
                builder.append(",");
                builder.append(sub);
            }
            return builder;
        }
        return new StringBuilder();
    }

    @Override
    public List<OwColumnQualifier> getColumnQualifiers() {
        LinkedList<OwColumnQualifier> qualifiers = new LinkedList<OwColumnQualifier>();
        for (OwSelectSublist sub : this.m_sublists) {
            qualifiers.addAll(sub.getColumnQualifiers());
        }
        return qualifiers;
    }

    @Override
    public boolean containsColumnReference(String tableName, String columnReferenceName) {
        for (OwSelectSublist sublist : this.m_sublists) {
            if (!sublist.containsColumnReference(tableName, columnReferenceName)) continue;
            return true;
        }
        return false;
    }
}

