/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.csqlc.ast;

import com.wewebu.ow.csqlc.ast.OwColumnQualifier;
import com.wewebu.ow.csqlc.ast.OwCorrelatedTableName;
import com.wewebu.ow.csqlc.ast.OwJoinSpecification;
import com.wewebu.ow.csqlc.ast.OwMergeType;
import com.wewebu.ow.csqlc.ast.OwOrderByClause;
import com.wewebu.ow.csqlc.ast.OwRepositoryTarget;
import com.wewebu.ow.csqlc.ast.OwSimpleTable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OwQueryStatement {
    private OwSimpleTable m_simpleTable;
    private OwOrderByClause m_orderByClause = null;
    private Map<String, OwColumnQualifier> m_normalizedQualifiers;
    private OwRepositoryTarget m_repositoryTarget;

    public OwQueryStatement(OwRepositoryTarget repositoryTarget_p, OwSimpleTable simpleTable_p) {
        this(repositoryTarget_p, simpleTable_p, null);
    }

    public OwQueryStatement(OwRepositoryTarget repositoryTarget_p, OwSimpleTable simpleTable_p, OwOrderByClause orderByClause_p) {
        this.m_simpleTable = simpleTable_p;
        this.m_orderByClause = orderByClause_p;
        this.m_repositoryTarget = repositoryTarget_p;
    }

    public String getTargetRepositoryID() {
        return this.m_repositoryTarget.getRepositoryId();
    }

    public OwMergeType getMergeType() {
        return this.m_repositoryTarget.getMergeType();
    }

    public StringBuilder createSQLString() {
        StringBuilder builder = this.m_simpleTable.createSimpleTableSQLString();
        if (this.m_orderByClause != null && this.m_orderByClause.isValid()) {
            builder.append(" ");
            builder.append((CharSequence)this.m_orderByClause.createOrderByClauseSQLString());
        }
        return builder;
    }

    public List<OwColumnQualifier> getColumnQualifiers() {
        LinkedList<OwColumnQualifier> qualifiers = null;
        qualifiers = this.m_orderByClause != null ? new LinkedList<OwColumnQualifier>(this.m_orderByClause.getColumnQualifiers()) : new LinkedList<OwColumnQualifier>();
        qualifiers.addAll(this.m_simpleTable.getColumnQualifiers());
        return qualifiers;
    }

    public String toString() {
        return this.createSQLString().toString();
    }

    public OwColumnQualifier getMainTableQualifier() {
        return this.m_simpleTable.getMainTableQualifier();
    }

    public void addJoin(OwCorrelatedTableName joinedTableReference_p, OwJoinSpecification joinSpec_p) {
        this.m_simpleTable.addJoin(joinedTableReference_p, joinSpec_p);
    }

    public void setNormalizedQualifiers(Set<OwColumnQualifier> qualifiers_p) {
        this.m_normalizedQualifiers = new HashMap<String, OwColumnQualifier>();
        for (OwColumnQualifier qualifier : qualifiers_p) {
            this.m_normalizedQualifiers.put(qualifier.getQualifierString(), qualifier);
        }
    }

    public Map<String, OwColumnQualifier> getNormalizedQualifiers() {
        return this.m_normalizedQualifiers;
    }

    public OwSimpleTable getSimpleTable() {
        return this.m_simpleTable;
    }
}

