/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ecm.OwAttributeBagResolver;
import com.wewebu.ow.server.ecm.OwAttributeBagsSupport;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBag;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import org.apache.log4j.Logger;

public class OwDBAttributeBagsSupport
implements OwAttributeBagsSupport {
    private static final Logger LOG = OwLogCore.getLogger(OwDBAttributeBagsSupport.class);
    private OwAttributeBagResolver attributeBagResolver = new OwAttributeBagResolver();

    public static OwDBAttributeBagsSupport createAndCheckDBSupport(OwNetworkContext networkContext_p) throws OwNotSupportedException {
        OwAttributeBagResolver.createAndCheckResolver(networkContext_p);
        return new OwDBAttributeBagsSupport();
    }

    @Override
    public OwAttributeBag getNameKeyAttributeBag(OwNetworkContext networkContext_p, String name_p, String userID_p) throws OwException {
        try {
            return this.attributeBagResolver.getNameKeyAttributeBag(networkContext_p, name_p, userID_p);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Could not resolve name key bage name=" + name_p + ";userID=" + userID_p;
            LOG.error((Object)("OwDBAttributeBagsSupport.getNameKeyAttributeBag:" + msg), (Throwable)e);
            throw new OwInvalidOperationException(networkContext_p.localize2("ecmimpl.AttributeBagsSupport.getNameKeyAttributeBag.error", "Could not resolve name key bag name=%1;userID=%2", name_p, userID_p), (Throwable)e);
        }
    }

    @Override
    public OwAttributeBagWriteable getUserKeyAttributeBagWriteable(OwNetworkContext networkContext_p, String name_p, String userID_p) throws OwException {
        try {
            return this.attributeBagResolver.getUserKeyAttributeBagWriteable(networkContext_p, name_p, userID_p);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Could not resolve user key bage name=" + name_p + ";userID=" + userID_p;
            LOG.error((Object)("OwDBAttributeBagsSupport.getUserKeyAttributeBag:" + msg), (Throwable)e);
            throw new OwInvalidOperationException(networkContext_p.localize2("ecmimpl.AttributeBagsSupport.getUserKeyAttributeBag.error", "Could not resolve user key bag name=%1;userID=%2", name_p, userID_p), (Throwable)e);
        }
    }

    public String toString() {
        return "OwDBAttributeBagsSupport";
    }
}

