/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOManager;
import com.wewebu.ow.server.ao.OwAOManagerRegistry;
import com.wewebu.ow.server.ao.OwSearchTemplatesManager;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwDefaultRegistry
implements OwAOManagerRegistry {
    private static final Logger LOG = OwLogCore.getLogger(OwSearchTemplatesManager.class);
    private Map<Integer, OwAOManager> managers = new HashMap<Integer, OwAOManager>();

    public synchronized void registerManager(OwAOManager manager_p) throws OwInvalidOperationException {
        int managedType = manager_p.getManagedType();
        if (this.managers.containsKey(managedType)) {
            String msg = "Mutiple managers are registered for the same application object type " + manager_p.getManagedType();
            LOG.error((Object)("OwStandardRegistry.registerManager():" + msg));
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.registry.error", "Invalid application object manager registry operation!"));
        }
        this.managers.put(managedType, manager_p);
        LOG.debug((Object)("OwStandardRegistry.registerManager() : manager for AO type " + managedType + " configured as " + manager_p));
    }

    public synchronized void replaceManager(OwAOManager manager_p) throws OwInvalidOperationException {
        int managedType = manager_p.getManagedType();
        if (LOG.isDebugEnabled()) {
            OwAOManager oldManager = this.managers.get(managedType);
            LOG.debug((Object)("OwStandardRegistry.replaceManager(): about to replace manager for AO type " + managedType + " old=" + oldManager + " new=" + manager_p));
        }
        this.managers.put(managedType, manager_p);
        LOG.debug((Object)("OwStandardRegistry.registerManager() : manager for AO type " + managedType + " configured as " + manager_p));
    }

    @Override
    public synchronized OwAOManager getManager(int type_p) throws OwInvalidOperationException {
        OwAOManager manager = this.managers.get(type_p);
        if (manager == null) {
            String msg = "No managers for application objects of type " + type_p + " are registered!";
            LOG.error((Object)("OwStandardRegistry.getManager():" + msg));
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.registry.error", "Invalid application object manager registry operation!"));
        }
        return manager;
    }
}

