/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwFileObject;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwNetworkConfiguration;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class OwFileAOSupport
implements OwAOSupport {
    private static final Logger LOG = OwLogCore.getLogger(OwFileAOSupport.class);
    private String defaultLocation;
    public static final char PATH_SEPARATOR = '/';
    private String basePath;
    private String userID;
    private OwNetwork network;
    private String location;

    public OwFileAOSupport(OwNetwork network_p, OwNetworkConfiguration configuration_p, String defaultLocation_p) throws OwException {
        try {
            this.defaultLocation = defaultLocation_p;
            this.network = network_p;
            OwCredentials credentials = network_p.getCredentials();
            OwUserInfo userInfo = credentials.getUserInfo();
            this.userID = userInfo.getUserID();
            OwNetworkContext context = network_p.getContext();
            this.basePath = context.getBasePath();
            this.location = configuration_p.getApplicationObjectBaseDir(this.defaultLocation);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrieve credentials information...", (Throwable)e);
            throw new OwInvalidOperationException(network_p.getContext().localize("ecmimpl.OwFileAOSupport.credentials.error", "Could not retrieve credentials information!"), (Throwable)e);
        }
    }

    @Override
    public OwObject[] getSupportObjects(String strName_p, boolean forceUserspecificObject_p, boolean createIfNotExist_p) throws OwException {
        File folder = this.getSupportFile(strName_p, forceUserspecificObject_p, createIfNotExist_p, false);
        File[] siteFiles = folder.listFiles();
        if (siteFiles == null) {
            return new OwFileObject[0];
        }
        OwObject[] objects = new OwObject[siteFiles.length];
        if (siteFiles.length > 0) {
            for (int i = 0; i < siteFiles.length; ++i) {
                File file = siteFiles[i];
                if (file.isHidden()) continue;
                try {
                    objects[i] = new OwFileObject(this.network, file, file.getName());
                    continue;
                }
                catch (OwException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not read application object file: " + file), (Throwable)e);
                }
            }
        }
        return objects;
    }

    @Override
    public OwObject getSupportObject(String strName_p, boolean forceUserspecificObject_p, boolean createIfNotExist_p) throws OwException {
        File file = this.getSupportFile(strName_p, forceUserspecificObject_p, createIfNotExist_p, true);
        try {
            return new OwFileObject(this.network, file, file.getName());
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("Could not create OwFileObject for " + strName_p + ", forceUsersSpecificObject=" + forceUserspecificObject_p + " , createIfNotExist=" + createIfNotExist_p), (Throwable)e);
            throw new OwInvalidOperationException(this.network.getContext().localize1("ecmimpl.OwFileAOSupport.getSupportObject.error", "Could not create file application object for %1.", strName_p), (Throwable)e);
        }
    }

    public File getSupportFile(String strName_p, boolean forceUserspecificObject_p, boolean createIfNotExist_p, boolean isFile_p) throws OwException {
        File file;
        StringBuffer strFilePath;
        if (this.location.equals(this.defaultLocation)) {
            strFilePath = new StringBuffer(this.basePath.replace('\\', '/'));
            if (strFilePath.charAt(strFilePath.length() - 1) != '/') {
                strFilePath.append('/');
            }
            strFilePath.append(this.location);
        } else if (this.location.indexOf("/WEB-INF/") == 0 || this.location.indexOf("WEB-INF/") == 0) {
            strFilePath = new StringBuffer(this.basePath.replace('\\', '/'));
            if (strFilePath.charAt(strFilePath.length() - 1) != '/') {
                strFilePath.append('/');
            }
            strFilePath.append(this.location);
        } else {
            strFilePath = new StringBuffer(this.location.replace('\\', '/'));
        }
        if (strFilePath.charAt(strFilePath.length() - 1) == '/') {
            strFilePath.append(strName_p);
        } else {
            strFilePath.append('/');
            strFilePath.append(strName_p);
        }
        if (forceUserspecificObject_p) {
            strFilePath.append("_");
            try {
                String filePath = URLEncoder.encode(this.userID, "UTF-8");
                strFilePath.append(filePath);
            }
            catch (UnsupportedEncodingException e) {
                throw new OwServerException("Could not encode file path.");
            }
        }
        if (!(file = new File(strFilePath.toString())).exists() && createIfNotExist_p) {
            if (isFile_p) {
                try {
                    LOG.info((Object)("OwFileAOSupport.getSupportFile: The file was successfully created: " + file.createNewFile()));
                }
                catch (IOException e) {
                    LOG.fatal((Object)("Could not create file: " + strFilePath), (Throwable)e);
                    throw new OwServerException(this.network.getContext().localize1("ecmimpl.OwFileAOSupport.create.file.error", "Error creating file %1", strFilePath.toString()), (Throwable)e);
                }
            } else {
                LOG.info((Object)("OwFileAOSupport.getSupportFile: File structure successfully created: " + file.mkdirs()));
            }
        }
        return file;
    }

    public String toString() {
        return "OwFileAOSupport(basePath=" + this.basePath + ";location=" + this.location + ";userID=" + this.userID + ")";
    }
}

