/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import org.apache.log4j.Logger;

public class OwRepositoryAOSupport
implements OwAOSupport {
    private static final char PATH_SEPARATOR = '/';
    private static final Logger LOG = OwLogCore.getLogger(OwRepositoryAOSupport.class);
    private OwNetwork network;
    private String path;
    private int[] objectTypes;
    private int versionSelection;
    private String aoClassName;
    private String pathSeparator = "/";
    private int maxSize;

    public OwRepositoryAOSupport(OwNetwork network_p, String path_p, int[] objectTypes_p, int versionSelection_p, String aoClassName_p) {
        this(network_p, path_p, objectTypes_p, versionSelection_p, aoClassName_p, Integer.MAX_VALUE);
    }

    public OwRepositoryAOSupport(OwNetwork network_p, String path_p, int[] objectTypes_p, int versionSelection_p, String aoClassName_p, int maxSize_p) {
        this.network = network_p;
        this.path = path_p;
        this.objectTypes = objectTypes_p;
        this.versionSelection = versionSelection_p;
        this.aoClassName = aoClassName_p;
        this.maxSize = maxSize_p;
    }

    @Override
    public OwObject getSupportObject(String strName_p, boolean forceUserspecificObject_p, boolean createIfNotExist_p) throws OwException {
        String name = strName_p;
        if (forceUserspecificObject_p) {
            try {
                name = name + "_";
                OwCredentials credentials = this.network.getCredentials();
                OwUserInfo userInfo = credentials.getUserInfo();
                String userID = userInfo.getUserID();
                name = name + userID;
            }
            catch (Exception e) {
                String message = "Could not retrieve user support info for object named " + strName_p + " in " + this.path;
                LOG.error((Object)message, (Throwable)e);
                throw new OwObjectNotFoundException(message, (Throwable)e);
            }
        }
        String objectPath = this.path + this.pathSeparator + name;
        try {
            return this.network.getObjectFromPath(objectPath, true);
        }
        catch (OwObjectNotFoundException e) {
            if (createIfNotExist_p) {
                try {
                    OwObject aoParent = this.network.getObjectFromPath(this.path, true);
                    OwResource resource = aoParent.getResource();
                    OwObjectClass aoClass = this.network.getObjectClass(this.aoClassName, resource);
                    String namePropertyName = aoClass.getNamePropertyName();
                    OwPropertyClass namePropertyClass = aoClass.getPropertyClass(namePropertyName);
                    OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
                    OwStandardProperty nameProperty = new OwStandardProperty(name, namePropertyClass);
                    properties.put(namePropertyName, nameProperty);
                    String newAODMSID = this.network.createNewObject(true, null, resource, this.aoClassName, properties, null, null, aoParent, null, null);
                    OwObject newApplicationObject = this.network.getObjectFromDMSID(newAODMSID, true);
                    LOG.debug((Object)("New AO object created with DMSID " + newAODMSID + " for " + objectPath));
                    return newApplicationObject;
                }
                catch (OwException owe) {
                    throw owe;
                }
                catch (Exception ce) {
                    String message = "Could not create support object at " + objectPath;
                    LOG.error((Object)message, (Throwable)ce);
                    throw new OwServerException(message, (Throwable)ce);
                }
            }
            throw e;
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            String message = "Could not retrieve support object at " + objectPath;
            LOG.error((Object)message, (Throwable)e);
            throw new OwObjectNotFoundException(message, (Throwable)e);
        }
    }

    @Override
    public OwObject[] getSupportObjects(String strName_p, boolean forceUserspecificObject_p, boolean createIfNotExist_p) throws OwException {
        String folderPath = this.path + "/" + strName_p;
        try {
            OwObject folder = this.network.getObjectFromPath(folderPath, true);
            OwObjectCollection children = folder.getChilds(this.objectTypes, null, null, this.getMaxSize(), this.versionSelection, null);
            return children.toArray(new OwObject[children.size()]);
        }
        catch (OwException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OwServerException("Could not retrieve support object at " + folderPath, (Throwable)e);
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize_p) {
        this.maxSize = maxSize_p;
    }
}

