/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwSearchTemplateFactory;
import com.wewebu.ow.server.ao.OwSupportBasedManager;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class OwSearchTemplatesManager
extends OwSupportBasedManager {
    private static final Logger LOG = OwLogCore.getLogger(OwSearchTemplatesManager.class);
    private OwSearchTemplateFactory searchTemplateFactory;
    private String singlePath = "";
    private String multiplePath = "";

    public OwSearchTemplatesManager(OwAOSupport aoSupport_p, OwSearchTemplateFactory searchTemplateFactory_p) {
        this(aoSupport_p, "", searchTemplateFactory_p, "", "");
    }

    public OwSearchTemplatesManager(OwAOSupport aoSupport_p, String basePath_p, OwSearchTemplateFactory searchTemplateFactory_p, String singlePath_p, String multiplePath_p) {
        super(aoSupport_p, basePath_p);
        this.searchTemplateFactory = searchTemplateFactory_p;
        this.singlePath = singlePath_p;
        this.multiplePath = multiplePath_p;
    }

    @Override
    public OwSearchTemplate getApplicationObject(String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        if (param_p != null) {
            LOG.error((Object)"OwSearchTemplatesManager.getApplicationObject(): Invalid application object request!Could not process non null search template parameter - not implemented!");
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.invalid.application.object.request", "Invalid application object request!"));
        }
        OwObject supportObject = this.getAOSupportObject(this.aoPath(this.singlePath, strName_p), forceUserSpecificObject_p, createIfNotExist_p);
        return this.searchTemplateFactory.createSearchTemplate(supportObject);
    }

    private String aoPath(String cardinalityPath_p, String strName_p) {
        String aoPath = null;
        aoPath = cardinalityPath_p != null && cardinalityPath_p.length() > 0 ? cardinalityPath_p + "/" + strName_p : strName_p;
        return aoPath;
    }

    @Override
    public OwSearchTemplate getApplicationObject(String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        return this.getApplicationObject(strName_p, null, forceUserSpecificObject_p, createIfNotExist_p);
    }

    public Collection<OwSearchTemplate> getApplicationObjects(String strName_p, boolean forceUserSpecificObject_p) throws OwException {
        OwObject[] supportObjects = this.getAOSupportObjects(this.aoPath(this.multiplePath, strName_p), forceUserSpecificObject_p, false);
        LinkedList<OwSearchTemplate> searchTemplatesCollection = new LinkedList<OwSearchTemplate>();
        for (int i = 0; i < supportObjects.length; ++i) {
            if (supportObjects[i] == null) continue;
            OwSearchTemplate searchTemplate = this.searchTemplateFactory.createSearchTemplate(supportObjects[i]);
            searchTemplatesCollection.add(searchTemplate);
        }
        return searchTemplatesCollection;
    }

    @Override
    public int getManagedType() {
        return 3;
    }

    @Override
    public String toString() {
        return "OwSearchTemplatesManager(searchTemplateFactory=" + this.searchTemplateFactory + ")->" + super.toString();
    }
}

