/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ao;

import com.wewebu.ow.server.ao.OwAOSupport;
import com.wewebu.ow.server.ao.OwDefaultAOManager;
import com.wewebu.ow.server.ao.OwSupportBasedManager;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class OwXMLAOManager
extends OwSupportBasedManager {
    private static final Logger LOG = OwLogCore.getLogger(OwDefaultAOManager.class);
    public static final String DEFAULT_BASE_PATH = "other";

    public OwXMLAOManager(OwAOSupport aoSupport_p) {
        this(aoSupport_p, DEFAULT_BASE_PATH);
    }

    public OwXMLAOManager(OwAOSupport aoSupport_p, String basePath_p) {
        super(aoSupport_p, basePath_p);
    }

    private Document toXMLDocumet(OwObject object_p) throws OwException {
        InputStream in = null;
        try {
            OwContentCollection contentCollection = object_p.getContentCollection();
            OwContentElement firstContentElement = contentCollection.getContentElement(1, 1);
            in = firstContentElement.getContentStream(null);
        }
        catch (OwException se) {
            throw se;
        }
        catch (Exception e) {
            String msg = "Error getting XML content collection from server.";
            LOG.fatal((Object)("OwXMLAOManager.toXMLDocumet():" + msg), (Throwable)e);
            throw new OwServerException(new OwString("ecmimpl.OwXMLAOManager.xml.stream.error", "Error getting XML content collection from server!"), (Throwable)e);
        }
        Document document = null;
        try {
            document = OwXMLDOMUtil.getDocumentFromInputStream(in);
        }
        catch (Exception e) {
            String msg = "XML file cannot be read, probably due to a syntax error!";
            LOG.fatal((Object)("OwXMLAOManager.toXMLDocumet():" + msg), (Throwable)e);
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwXMLAOManager.xml.document.error", "XML file cannot be read due to a syntax error."), (Throwable)e);
        }
        return document;
    }

    @Override
    public Document getApplicationObject(String strName_p, Object param_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        if (param_p != null) {
            LOG.error((Object)"OwXMLAOManager.getApplicationObject():Could not process non null XML object parameter - not implemented !");
            throw new OwInvalidOperationException(new OwString("ecmimpl.OwAOManager.invalid.application.object.request", "Invalid application object request!"));
        }
        OwObject object = this.getAOSupportObject(strName_p, forceUserSpecificObject_p, createIfNotExist_p);
        return this.toXMLDocumet(object);
    }

    @Override
    public Document getApplicationObject(String strName_p, boolean forceUserSpecificObject_p, boolean createIfNotExist_p) throws OwException {
        return this.getApplicationObject(strName_p, null, forceUserSpecificObject_p, createIfNotExist_p);
    }

    public Collection<Document> getApplicationObjects(String strName_p, boolean forceUserSpecificObject_p) throws OwException {
        OwObject[] objects = this.getAOSupportObjects(strName_p, forceUserSpecificObject_p, false);
        LinkedList<Document> documents = new LinkedList<Document>();
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] == null) continue;
            Document document = this.toXMLDocumet(objects[i]);
            documents.add(document);
        }
        return documents;
    }

    @Override
    public int getManagedType() {
        return 4;
    }

    @Override
    public String toString() {
        return "OwXMLAOManager->" + super.toString();
    }
}

