/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwToolExtension;
import com.wewebu.ow.server.dmsdialogs.views.OwToolViewItem;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLUtil;
import org.apache.log4j.Logger;

public abstract class OwAbstractToolExtension
implements OwToolExtension,
OwToolViewItem {
    private static final Logger LOG = OwLogCore.getLogger(OwAbstractToolExtension.class);
    protected static final String EXTENSION_PREFIX = "extension.";
    protected static final String DESCRIPTION_SUFFIX = ".description";
    protected static final String TITLE_SUFFIX = ".title";
    protected OwMainAppContext m_context;
    protected OwXMLUtil m_confignode;
    protected String m_icon;
    protected String m_bigIcon;
    protected String m_title;
    protected String m_description;
    protected String m_jspForm;
    protected String m_id;

    @Override
    public void init(OwXMLUtil confignode_p, OwMainAppContext context_p) throws Exception {
        this.m_context = context_p;
        this.m_confignode = confignode_p;
        this.m_id = this.m_confignode.getSafeTextValue("id", this.getDefaultId());
        this.m_icon = this.m_confignode.getSafeTextValue("icon", this.getDefaultIcon());
        this.m_bigIcon = this.m_confignode.getSafeTextValue("iconbig", this.getDefaultBigIcon());
        this.m_title = this.localize(EXTENSION_PREFIX, this.m_confignode.getSafeTextValue("Name", this.getDefaultTitle()), TITLE_SUFFIX);
        this.m_description = this.localize(EXTENSION_PREFIX, this.m_confignode.getSafeTextValue("Description", this.getDefaultDescription()), DESCRIPTION_SUFFIX);
        this.m_jspForm = this.m_confignode.getSafeTextValue("JspForm", null);
    }

    protected String getDefaultDescription() {
        return "";
    }

    protected String getDefaultTitle() {
        return "";
    }

    protected abstract String getDefaultBigIcon();

    protected abstract String getDefaultIcon();

    protected String getDefaultId() {
        return this.getClass().getName();
    }

    private String localize(String extensionPrefix_p, String defaultValue_p, String suffix_p) {
        String key = extensionPrefix_p + this.m_id + suffix_p;
        return this.m_context.localize(key, defaultValue_p);
    }

    @Override
    public String getIcon() {
        return this.createURL(this.m_icon);
    }

    @Override
    public String getBigIcon() {
        return this.createURL(this.m_bigIcon);
    }

    private String createURL(String designPath_p) {
        String theURL = "";
        try {
            theURL = this.m_context.getDesignURL() + designPath_p;
        }
        catch (Exception e) {
            LOG.error((Object)"Could not get design URL!", (Throwable)e);
        }
        return theURL;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    @Override
    public String getId() {
        return this.m_id;
    }
}

