/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import java.io.File;
import java.io.FilenameFilter;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwAppEdition {
    private String footerLocalized = "footerVersion";
    private String setupVersionLocalized = "setupVersionLocalized";
    protected static final Logger LOG = OwLogCore.getLogger(OwAppEdition.class);

    public String getEditionFooter(OwAppContext mainContext_p, HttpServletRequest request_p) throws Exception {
        this.footerLocalized = this.footerLocalized + mainContext_p.getLocale();
        this.setupVersionLocalized = this.setupVersionLocalized + mainContext_p.getLocale();
        this.setupEdition(mainContext_p, request_p);
        return (String)request_p.getSession().getAttribute(this.footerLocalized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupEdition(OwAppContext mainContext_p, HttpServletRequest request_p) throws Exception {
        if (!Boolean.valueOf((String)request_p.getSession().getAttribute(this.setupVersionLocalized)).booleanValue()) {
            String specificationVersion = "undefined";
            String implementationVersion = "undefined";
            ZipFile jar = null;
            try {
                String libURL = request_p.getSession().getServletContext().getRealPath("/WEB-INF/lib");
                File libFolder = new File(libURL);
                String[] jars = new String[]{};
                if (libFolder.isDirectory()) {
                    jars = libFolder.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir_p, String name_p) {
                            return name_p.startsWith("ow_core_") && name_p.endsWith("jar");
                        }
                    });
                }
                if (jars.length > 0) {
                    String ow_core = jars[0];
                    LOG.debug((Object)("Get the path of the ow_core lib: getSession().getServletContext().getRealPath(\"/WEB-INF/lib\")=" + libURL + "/" + ow_core));
                    jar = new JarFile(libURL + "/" + ow_core);
                    Manifest manifestFile = ((JarFile)jar).getManifest();
                    if (null != manifestFile) {
                        Attributes mainAttributes = manifestFile.getMainAttributes();
                        if (mainAttributes.getValue("Specification-Version") != null) {
                            specificationVersion = mainAttributes.getValue("Specification-Version");
                        }
                        if (mainAttributes.getValue("Implementation-Version") != null) {
                            implementationVersion = mainAttributes.getValue("Implementation-Version");
                        }
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)"OwAppEdition.setupEdition: Exception, cannot retrieve the software version of your Workdesk installation - maybe because the Application Server does not support this feature, or the ow_core_xxx.jar file cannot be found...");
            }
            finally {
                LOG.debug((Object)"OwAppEdition.setupEdition: The version of the application successfully setted....");
                request_p.getSession().setAttribute(this.setupVersionLocalized, (Object)"true");
                if (jar != null) {
                    jar.close();
                }
            }
            String footerVersionTemp = "";
            specificationVersion = specificationVersion.toUpperCase();
            implementationVersion = implementationVersion.toUpperCase();
            if (specificationVersion.indexOf("ENTERPRISE") != -1) {
                footerVersionTemp = implementationVersion.indexOf("SPRINT") != -1 || implementationVersion.indexOf("BETA") != -1 || implementationVersion.indexOf("ALPHA") != -1 || implementationVersion.indexOf("RC") != -1 ? mainContext_p.getContext().localize("default.OwMainLayout.jsp.footer.development", "Development Version - Only for development and testing. Not for production environments") : mainContext_p.getContext().localize("default.OwMainLayout.jsp.footer.commercial", "Workdesk - Tested and fully supported by Alfresco Software, Inc.");
            } else if (specificationVersion.indexOf("COMMUNITY") != -1) {
                footerVersionTemp = mainContext_p.getContext().localize("default.OwMainLayout.jsp.footer.community", "Workdesk Community - Supplied free of charge with no support, no certification, no maintenance, no warranty, and no indemnity by Alfresco Software, Inc. or its partners.<br />Looking for a supported and maintained edition? Go to <a href=\"http://www.alfresco.com\">www.alfresco.com</a>.");
            } else if (specificationVersion.indexOf("UNDEFINED") != -1) {
                footerVersionTemp = mainContext_p.getContext().localize("default.OwMainLayout.jsp.footer.development", "Development Version - Only for development and testing. Not for production environments");
            }
            request_p.getSession().setAttribute(this.footerLocalized, (Object)footerVersionTemp);
        }
    }
}

