/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwUserOperationEvent;
import com.wewebu.ow.server.app.OwUserOperationListener;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwStandardDBAttributeBagWriteableFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;

public class OwAttrBagBasedUserOperationListener
implements OwUserOperationListener {
    public static final String USEROPERATION_BAG_NAME = "useroperation";
    private static Logger LOG = OwLogCore.getLogger(OwAttrBagBasedUserOperationListener.class);
    private String bagTableName = null;
    private JdbcTemplate jdbc = null;
    private static final List<OwUserOperationEvent.OwUserOperationType> TARGET_OPERATIONS = Arrays.asList(OwUserOperationEvent.OwUserOperationType.LOGIN, OwUserOperationEvent.OwUserOperationType.LOGOUT);

    public OwAttrBagBasedUserOperationListener(JdbcTemplate jdbc_p, String bagTableName_p) {
        this.jdbc = jdbc_p;
        this.bagTableName = bagTableName_p;
    }

    protected OwAttributeBagWriteable getAttributeBag(String userName_p, String bagName_p, String tableName_p) throws Exception {
        OwStandardDBAttributeBagWriteableFactory owStandardDBAttributeBagWriteableFactory = new OwStandardDBAttributeBagWriteableFactory(this.jdbc, userName_p, tableName_p);
        owStandardDBAttributeBagWriteableFactory.init();
        return owStandardDBAttributeBagWriteableFactory.getBag(bagName_p);
    }

    @Override
    public void operationPerformed(OwUserOperationEvent event_p) {
        if (TARGET_OPERATIONS.contains((Object)event_p.getType())) {
            try {
                OwAttributeBagWriteable bag = this.getAttributeBag(event_p.getUserInfo().getUserID(), USEROPERATION_BAG_NAME, this.bagTableName);
                bag.setAttribute(event_p.getType().toString(), OwDateValue.fromEvent(event_p));
                bag.save();
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot save user operation timestamp", (Throwable)e);
            }
        }
    }

    public static class OwDateValue {
        private static final String EMPTY_SOURCE = "-";
        private static String FORMAT = "dd/MM/yyyy HH:mm:ss";
        private static SimpleDateFormat formatter = new SimpleDateFormat(FORMAT);
        private static String SEPARATOR = "|";
        private Date theDate;
        private String source;

        private OwDateValue() {
        }

        private void setDate(Date date_p) {
            this.theDate = date_p;
        }

        public Date getDate() {
            return this.theDate;
        }

        public String getSource() {
            return this.source;
        }

        public static synchronized OwDateValue fromString(String dateValueSource_p) {
            OwDateValue result = new OwDateValue();
            if (dateValueSource_p != null) {
                String[] splittedSource = dateValueSource_p.trim().split("\\" + SEPARATOR);
                try {
                    Date theDate = formatter.parse(splittedSource[0]);
                    result.setDate(theDate);
                }
                catch (ParseException e) {
                    LOG.error((Object)"Cannot restore");
                }
                if (splittedSource.length == 2) {
                    if (splittedSource[1].equals(EMPTY_SOURCE)) {
                        result.setSource(null);
                    } else {
                        result.setSource(splittedSource[1]);
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder build = new StringBuilder();
            SimpleDateFormat simpleDateFormat = formatter;
            synchronized (simpleDateFormat) {
                build.append(formatter.format(this.theDate));
            }
            build.append(SEPARATOR);
            build.append(this.source == null ? EMPTY_SOURCE : this.source);
            return build.toString();
        }

        public static synchronized OwDateValue fromEvent(OwUserOperationEvent event_p) {
            OwDateValue owDateValue = new OwDateValue();
            owDateValue.setDate(event_p.getCreationTime());
            owDateValue.setSource(event_p.getEventSource());
            return owDateValue;
        }

        private void setSource(String eventSource_p) {
            this.source = eventSource_p;
        }
    }
}

