/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.conf.OwBaseConfiguration;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class OwConfigDump {
    private OwConfiguration m_Configuration;
    private OwMainAppContext m_Context;

    private void dumpPlugins(Writer htmlWriter_p, OwBaseConfiguration.OwPluginTypeDefinition def_p, String strTitle_p) throws Exception {
        htmlWriter_p.write("<tr bgcolor='#999999'><td class='title' colspan='2'>Plugins: ");
        htmlWriter_p.write(strTitle_p);
        htmlWriter_p.write("</td><tr>");
        List plugIns = this.m_Configuration.getAllowedPlugins(def_p.getType());
        if (null != plugIns) {
            for (int i = 0; i < plugIns.size(); ++i) {
                OwXMLUtil nodeWrapper = (OwXMLUtil)plugIns.get(i);
                String strClassName = nodeWrapper.getSafeTextValue("ClassName", "undef. classname");
                String strPluginName = nodeWrapper.getSafeTextValue("Name", "no Plugin name defined");
                String version = nodeWrapper.getSafeTextValue("Version", "no version defined");
                htmlWriter_p.write("<tr>");
                try {
                    if (!"ow_app".equals(def_p.getType())) {
                        Class.forName(strClassName);
                    }
                    htmlWriter_p.write("<td valign=\"top\"><b>");
                    htmlWriter_p.write(strPluginName);
                    htmlWriter_p.write("</b><br />");
                    htmlWriter_p.write(strClassName);
                    htmlWriter_p.write(" - ");
                    htmlWriter_p.write(version);
                }
                catch (Exception e) {
                    htmlWriter_p.write("<td valign=\"top\" bgcolor=\"#ff0000\">");
                    htmlWriter_p.write(strPluginName);
                    htmlWriter_p.write("<br />ERROR: ");
                    htmlWriter_p.write("<a href=\"javascript:toggleElementDisplay('");
                    htmlWriter_p.write(strPluginName == null ? "null" : strPluginName);
                    htmlWriter_p.write(String.valueOf(i));
                    htmlWriter_p.write("');\">");
                    htmlWriter_p.write(e.getLocalizedMessage());
                    htmlWriter_p.write("</a><br /><span style=\"display: none;\" id=\"");
                    htmlWriter_p.write(strPluginName == null ? "null" : strPluginName);
                    htmlWriter_p.write(String.valueOf(i));
                    htmlWriter_p.write("\">");
                    htmlWriter_p.write(e.toString());
                    htmlWriter_p.write("</span>");
                }
                htmlWriter_p.write("</td>");
                htmlWriter_p.write("<td valign=\"top\">");
                htmlWriter_p.write("<a href=\"javascript:toggleElementDisplay('");
                htmlWriter_p.write(strClassName == null ? "null" : strClassName);
                htmlWriter_p.write(String.valueOf(i));
                htmlWriter_p.write("');\">XML-Config</a><br/>");
                htmlWriter_p.write("<span style=\"display: none;\" id=\"");
                htmlWriter_p.write(strClassName == null ? "null" : strClassName);
                htmlWriter_p.write(String.valueOf(i));
                htmlWriter_p.write("\">");
                nodeWrapper.writeHtmlDump(htmlWriter_p);
                htmlWriter_p.write("</span>");
                htmlWriter_p.write("</td></tr>");
            }
        }
    }

    private void dumpManager(Writer htmlWriter_p, String strName_p, String strInterfaceClassName_p, OwXMLUtil configNode_p) throws Exception {
        String className = configNode_p.getSafeTextValue("ClassName", null);
        htmlWriter_p.write("<tr bgcolor='#999999'><td colspan=\"2\">");
        htmlWriter_p.write(strName_p);
        htmlWriter_p.write("</td><tr>");
        if (className != null) {
            try {
                Class.forName(className);
                htmlWriter_p.write("<td valign=\"top\">");
                htmlWriter_p.write(className);
            }
            catch (Exception e) {
                htmlWriter_p.write("<td valign=\"top\" bgcolor=\"#ff0000\">");
                htmlWriter_p.write("<br />ERROR: ");
                htmlWriter_p.write(e.getLocalizedMessage());
            }
        }
        htmlWriter_p.write("</td><td valign=\"top\">");
        htmlWriter_p.write("<a href=\"javascript:toggleElementDisplay('" + className + "');\">XML-Config</a><br/>");
        htmlWriter_p.write("<span style=\"display: none;\" id=\"" + className + "\">");
        configNode_p.writeHtmlDump(htmlWriter_p);
        htmlWriter_p.write("</span>");
        htmlWriter_p.write("</td></tr>");
    }

    private void dumpEnvironment(Writer htmlWriter_p) throws Exception {
        htmlWriter_p.write("<table border='1' cellpadding='4' cellspacing='0' bordercolor='#000000'>");
        Iterator<Map.Entry<Object, Object>> it = System.getProperties().entrySet().iterator();
        while (it.hasNext()) {
            htmlWriter_p.write("<tr>");
            Map.Entry<Object, Object> entry = it.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            htmlWriter_p.write("<td>");
            htmlWriter_p.write(k.toString());
            htmlWriter_p.write("</td>");
            htmlWriter_p.write("<td>");
            htmlWriter_p.write(v.toString());
            htmlWriter_p.write("</td>");
            htmlWriter_p.write("</tr>");
        }
        htmlWriter_p.write("</table>");
    }

    public void handleRequest(ServletContext context_p, HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        PrintWriter htmlWriter = response_p.getWriter();
        HttpSession Session = request_p.getSession();
        this.m_Context = (OwMainAppContext)Session.getAttribute("ow_Context");
        if (this.m_Context == null) {
            this.m_Context = new OwMainAppContext();
            this.m_Context.setRequest(context_p, request_p, response_p);
            this.m_Configuration = this.m_Context.getConfiguration();
            this.m_Configuration.init(this.m_Context);
        } else {
            this.m_Configuration = this.m_Context.getConfiguration();
        }
        htmlWriter.write("<h3>Alfresco Workdesk - Configuration Dump</h3>");
        try {
            String message_dev_version = "Development Version - Only for development and testing. Not for production environments";
            htmlWriter.write(this.m_Context.localize(OwConfiguration.getEditionString(), message_dev_version));
        }
        catch (Exception e) {
            // empty catch block
        }
        htmlWriter.write("<p><table border='1' cellpadding='4' cellspacing='0' bordercolor='#000000'>");
        VersionNumber coreSystemImplementationVersion = new VersionNumber(Class.forName("com.wewebu.ow.server.app.OwConfiguration"), true);
        htmlWriter.write("<tr bgcolor='#999999'><td>CORE System (OwConfiguration)<BR><small>for detailed information perform:<BR>Check all required Java Packages (jar files & libraries)</td><td>");
        htmlWriter.write(coreSystemImplementationVersion.toString());
        htmlWriter.write("</td><tr>");
        htmlWriter.write("<tr><td>LOCALE:</td><td>");
        htmlWriter.write(this.m_Context.getLocale() != null ? this.m_Context.getLocale().toString() : "");
        htmlWriter.write("</td></tr>");
        this.dumpManager(htmlWriter, "EcmAdapter", "com.wewebu.ow.server.ecm.OwNetwork", this.m_Configuration.getNetworkAdaptorConfiguration());
        this.dumpManager(htmlWriter, "RoleManager", "com.wewebu.ow.server.role.OwRoleManager", this.m_Configuration.getRoleManagerConfiguration());
        this.dumpManager(htmlWriter, "FieldManager", "com.wewebu.ow.server.app.OwFieldManager", this.m_Configuration.getFieldManagerConfiguration());
        this.dumpManager(htmlWriter, "HistoryManager", "com.wewebu.ow.server.history.OwHistoryManager", this.m_Configuration.getHistoryManagerConfiguration());
        this.dumpManager(htmlWriter, "MandatorManager", "com.wewebu.ow.server.mandator.OwMandatorManager", this.m_Configuration.getMandatorManagerConfiguration());
        try {
            for (int i = 0; i < OwBaseConfiguration.getPluginTypeDefinitions().length; ++i) {
                this.dumpPlugins(htmlWriter, OwBaseConfiguration.getPluginTypeDefinitions()[i], OwBaseConfiguration.getPluginTypeDefinitions()[i].getDisplayName(this.m_Context.getLocale()));
            }
        }
        catch (OwInvalidOperationException e) {
            htmlWriter.write("<tr bgcolor='#ff0000'><td colspan='2'>");
            htmlWriter.write("To see the plugin descriptions, you need to log on first...");
            htmlWriter.write("</tr>");
        }
        htmlWriter.write("</table>");
        this.dumpRoleData(htmlWriter);
        htmlWriter.write("<h3>Java Runtime Dump</h3><p>");
        this.dumpEnvironment(htmlWriter);
    }

    private void dumpRoleData(PrintWriter htmlWriter_p) throws Exception {
        htmlWriter_p.write("<br><table border='1' cellpadding='4' cellspacing='0' bordercolor='#000000'>");
        htmlWriter_p.write("<tr bgcolor='#999999'><td colspan='2'>Roles</td></tr>");
        try {
            htmlWriter_p.write("<tr>");
            htmlWriter_p.write("<td>");
            htmlWriter_p.write("Userinfo");
            htmlWriter_p.write("</td>");
            htmlWriter_p.write("<td><ul>");
            htmlWriter_p.write("<li>UserID: ");
            htmlWriter_p.write(this.m_Context.getCurrentUser().getUserID());
            htmlWriter_p.write("</li><li>UserLongName: ");
            htmlWriter_p.write(this.m_Context.getCurrentUser().getUserLongName());
            htmlWriter_p.write("</li><li>UserName: ");
            htmlWriter_p.write(this.m_Context.getCurrentUser().getUserName());
            htmlWriter_p.write("</li><li>UserEmailAddress: ");
            String userEmailAdress = this.m_Context.getCurrentUser().getUserEmailAdress();
            if (userEmailAdress != null && !userEmailAdress.equals("")) {
                htmlWriter_p.write(userEmailAdress);
            } else {
                htmlWriter_p.write("N/A");
            }
            htmlWriter_p.write("</li></ul></td>");
            htmlWriter_p.write("</tr>");
        }
        catch (NullPointerException nullEx) {
            htmlWriter_p.write("<tr><td>Exception:</td><td>Could not get userinfo; Seemed to be null!</td></tr>");
        }
        catch (Exception e) {
            htmlWriter_p.write("<tr><td>Exception:</td><td>Could not get userinfo; ");
            htmlWriter_p.write(e.getMessage());
            htmlWriter_p.write("</td></tr>");
        }
        try {
            htmlWriter_p.write("<tr>");
            htmlWriter_p.write("<td>");
            htmlWriter_p.write("User Roles:");
            htmlWriter_p.write("</td>");
            htmlWriter_p.write("<td><ul>");
            Iterator roles = this.m_Context.getCurrentUser().getRoleNames().iterator();
            while (roles.hasNext()) {
                htmlWriter_p.write("<li>");
                htmlWriter_p.write((String)roles.next());
            }
            htmlWriter_p.write("</ul></td>");
            htmlWriter_p.write("</tr>");
        }
        catch (NullPointerException nullEx) {
            htmlWriter_p.write("<tr><td>Exception:</td><td>Could not get roleinfo; some null value was returned instead!</td></tr>");
        }
        catch (Exception e) {
            htmlWriter_p.write("<tr><td>Exception:</td><td>Could not get roleinfo; ");
            htmlWriter_p.write(e.getMessage());
            htmlWriter_p.write("</td></tr>");
        }
        try {
            for (int iCats = 0; iCats < OwRoleManager.m_predefinedcategories.length; ++iCats) {
                int iCategorie = OwRoleManager.m_predefinedcategories[iCats];
                String sCategorieName = this.m_Context.getRoleManager().getCategoryDisplayName(this.m_Context.getLocale(), iCategorie);
                htmlWriter_p.write("<tr>");
                htmlWriter_p.write("<td>");
                htmlWriter_p.write("Categorie: ");
                htmlWriter_p.write(sCategorieName);
                htmlWriter_p.write("</td>");
                htmlWriter_p.write("<td><ul>");
                Iterator catIT = this.m_Context.getRoleManager().getAllowedResources(iCategorie).iterator();
                while (catIT.hasNext()) {
                    htmlWriter_p.write("<li>");
                    htmlWriter_p.write((String)catIT.next());
                }
                htmlWriter_p.write("</ul></td>");
                htmlWriter_p.write("</tr>");
            }
        }
        catch (NullPointerException nullEx) {
            htmlWriter_p.write("<tr><td>Exception:</td><td>Could not get role resources; some null value was returned instead!</td></tr>");
        }
        catch (Exception e) {
            htmlWriter_p.write("<tr><td>Exception:</td><td>Could not get role resources; ");
            htmlWriter_p.write(e.getMessage());
            htmlWriter_p.write("</td></tr>");
        }
        htmlWriter_p.write("</table>");
    }

    protected class VersionNumber {
        public String m_strReleaseType;
        public boolean m_fImplementation;
        public int m_iMinor;
        public int m_iMajor;
        public int m_iUpdate;
        public int m_iFixpack;

        public VersionNumber(Class<?> class_p, boolean fImplementation_p) {
            block17: {
                this.m_strReleaseType = "";
                this.m_iMinor = -1;
                this.m_iMajor = -1;
                this.m_iUpdate = -1;
                this.m_iFixpack = -1;
                this.m_fImplementation = fImplementation_p;
                try {
                    class_p = Class.forName("com.wewebu.ow.server.app.OwConfiguration");
                }
                catch (ClassNotFoundException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (fImplementation_p) {
                        try {
                            this.m_iMinor = class_p.getField("IMPLEMENTATION_MINOR_VERSION").getInt(null);
                        }
                        catch (NoSuchFieldException ex) {
                            this.m_iMinor = class_p.getField("IMPLEMENTAION_MINOR_VERSION").getInt(null);
                        }
                        try {
                            this.m_iMajor = class_p.getField("IMPLEMENTATION_MAJOR_VERSION").getInt(null);
                        }
                        catch (NoSuchFieldException ex) {
                            this.m_iMajor = class_p.getField("IMPLEMENTAION_MAJOR_VERSION").getInt(null);
                        }
                        try {
                            this.m_iUpdate = class_p.getField("IMPLEMENTATION_UPDATE_VERSION").getInt(null);
                        }
                        catch (NoSuchFieldException ex) {
                            this.m_iUpdate = class_p.getField("IMPLEMENTAION_UPDATE_VERSION").getInt(null);
                        }
                        try {
                            this.m_iFixpack = class_p.getField("IMPLEMENTATION_FIXPACK_VERSION").getInt(null);
                        }
                        catch (NoSuchFieldException ex) {
                            this.m_iFixpack = class_p.getField("IMPLEMENTATION_FIXPACK_VERSION").getInt(null);
                        }
                        try {
                            try {
                                this.m_strReleaseType = " (" + (String)class_p.getField("IMPLEMENTATION_RELEASE_TYPE").get(null) + ")";
                                break block17;
                            }
                            catch (NoSuchFieldException ex) {
                                this.m_strReleaseType = " (" + (String)class_p.getField("IMPLEMENTAION_RELEASE_TYPE").get(null) + ")";
                            }
                        }
                        catch (Exception e) {}
                        break block17;
                    }
                    this.m_iMinor = class_p.getField("INTERFACE_MINOR_VERSION").getInt(null);
                    this.m_iMajor = class_p.getField("INTERFACE_MAJOR_VERSION").getInt(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public VersionNumber(String sVersion_p) {
            this.m_strReleaseType = "";
            this.m_iMinor = -1;
            this.m_iMajor = -1;
            this.m_iUpdate = -1;
            this.m_iFixpack = -1;
            try {
                String[] VersionNumbers = sVersion_p.split("\\.");
                if (4 == VersionNumbers.length) {
                    this.m_fImplementation = true;
                    this.m_iMajor = Integer.valueOf(VersionNumbers[0]);
                    this.m_iMinor = Integer.valueOf(VersionNumbers[1]);
                    this.m_iUpdate = Integer.valueOf(VersionNumbers[2]);
                    this.m_iFixpack = Integer.valueOf(VersionNumbers[3]);
                } else if (3 == VersionNumbers.length) {
                    this.m_fImplementation = true;
                    this.m_iMajor = Integer.valueOf(VersionNumbers[0]);
                    this.m_iMinor = Integer.valueOf(VersionNumbers[1]);
                    this.m_iUpdate = Integer.valueOf(VersionNumbers[2]);
                } else if (2 == VersionNumbers.length) {
                    this.m_fImplementation = false;
                    this.m_iMajor = Integer.valueOf(VersionNumbers[0]);
                    this.m_iMinor = Integer.valueOf(VersionNumbers[1]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public String toString() {
            if (this.m_fImplementation) {
                return String.valueOf(this.m_iMajor) + "." + String.valueOf(this.m_iMinor) + "." + String.valueOf(this.m_iUpdate) + "." + String.valueOf(this.m_iFixpack) + this.m_strReleaseType;
            }
            return String.valueOf(this.m_iMajor) + "." + String.valueOf(this.m_iMinor) + this.m_strReleaseType;
        }
    }
}

