/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.app.OwComboModel;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import java.util.LinkedList;
import java.util.List;

public class OwDefaultComboModel
implements OwComboModel {
    private static final String DEFAULT_EMPTY_VALUE_DISPLAY_VALUE = "-";
    private List m_items;
    private OwComboItem m_selectedItem;
    private boolean m_allowEmptyItem;
    private boolean m_allowNotInListElement;
    private String m_emptyDisplayValue = "-";

    public OwDefaultComboModel(String value_p, String[] values_p, String[] displayNames_p) {
        this(false, false, value_p, values_p, displayNames_p);
    }

    public OwDefaultComboModel(boolean allowEmptyItem_p, boolean allowNotInList_p, String value_p, String[] values_p, String[] displayNames_p, String emptyDisplayValue_p) {
        this.m_emptyDisplayValue = emptyDisplayValue_p;
        this.m_allowEmptyItem = allowEmptyItem_p;
        this.m_allowNotInListElement = allowNotInList_p;
        if (values_p == null || displayNames_p == null || values_p.length != displayNames_p.length) {
            throw new IllegalArgumentException();
        }
        LinkedList<OwDefaultComboItem> items = new LinkedList<OwDefaultComboItem>();
        for (int i = 0; i < values_p.length; ++i) {
            items.add(new OwDefaultComboItem(values_p[i], displayNames_p[i]));
        }
        this.initialize(value_p, items);
    }

    public OwDefaultComboModel(boolean allowEmptyItem_p, boolean allowNotInList_p, String value_p, String[] values_p, String[] displayNames_p) {
        this.m_allowEmptyItem = allowEmptyItem_p;
        this.m_allowNotInListElement = allowNotInList_p;
        if (values_p == null || displayNames_p == null || values_p.length != displayNames_p.length) {
            throw new IllegalArgumentException();
        }
        LinkedList<OwDefaultComboItem> items = new LinkedList<OwDefaultComboItem>();
        for (int i = 0; i < values_p.length; ++i) {
            items.add(new OwDefaultComboItem(values_p[i], displayNames_p[i]));
        }
        this.initialize(value_p, items);
    }

    public OwDefaultComboModel(boolean allowEmptyItem_p, boolean allowNotInList_p, String value_p, List items_p, String emptyDisplayValue_p) {
        this.m_allowEmptyItem = allowEmptyItem_p;
        this.m_allowNotInListElement = allowNotInList_p;
        this.m_emptyDisplayValue = emptyDisplayValue_p;
        this.initialize(value_p, items_p);
    }

    public OwDefaultComboModel(boolean allowEmptyItem_p, boolean allowNotInList_p, String value_p, List items_p) {
        this.m_allowEmptyItem = allowEmptyItem_p;
        this.m_allowNotInListElement = allowNotInList_p;
        this.initialize(value_p, items_p);
    }

    public OwDefaultComboModel(String value_p, List items_p) {
        this.m_allowEmptyItem = true;
        this.m_allowNotInListElement = true;
        this.initialize(value_p, items_p);
    }

    private void initialize(String value_p, List items_p) {
        OwDefaultComboItem owDefaultComboItem;
        if (items_p == null) {
            throw new IllegalArgumentException();
        }
        this.m_items = new LinkedList();
        if (this.m_allowEmptyItem) {
            owDefaultComboItem = new OwDefaultComboItem("", this.m_emptyDisplayValue);
            if (value_p == null || value_p.compareTo("") == 0) {
                this.m_selectedItem = owDefaultComboItem;
            }
            this.m_items.add(owDefaultComboItem);
        }
        this.m_items.addAll(items_p);
        if (value_p != null && value_p.compareTo("") != 0) {
            for (OwComboItem item : items_p) {
                if (!value_p.equals(item.getValue())) continue;
                this.m_selectedItem = item;
            }
            if (this.m_selectedItem == null && this.m_allowNotInListElement) {
                owDefaultComboItem = new OwDefaultComboItem(value_p, value_p);
                this.m_items.add(owDefaultComboItem);
                this.m_selectedItem = owDefaultComboItem;
            }
        }
    }

    @Override
    public OwComboItem[] getAllItems() {
        return this.m_items.toArray(new OwComboItem[this.m_items.size()]);
    }

    @Override
    public OwComboItem getItemAt(int position_p) {
        OwComboItem item = null;
        if (position_p < this.m_items.size() && position_p >= 0) {
            item = (OwComboItem)this.m_items.get(position_p);
        }
        return item;
    }

    @Override
    public OwComboItem getSelectedItem() {
        return this.m_selectedItem;
    }

    @Override
    public int getSize() {
        return this.m_items.size();
    }

    @Override
    public boolean hasItemOutOfRange() {
        return false;
    }

    @Override
    public boolean isSelectedItem(OwComboItem item_p) {
        return this.m_selectedItem != null && this.m_items.contains(item_p) && item_p.equals(this.m_selectedItem);
    }

    @Override
    public void setSelectedItem(OwComboItem item_p) {
        this.m_selectedItem = item_p;
    }
}

