/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMultipleSelectionCall;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.history.OwStandardHistoryObjectChangeEvent;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class OwDocumentFunction
extends OwFunction {
    private static final Logger LOG = OwLogCore.getLogger(OwDocumentFunction.class);
    private String m_strIconURL;
    private String m_strBigIconURL;
    private Set m_supportedObjectTypes;
    private List<String> retrievalPropertyNames;

    @Override
    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
        this.m_strIconURL = "<img class=\"OwFunctionIcon\" title=\"" + this.getTooltip() + "\" alt=\"" + this.getTooltip() + "\" src=\"" + this.getIcon() + "\">";
        this.m_strBigIconURL = "<img class=\"OwFunctionBigIcon\" title=\"" + this.getTooltip() + "\" alt=\"" + this.getTooltip() + "\" src=\"" + this.getBigIcon() + "\">";
        this.m_supportedObjectTypes = this.getSupportedObjectTypesFromDescriptor("objecttypes");
        if (null == this.m_supportedObjectTypes) {
            String msg = "OwDocumentFunction.init: At least one object type must be defined in plugin = " + this.getPluginID();
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        List propertyNamesList = this.getConfigNode().getSafeStringList("RetrievalProperties");
        if (!propertyNamesList.isEmpty()) {
            this.retrievalPropertyNames = Collections.unmodifiableList(propertyNamesList);
        }
    }

    public String getColumnTitle() {
        String sTitle = this.getConfigNode().getSafeTextValue("ColumnTitle", "");
        if (sTitle.equals("OW_ICON")) {
            return this.m_strIconURL;
        }
        return sTitle;
    }

    public boolean getEnableColumnClickEvent() {
        try {
            return OwXMLDOMUtil.getSafeBooleanAttributeValue(this.getConfigNode().getSubNode("ColumnTitle"), "clickevent", false);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getNeedParent() {
        return false;
    }

    public boolean getMultiselect() {
        return this.getConfigNode().getSafeBooleanValue("Multiselect", false);
    }

    public boolean getObjectInstance() {
        return this.getConfigNode().getSafeBooleanValue("ObjectInstance", false);
    }

    public boolean getShowInEditViews() {
        return this.getConfigNode().getSafeBooleanValue("ShowInEditViews", false);
    }

    @Override
    public boolean getContextMenu() {
        return this.getConfigNode().getSafeBooleanValue("ContextMenu", false);
    }

    public String getIconHTML(OwObject oObject_p, OwObject oParent_p) throws Exception {
        return this.m_strIconURL;
    }

    public String getBigIconHTML(OwObject oObject_p, OwObject oParent_p) throws Exception {
        return this.m_strBigIconURL;
    }

    public String getDefaultLabel() throws Exception {
        return this.getPluginTitle();
    }

    public String getLabel(OwObject oObject_p, OwObject oParent_p) throws Exception {
        return this.getPluginTitle();
    }

    public String getDefaultIconHTML() throws Exception {
        return this.m_strIconURL;
    }

    public String getBigDefaultIconHTML() throws Exception {
        return this.m_strBigIconURL;
    }

    public boolean isObjectTypeSupported(int iObjectType_p) {
        return this.m_supportedObjectTypes.contains(iObjectType_p);
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        return this.isObjectTypeSupported(oObject_p.getType()) && this.isObjectClassSupported(oObject_p.getObjectClass().getClassName());
    }

    public boolean isEnabled(Collection objects_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (objects_p == null) {
            return false;
        }
        Iterator it = objects_p.iterator();
        while (it.hasNext()) {
            if (this.isEnabled((OwObject)it.next(), oParent_p, iContext_p)) continue;
            return false;
        }
        return true;
    }

    public abstract void onClickEvent(OwObject var1, OwObject var2, OwClientRefreshContext var3) throws Exception;

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        throw new OwInvalidOperationException("OwDocumentFunction.onMultiselectClickEvent: No multiselection operation allowed.");
    }

    public void onColumnClickEvent(OwObjectCollection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwMultipleSelectionCall multiCall = new OwMultipleSelectionCall(this, objects_p, oParent_p, refreshCtx_p, this.getContext());
        multiCall.invokeFunction();
    }

    protected void addHistoryEvent(OwObject oObject_p, OwObject oParent_p, int iEventType_p, int iStatus_p) throws Exception {
        this.getEventManager().addEvent(iEventType_p, this.getPluginID(), new OwStandardHistoryObjectChangeEvent(oObject_p, (OwObjectReference)oParent_p), iStatus_p);
    }

    protected void addHistoryEvent(Collection objects_p, OwObject oParent_p, int iEventType_p, int iStatus_p) throws Exception {
        this.getEventManager().addEvent(iEventType_p, this.getPluginID(), new OwStandardHistoryObjectChangeEvent(objects_p, (OwObjectReference)oParent_p), iStatus_p);
    }

    @Override
    public final String getPluginType() {
        return "ow_docfunction";
    }

    public Collection getRetrievalPropertyNames() throws Exception {
        return this.retrievalPropertyNames;
    }

    protected String getDisplayNameFromUserId(String checkedoutByID_p) {
        OwUserInfo userInfo = null;
        try {
            userInfo = this.getContext().getNetwork().getUserFromID(checkedoutByID_p);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (userInfo != null) {
            String userDisplayName = null;
            try {
                userDisplayName = userInfo.getUserDisplayName();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (userDisplayName != null && !userDisplayName.equals("")) {
                checkedoutByID_p = userDisplayName;
            }
        }
        return checkedoutByID_p;
    }
}

