/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.ecm.OwContentElement;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.util.OwStreamUtil;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class OwDocumentImportItemContentElement
implements OwContentElement {
    private static final Logger LOG = OwLogCore.getLogger(OwDocumentImportItemContentElement.class);
    protected int m_contentType;
    protected int m_page;
    protected OwDocumentImportItem m_importedDocument;

    public OwDocumentImportItemContentElement(int contentType_p, int page_p, OwDocumentImportItem importedDocument_p) {
        if (importedDocument_p == null) {
            throw new IllegalArgumentException("OwDocumentImportItemContentElement must not be instantiated without importedDocument_p");
        }
        if (page_p < 0 || page_p > importedDocument_p.getContentStreamCount()) {
            throw new IndexOutOfBoundsException("OwDocumentImportItemContentElement: invalid page number " + page_p + " != [0 ; " + importedDocument_p.getContentStreamCount() + "]");
        }
        this.m_contentType = contentType_p;
        this.m_page = page_p;
        this.m_importedDocument = importedDocument_p;
    }

    @Override
    public String getContentURL() throws Exception {
        throw new OwObjectNotFoundException("OwDocumentImportItemContentElement.getContentURL: Not implemented or Not supported. m_iContentType=" + String.valueOf(this.m_contentType) + ", m_iPage=" + String.valueOf(this.m_page));
    }

    @Override
    public boolean isInputStreamNative() {
        return true;
    }

    @Override
    public String getContentFilePath() throws Exception {
        return null;
    }

    @Override
    public InputStream getContentStream(OutputStream out_p) throws Exception {
        InputStream result = this.m_importedDocument.getContentStream(this.m_page - 1);
        if (null == out_p) {
            return result;
        }
        OwStreamUtil.upload(result, out_p, false);
        out_p.flush();
        result.close();
        return null;
    }

    @Override
    public Object getContentObject() throws Exception {
        throw new OwObjectNotFoundException("OwDocumentImportItemContentElement.getContentObject: Not implemented or Not supported.");
    }

    @Override
    public int getContentRepresentation() throws Exception {
        return 2;
    }

    @Override
    public int getPageNumber(int lPageIndex_p) throws Exception {
        return lPageIndex_p + 1;
    }

    @Override
    public String getMIMEType() throws Exception {
        return this.m_importedDocument.getContentMimeType(this.m_page - 1);
    }

    @Override
    public String getMIMEParameter() throws Exception {
        return this.m_importedDocument.getContentMimeParameter(this.m_page - 1);
    }

    @Override
    public void releaseResources() {
        try {
            this.m_importedDocument.release();
        }
        catch (Exception e) {
            LOG.error((Object)"Error releasing resources", (Throwable)e);
        }
    }
}

