/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import org.apache.log4j.Logger;

public class OwDynamicLayoutSettings {
    private static final String HEIGHT_ATTR_NAME = "height";
    private static final String WIDTH_ATTR_NAME = "width";
    private static final Logger LOG = OwLogCore.getLogger(OwDynamicLayoutSettings.class);
    private int m_height;
    private int m_width;
    private boolean m_usePersistency;
    private OwAppContext m_context;
    private String m_bagID;

    public OwDynamicLayoutSettings(boolean usePersistency_p, OwAppContext context_p, String bagID_p) {
        block3: {
            this.m_height = -1;
            this.m_width = 235;
            this.m_context = context_p;
            this.m_bagID = bagID_p;
            this.m_usePersistency = usePersistency_p;
            if (this.isWrittableAttributeBagAvailable() && this.m_bagID != null) {
                try {
                    OwAttributeBagWriteable attrBag = this.getAssociatedAttributeBag();
                    this.m_width = this.getParameterFromBag(attrBag, WIDTH_ATTR_NAME, this.m_width);
                    this.m_height = this.getParameterFromBag(attrBag, HEIGHT_ATTR_NAME, this.m_height);
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)"OwDynamicLayoutSettings: Cannot create the attribute bag, to read/write 'height' and 'width'. Continue without attribute bag settings.");
                }
            }
        }
    }

    private OwAttributeBagWriteable getAssociatedAttributeBag() throws Exception {
        OwMainAppContext owMainAppContext = (OwMainAppContext)this.m_context;
        OwNetwork network = owMainAppContext.getNetwork();
        String userId = network.getCredentials().getUserInfo().getUserID();
        OwAttributeBagWriteable attrBag = (OwAttributeBagWriteable)network.getApplicationObject(7, this.m_bagID, userId, true, true);
        return attrBag;
    }

    private int getParameterFromBag(OwAttributeBagWriteable attrBag_p, String paramName_p, int defaultValue_p) {
        int result = defaultValue_p;
        try {
            Object paramValue = attrBag_p.getAttribute(paramName_p);
            if (paramValue != null) {
                result = Integer.parseInt((String)paramValue);
            }
        }
        catch (OwObjectNotFoundException nfex) {
        }
        catch (Exception e) {
            LOG.debug((Object)"OwDynamicLayoutSettings.getParameterFromBag():Cannot load attribute from bag. Continue without attribute bag settins.", (Throwable)e);
        }
        return result;
    }

    public void setHeight(int height_p) {
        this.m_height = height_p;
        this.persistAttributeValue(HEIGHT_ATTR_NAME, this.m_height);
    }

    private void persistAttributeValue(String attrName_p, int value_p) {
        if (this.isWrittableAttributeBagAvailable()) {
            try {
                OwAttributeBagWriteable attrBag = this.getAssociatedAttributeBag();
                attrBag.setAttribute(attrName_p, "" + value_p);
                attrBag.save();
            }
            catch (Exception e) {
                LOG.debug((Object)"OwDynamicLayoutSettings.persistAttributeValue():Cannot save attribute to bag. Continue without attribute bag settins.", (Throwable)e);
            }
        }
    }

    public int getHeight() {
        return this.m_height;
    }

    public void setWidth(int width_p) {
        this.m_width = width_p;
        this.persistAttributeValue(WIDTH_ATTR_NAME, this.m_width);
    }

    public int getWidth() {
        return this.m_width;
    }

    private boolean isWrittableAttributeBagAvailable() {
        boolean result = false;
        if (this.m_usePersistency) {
            try {
                OwMainAppContext owMainAppContext = (OwMainAppContext)this.m_context;
                OwNetwork network = owMainAppContext.getNetwork();
                String userId = network.getCredentials().getUserInfo().getUserID();
                OwAttributeBagWriteable attrBag = (OwAttributeBagWriteable)network.getApplicationObject(7, this.m_bagID, userId, true, false);
                if (attrBag != null) {
                    result = true;
                }
            }
            catch (Exception e) {
                LOG.debug((Object)"OwDynamicLayoutSettings.isWrittableAttributeBagAvailable():Cannot obtain a writtable attribute bag. Continue without attribute bag settins.", (Throwable)e);
            }
        }
        return result;
    }
}

