/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwSearchObjectStore;
import com.wewebu.ow.server.ecm.OwSearchPath;
import com.wewebu.ow.server.ecm.OwSearchPathField;
import com.wewebu.ow.server.ecm.OwStandardClassSelectObject;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchOperator;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.log.OwLogCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OwEcmUtil {
    private static final String DMSID_PREFIX = "dmsid=";
    private static final String VIRTUALFOLDER_PREFIX = "vf=";
    private static final Logger LOG = OwLogCore.getLogger(OwEcmUtil.class);

    public static OwSearchNode createSimpleSearchNode(String strClassName_p, String strResourceName_p, String rootpath_p, OwSimpleSearchClause[] clauses_p, OwFieldDefinitionProvider fielddefinitionprovider_p) throws Exception {
        return OwEcmUtil.createSimpleSearchNode(4097, strClassName_p, strResourceName_p, rootpath_p, clauses_p, fielddefinitionprovider_p);
    }

    public static OwSearchNode createSimpleSearchNode(int objectType_p, String strClassName_p, String strResourceName_p, String rootpath_p, OwSimpleSearchClause[] clauses_p, OwFieldDefinitionProvider fielddefinitionprovider_p) throws Exception {
        OwSearchObjectStore searchStore = OwEcmUtil.createSearchStore(null, strResourceName_p);
        return OwEcmUtil.createSimpleSearchNode(objectType_p, searchStore, strClassName_p, strResourceName_p, rootpath_p, clauses_p, fielddefinitionprovider_p);
    }

    public static OwSearchNode createSimpleSearchNode(int objectType_p, OwSearchObjectStore searchObjectStore_p, String strClassName_p, String strResourceName_p, String rootpath_p, OwSimpleSearchClause[] clauses_p, OwFieldDefinitionProvider fielddefinitionprovider_p) throws Exception {
        return OwEcmUtil.createSimpleSearchNode(objectType_p, searchObjectStore_p, strClassName_p, strResourceName_p, rootpath_p, clauses_p, fielddefinitionprovider_p, false);
    }

    public static OwSearchNode createSimpleSearchNode(int objectType_p, OwSearchObjectStore searchObjectStore_p, String strClassName_p, String strResourceName_p, String rootpath_p, OwSimpleSearchClause[] clauses_p, OwFieldDefinitionProvider fielddefinitionprovider_p, boolean searchSubFolders_p) throws Exception {
        OwSearchNode retnode = new OwSearchNode(1, 5);
        OwSearchNode specialNode = new OwSearchNode(1, 2);
        retnode.add(specialNode);
        OwStandardClassSelectObject classselect = OwStandardClassSelectObject.CLASS_CLASS_NAME.newObject();
        classselect.addClass(objectType_p, strClassName_p, null, strResourceName_p, true);
        OwStandardClassSelectObject from = OwStandardClassSelectObject.CLASS_FROM.newObject();
        from.addClass(objectType_p, strClassName_p, null, strResourceName_p, true);
        specialNode.add(new OwSearchNode(classselect, 4, 1));
        specialNode.add(new OwSearchNode(from, 4, 1));
        if (null != rootpath_p) {
            OwSearchPath searchPath = new OwSearchPath(null, rootpath_p, searchSubFolders_p, searchObjectStore_p);
            OwSearchNode searchPathNode = new OwSearchNode(OwSearchPathField.classDescription, 1025, searchPath, 1, "SimpleSearchPath", "SimpleSearchPathInstruction", null);
            specialNode.add(searchPathNode);
        }
        OwSearchNode propNode = new OwSearchNode(1, 1);
        retnode.add(propNode);
        for (int i = 0; i < clauses_p.length; ++i) {
            OwSimpleSearchClause clause = clauses_p[i];
            OwFieldDefinition fieldDefinition = fielddefinitionprovider_p.getFieldDefinition(clause.getName(), null);
            propNode.add(new OwSearchNode(fieldDefinition, clause.getOperator(), clause.getValue(), 0));
        }
        return retnode;
    }

    public static OwSearchObjectStore createSearchStore(String objectStoreId_p, String objectStoreName_p) {
        OwSearchObjectStore searchStore = new OwSearchObjectStore(objectStoreId_p, objectStoreName_p);
        return searchStore;
    }

    public static OwObjectCollection doSimpleSearch(String strClassName_p, String strResourceName_p, String rootpath_p, OwSimpleSearchClause[] clauses_p, OwRepository repository_p, OwSort sort_p, Collection propertynames_p, int iMaxSize_p, int iVersionSelection_p) throws Exception {
        OwSearchNode search = OwEcmUtil.createSimpleSearchNode(strClassName_p, strResourceName_p, rootpath_p, clauses_p, repository_p);
        return repository_p.doSearch(search, sort_p, propertynames_p, iMaxSize_p, iVersionSelection_p);
    }

    public static OwObject createObjectFromString(OwMainAppContext context_p, String strObject_p) throws Exception {
        if (strObject_p.startsWith("/")) {
            return context_p.getNetwork().getObjectFromPath(strObject_p, true);
        }
        if (strObject_p.startsWith(VIRTUALFOLDER_PREFIX)) {
            strObject_p = strObject_p.substring(VIRTUALFOLDER_PREFIX.length());
            return (OwObject)context_p.getNetwork().getApplicationObject(1, strObject_p, false, false);
        }
        if (strObject_p.startsWith(DMSID_PREFIX)) {
            strObject_p = strObject_p.substring(DMSID_PREFIX.length());
            return context_p.getNetwork().getObjectFromDMSID(strObject_p, false);
        }
        throw new OwInvalidOperationException("Unrecognized object: " + strObject_p + " use the following form [vf=<virtualfoldername> | dmsid=<dmsid> | /<path> ]");
    }

    public static OwObject createSafeSubFolder(OwMainAppContext context_p, OwObject baseFolder_p, String strName_p) throws Exception {
        try {
            return context_p.getNetwork().getObjectFromPath(baseFolder_p.getPath() + "/" + strName_p, false);
        }
        catch (OwObjectNotFoundException e) {
            String strFolderClassName = context_p.getConfiguration().getDefaultFolderClassName();
            OwObjectClass folderClass = context_p.getNetwork().getObjectClass(strFolderClassName, baseFolder_p.getResource());
            String strNameProperty = folderClass.getNamePropertyName();
            OwPropertyClass folderNameClass = folderClass.getPropertyClass(strNameProperty);
            OwStandardProperty folderName = new OwStandardProperty(strName_p, folderNameClass);
            OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
            properties.put(folderName.getPropertyClass().getClassName(), folderName);
            String strFolderID = context_p.getNetwork().createNewObject(baseFolder_p.getResource(), strFolderClassName, properties, null, null, baseFolder_p, null, null);
            return context_p.getNetwork().getObjectFromDMSID(strFolderID, false);
        }
    }

    public static List getParentPathOfClass(OwObject obj_p, Collection classNames_p) throws Exception {
        ArrayList retList = new ArrayList();
        OwEcmUtil.iterateParentPathOfClass(obj_p, classNames_p, retList, "", "");
        return retList;
    }

    private static void iterateParentPathOfClass(OwObject obj_p, Collection classNames_p, List retList_p, String strPath_p, String displaypath_p) throws Exception {
        OwObjectCollection parents = obj_p.getParents();
        if (parents == null) {
            return;
        }
        for (OwObject parent : parents) {
            boolean fMatch = false;
            for (String strClassName : classNames_p) {
                OwObjectClass objectClass = parent.getObjectClass();
                String parentClassname = objectClass.getClassName();
                if (parentClassname == null) {
                    LOG.error((Object)("OwEcmUtil.iterateParentPathOfClass: ParentClassname is null, classname = " + strClassName));
                    throw new OwInvalidOperationException("OwEcmUtil.iterateParentPathOfClass: Recursive iterator function used by getParentPathOfClass, used to find the records a object is filed in. ParentClassname is null, classname = " + strClassName);
                }
                if (parentClassname == null || !parentClassname.equals(strClassName)) continue;
                retList_p.add(new OwParentPathInfo(parent, strPath_p, displaypath_p));
                fMatch = true;
                break;
            }
            if (fMatch) continue;
            OwEcmUtil.iterateParentPathOfClass(parent, classNames_p, retList_p, "/" + parent.getID() + strPath_p, "/" + parent.getName() + displaypath_p);
        }
    }

    public static class OwParentPathInfo {
        private OwObject m_Parent;
        private String m_strPath;
        private String m_strDisplayPath;

        public OwParentPathInfo(OwObject parent_p, String path_p, String displaypath_p) {
            this.m_Parent = parent_p;
            this.m_strPath = path_p;
            this.m_strDisplayPath = displaypath_p;
        }

        public OwObject getParent() {
            return this.m_Parent;
        }

        public String getPath() {
            return this.m_strPath;
        }

        public String getDisplayPath() {
            return this.m_strDisplayPath;
        }
    }

    public static class OwSimpleSearchClause {
        private String m_name;
        private int m_operator;
        private Object m_value;

        public OwSimpleSearchClause(String name_p, int operator_p, Object value_p) {
            this.m_name = name_p;
            this.m_operator = operator_p;
            this.m_value = value_p;
        }

        public String getName() {
            return this.m_name;
        }

        public int getOperator() {
            return this.m_operator;
        }

        public Object getValue() {
            return this.m_value;
        }

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("name = [");
            ret.append(this.m_name);
            ret.append("], operator = [");
            ret.append(String.valueOf(this.m_operator));
            ret.append(" - ");
            ret.append(OwSearchOperator.getOperatorDisplayString(Locale.ENGLISH, this.m_operator));
            ret.append("], value = [");
            ret.append(this.m_value);
            ret.append("]");
            return ret.toString();
        }
    }
}

