/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwBaseComboboxRenderer;
import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwString;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OwExtJSComboboxRenderer
extends OwBaseComboboxRenderer {
    private static final Set EXTJS_STYLE_CLASSES = new LinkedHashSet();
    protected static final Map JS_2_EXT_JS_EVENTS_MAP;

    @Override
    public void renderCombo(Writer w_p) throws Exception {
        w_p.write("<script type=\"text/javascript\">\nExt.BLANK_IMAGE_URL =\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(this.getContext().getBaseURL() + "/js/extjs/resources/images/default/s.gif"));
        w_p.write("\";\n</script>\n");
        w_p.write("<div ");
        w_p.write(this.renderStyleClasses(EXTJS_STYLE_CLASSES));
        w_p.write("><select");
        if (!this.enabled) {
            w_p.write(" disabled ");
        }
        w_p.write(" name='");
        OwHTMLHelper.writeSecureHTML(w_p, this.m_fieldId);
        w_p.write("' id='");
        OwHTMLHelper.writeSecureHTML(w_p, this.m_fieldId);
        w_p.write("'>\n");
        for (int i = 0; i < this.m_model.getSize(); ++i) {
            w_p.write("<option value='");
            OwComboItem item = this.m_model.getItemAt(i);
            OwHTMLHelper.writeSecureHTML(w_p, item.getValue());
            w_p.write("' ");
            if (this.m_model.isSelectedItem(item)) {
                w_p.write("selected ");
            }
            w_p.write(">");
            OwHTMLHelper.writeSecureHTML(w_p, item.getDisplayName());
            w_p.write("</option>\n");
        }
        w_p.write("</select></div>\n");
        if (this.m_model.hasItemOutOfRange()) {
            w_p.write("<span class='OwInstructionName'>");
            w_p.write(OwString.localize(this.getContext().getLocale(), "app.OwStandardFieldManager.outofrangelist", "(!) Out of range list"));
            w_p.write("</span>");
        }
        w_p.write("<script type=\"text/javascript\">\n");
        String convertedVarId = "converted_" + OwHTMLHelper.encodeJavascriptVariableName(this.m_fieldId);
        w_p.write("Ext.onReady(function(){\n");
        w_p.write("     var ");
        w_p.write(convertedVarId);
        w_p.write(" = new Ext.form.ComboBox({\n");
        w_p.write("     typeAhead: true,\n");
        w_p.write("     triggerAction: 'all',\n");
        w_p.write("     transform:'");
        w_p.write(OwHTMLHelper.encodeJavascriptString(this.m_fieldId));
        w_p.write("',\n");
        w_p.write("     hiddenId:'");
        w_p.write(OwHTMLHelper.encodeJavascriptString(this.m_fieldId));
        w_p.write("',\n");
        w_p.write("     grow:true,\n");
        w_p.write("     autoWidth:'auto',\n");
        w_p.write("     listWidth:'auto',\n");
        w_p.write("     cls:'OwAjaxComponentCombo',\n");
        w_p.write("     selectOnFocus: true,\n");
        if (!this.enabled) {
            w_p.write("     disabled: true,\n");
        }
        w_p.write("     forceSelection:true\n");
        w_p.write("});\n");
        String fieldClassName = "";
        String javaClassName = "";
        int fieldProviderType = -1;
        String fieldProviderName = "";
        if (this.m_fieldDefinition != null) {
            fieldClassName = this.m_fieldDefinition.getClassName();
            javaClassName = this.m_fieldDefinition.getJavaClassName();
        }
        if (this.m_fieldProvider != null) {
            fieldProviderType = this.m_fieldProvider.getFieldProviderType();
            fieldProviderName = this.m_fieldProvider.getFieldProviderName();
        }
        w_p.write(convertedVarId);
        w_p.write(".addListener('select',function(cb,record,index){onFieldManagerFieldExit(\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(fieldClassName));
        w_p.write("\",\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(javaClassName));
        w_p.write("\",\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(Integer.toString(fieldProviderType)));
        w_p.write("\",\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(fieldProviderName));
        w_p.write("\",\"");
        w_p.write(OwHTMLHelper.encodeJavascriptString(this.m_fieldId));
        w_p.write("\",record.data[cb.valueField || cb.displayField]);});\n");
        w_p.write(this.renderEvents(convertedVarId));
        w_p.write("});\n");
        w_p.write("</script>\n");
    }

    protected String renderEvents(String convertedVarId_p) {
        String[] eventsNames = this.getAllEventsNames();
        StringBuffer eventCode = new StringBuffer();
        for (int i = 0; i < eventsNames.length; ++i) {
            String event = eventsNames[i];
            String transformedEvent = event.startsWith("on") ? event.substring(2) : event;
            StringBuffer buff = new StringBuffer(convertedVarId_p).append(".addListener(");
            String realExtJSTransformedEvent = (String)JS_2_EXT_JS_EVENTS_MAP.get(transformedEvent);
            if (realExtJSTransformedEvent != null) {
                transformedEvent = realExtJSTransformedEvent;
            }
            buff.append("'").append(transformedEvent).append("',");
            String handler = this.getEventHandler(event);
            int idx = handler.indexOf(40);
            if (idx > 0) {
                buff.append(handler.substring(0, idx));
            } else {
                buff.append(handler);
            }
            buff.append(");\n");
            eventCode.append(buff);
        }
        return eventCode.toString();
    }

    static {
        EXTJS_STYLE_CLASSES.add("OwInputControl");
        EXTJS_STYLE_CLASSES.add("OwInputControlAdvancedChoice");
        JS_2_EXT_JS_EVENTS_MAP = new HashMap();
        JS_2_EXT_JS_EVENTS_MAP.put("change", "select");
        JS_2_EXT_JS_EVENTS_MAP.put("click", "focus");
    }
}

