/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwExceptionManager;
import com.wewebu.ow.server.util.OwHTMLHelper;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Node;

public abstract class OwFieldManager
extends OwEventTarget {
    protected OwMainAppContext m_MainContext;
    private boolean m_fDEBUG_ResetCalled = false;
    protected Map m_ObjectMap = new HashMap();
    protected Map m_FieldErrors;
    protected Map m_ids2displayNames;
    private OwXMLUtil m_ConfigNode;
    private OwFieldProvider m_FieldProvier;
    protected OwEventTarget m_externalFormEventTarget = this;
    private String m_strFocusControlID;
    private boolean m_keepCurrentFocus = false;

    protected OwXMLUtil getConfigNode() {
        return this.m_ConfigNode;
    }

    @Override
    protected void init() throws Exception {
        this.m_MainContext = (OwMainAppContext)this.getContext();
    }

    public void init(OwXMLUtil configNode_p) throws Exception {
        this.m_ConfigNode = configNode_p;
    }

    public OwField getField(String strID_p) {
        return (OwField)this.m_ObjectMap.get(new Integer(strID_p));
    }

    public void setFieldProvider(OwFieldProvider fieldProvider_p) {
        this.m_FieldProvier = fieldProvider_p;
    }

    public boolean isFieldProviderType(int iFieldProviderType_p) {
        try {
            return (this.getFieldProvider().getFieldProviderType() & iFieldProviderType_p) != 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public boolean isFieldProviderName(String sName_p) {
        try {
            return this.getFieldProvider().getFieldProviderName().equals(sName_p);
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public OwFieldProvider getFieldProvider() {
        return this.m_FieldProvier;
    }

    @Override
    public OwEventTarget getFormTarget() {
        return this.m_externalFormEventTarget;
    }

    public void insertReadOnlyField(Writer w_p, OwField field_p) throws Exception {
        this.insertReadOnlyFieldInternal(w_p, field_p.getFieldDefinition(), field_p.getValue());
    }

    protected abstract void insertReadOnlyFieldInternal(Writer var1, OwFieldDefinition var2, Object var3) throws Exception;

    public String getFocusControlID() {
        return this.m_strFocusControlID;
    }

    protected void setFocusControlID(String strFocusControlID_p) {
        this.m_strFocusControlID = strFocusControlID_p;
        this.m_keepCurrentFocus = true;
    }

    public void insertEditField(Writer w_p, OwField field_p) throws Exception {
        if (!this.m_fDEBUG_ResetCalled) {
            throw new OwInvalidOperationException("OwFieldManager.insertEditField: Used OwFieldManager without reseting the map. Did you call OwFieldManager.Reset() in your onRender method?");
        }
        int hash = field_p.hashCode();
        this.m_ObjectMap.put(hash, field_p);
        if (this.m_strFocusControlID == null) {
            this.m_strFocusControlID = String.valueOf(hash);
        }
        this.insertEditFieldInternal(w_p, field_p.getFieldDefinition(), field_p, String.valueOf(hash));
    }

    protected abstract void insertEditFieldInternal(Writer var1, OwFieldDefinition var2, OwField var3, String var4) throws Exception;

    protected static boolean safeEqual(Object obj1_p, Object obj2_p) {
        if (obj1_p == null && obj2_p == null) {
            return true;
        }
        if (obj1_p != null && obj2_p != null) {
            if (obj1_p instanceof BigDecimal && obj2_p instanceof BigDecimal) {
                BigDecimal bigDecimalObj1 = (BigDecimal)obj1_p;
                BigDecimal bigDecimalObj2 = (BigDecimal)obj2_p;
                return bigDecimalObj1.compareTo(bigDecimalObj2) == 0;
            }
            if (obj1_p.getClass().isArray()) {
                boolean result = true;
                try {
                    Object[] obj1Array = (Object[])obj1_p;
                    Object[] obj2Array = (Object[])obj2_p;
                    boolean bl = result = obj1Array.length == obj2Array.length;
                    if (result) {
                        for (int i = 0; i < obj1Array.length && (result = OwFieldManager.safeEqual(obj1Array[i], obj2Array[i])); ++i) {
                        }
                    }
                }
                catch (Exception e) {
                    result = false;
                }
                return result;
            }
            return obj1_p.equals(obj2_p);
        }
        return false;
    }

    public static void computeChangedFields(Map originalFields_p, Map compareFields_p, Map changedProperties_p) throws Exception {
        for (OwField field : originalFields_p.values()) {
            String strClassName = field.getFieldDefinition().getClassName();
            OwField compareProp = (OwField)compareFields_p.get(strClassName);
            if (null == compareProp || OwFieldManager.safeEqual(field.getValue(), compareProp.getValue())) continue;
            changedProperties_p.put(strClassName, compareProp);
        }
    }

    public boolean update(HttpServletRequest request_p, Map changedFields_p, Map compareMap_p) throws Exception {
        return this.update(request_p, changedFields_p, compareMap_p, false);
    }

    protected boolean update(HttpServletRequest request_p, Map changedFields_p, Map compareMap_p, boolean fIgnoreErrors_p) throws Exception {
        boolean fRet = true;
        this.m_FieldErrors = null;
        for (OwField field : this.m_ObjectMap.values()) {
            OwFieldDefinition definition = field.getFieldDefinition();
            try {
                Object newValue = this.updateFieldInternal(request_p, definition, field.getValue(), String.valueOf(field.hashCode()));
                if (changedFields_p != null) {
                    if (compareMap_p != null) {
                        OwField compareProp = (OwField)compareMap_p.get(field.getFieldDefinition().getClassName());
                        if (!OwFieldManager.safeEqual(newValue, compareProp.getValue())) {
                            changedFields_p.put(definition.getClassName(), field);
                        }
                    } else if (!OwFieldManager.safeEqual(newValue, field.getValue())) {
                        changedFields_p.put(definition.getClassName(), field);
                    }
                }
                field.setValue(newValue);
            }
            catch (Exception e) {
                if (!fIgnoreErrors_p) {
                    String strError = OwExceptionManager.getExceptionDisplayText(e);
                    if (strError == null || strError.length() == 0) {
                        strError = this.getContext().localize("app.OwFieldManager.unknownerrorinfield", "The inserted value is invalid.");
                    }
                    this.setFieldError(field, strError);
                }
                fRet = false;
            }
        }
        return fRet && (this.m_FieldErrors == null || this.m_FieldErrors.isEmpty());
    }

    public String getFieldJSErrorCtrlID(OwField field_p) {
        return String.valueOf(field_p.hashCode());
    }

    public String getSafeFieldError(OwField field_p) throws Exception {
        if (this.m_FieldErrors != null) {
            String strErr = (String)this.m_FieldErrors.get(field_p.hashCode());
            if (strErr != null) {
                return strErr;
            }
            return "";
        }
        return "";
    }

    public void resetErrors() {
        if (this.m_FieldErrors != null) {
            this.m_FieldErrors.clear();
        }
        if (this.m_ids2displayNames != null) {
            this.m_ids2displayNames.clear();
        }
    }

    public String renderErrors() throws Exception {
        StringBuffer result = new StringBuffer();
        if (this.m_FieldErrors != null && this.m_FieldErrors.size() > 0) {
            result.append("<div name=\"Errors\" class=\"OwAllFieldErrors\">");
            Iterator fieldIds = this.m_FieldErrors.keySet().iterator();
            boolean isFirstLine = false;
            while (fieldIds.hasNext()) {
                Integer fieldId = (Integer)fieldIds.next();
                if (this.m_ObjectMap == null) continue;
                if (!isFirstLine) {
                    if (this.m_FieldErrors.size() > 1) {
                        result.append(this.getContext().localize("app.OwFieldManager.errors", "Errors:"));
                        result.append("<br/>");
                    }
                    isFirstLine = true;
                } else {
                    result.append("<br/>");
                }
                StringWriter writer = new StringWriter();
                if (this.m_ids2displayNames.containsKey(fieldId)) {
                    result.append(this.getContext().localize1("app.OwFieldManager.errorForField", "Error for field %1:", (String)this.m_ids2displayNames.get(fieldId)));
                    result.append("&nbsp;");
                }
                OwHTMLHelper.writeSecureHTML(writer, (String)this.m_FieldErrors.get(fieldId));
                result.append(writer.toString());
            }
            result.append("</div>");
        }
        return result.toString();
    }

    public void clearFieldError(OwField field_p) {
        Integer hash = field_p.hashCode();
        if (this.m_FieldErrors != null) {
            this.m_FieldErrors.remove(hash);
            if (this.m_FieldErrors.isEmpty()) {
                this.m_FieldErrors = null;
            }
        }
        if (this.m_ids2displayNames != null) {
            this.m_ids2displayNames.remove(hash);
            if (this.m_ids2displayNames.isEmpty()) {
                this.m_ids2displayNames = null;
            }
        }
    }

    public void setFieldError(OwField field_p, String strError_p) {
        if (this.m_FieldErrors == null) {
            this.m_FieldErrors = new LinkedHashMap();
        }
        if (this.m_ids2displayNames == null) {
            this.m_ids2displayNames = new LinkedHashMap();
        }
        Integer hash = field_p.hashCode();
        this.m_FieldErrors.put(hash, strError_p);
        try {
            this.m_ids2displayNames.put(hash, field_p.getFieldDefinition().getDisplayName(this.getContext().getLocale()));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public boolean getUpdateStatus() {
        return this.m_FieldErrors == null;
    }

    protected abstract Object updateFieldInternal(HttpServletRequest var1, OwFieldDefinition var2, Object var3, String var4) throws Exception;

    public abstract void attachFieldControlByClass(String var1, OwFieldManagerControl var2, Node var3) throws Exception;

    public abstract void attachFieldControlByType(String var1, OwFieldManagerControl var2, Node var3) throws Exception;

    public abstract OwMimeManager getMimeManager();

    public void reset() {
        this.m_ObjectMap.clear();
        this.m_fDEBUG_ResetCalled = true;
        if (this.m_keepCurrentFocus) {
            this.m_keepCurrentFocus = false;
        } else {
            this.m_strFocusControlID = null;
        }
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        return this.update(request_p, null, null, true);
    }

    @Override
    public void setExternalFormTarget(OwEventTarget eventtarget_p) throws Exception {
        this.m_externalFormEventTarget = eventtarget_p;
    }

    @Override
    public String getFormName() {
        if (this == this.m_externalFormEventTarget) {
            return null;
        }
        return this.m_externalFormEventTarget.getFormName();
    }

    public abstract void insertLabel(Writer var1, boolean var2, boolean var3, OwProperty var4, String var5, boolean var6) throws Exception;
}

