/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.app.OwComboModel;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.util.OwString;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class OwFieldManagerComboModel
implements OwComboModel {
    static final String EMPTY_VALUE_DISPLAY_VALUE = "\u00a0";
    private List m_items = new LinkedList();
    private OwComboItem m_selectedItem;
    private boolean m_hasItemOutOfRange;

    public OwFieldManagerComboModel(Locale locale_p, boolean allowEmptyField_p, String selectedValue_p, String[] displayNames_p, String[] values_p) {
        if (values_p == null || displayNames_p == null || values_p.length != displayNames_p.length) {
            throw new IllegalArgumentException();
        }
        if (allowEmptyField_p) {
            OwDefaultComboItem emptyValue = new OwDefaultComboItem("", EMPTY_VALUE_DISPLAY_VALUE);
            this.m_items.add(emptyValue);
            if (selectedValue_p == null || selectedValue_p.equals("")) {
                this.m_selectedItem = emptyValue;
            }
        }
        for (int i = 0; i < values_p.length; ++i) {
            OwDefaultComboItem owDefaultComboItem = new OwDefaultComboItem(values_p[i], displayNames_p[i]);
            this.m_items.add(owDefaultComboItem);
            if (selectedValue_p == null || values_p[i] == null || selectedValue_p.compareTo(values_p[i]) != 0) continue;
            this.m_selectedItem = owDefaultComboItem;
        }
        if (this.m_selectedItem == null && selectedValue_p != null && !selectedValue_p.equals("")) {
            OwDefaultComboItem outOfRangeItem = new OwDefaultComboItem(selectedValue_p, OwString.localize1(locale_p, "app.OwStandardFieldManager.outofrangelist.symbol", "(%1)", selectedValue_p));
            this.m_items.add(outOfRangeItem);
            this.m_selectedItem = outOfRangeItem;
            this.m_hasItemOutOfRange = true;
        }
    }

    @Override
    public OwComboItem[] getAllItems() {
        return this.m_items.toArray(new OwComboItem[this.m_items.size()]);
    }

    @Override
    public OwComboItem getSelectedItem() {
        return this.m_selectedItem;
    }

    @Override
    public int getSize() {
        return this.m_items.size();
    }

    @Override
    public boolean isSelectedItem(OwComboItem item_p) {
        return this.m_selectedItem != null && this.m_items.contains(item_p) && item_p.equals(this.m_selectedItem);
    }

    @Override
    public void setSelectedItem(OwComboItem item_p) {
        this.m_selectedItem = item_p;
    }

    @Override
    public OwComboItem getItemAt(int position_p) {
        OwComboItem item = null;
        if (position_p < this.m_items.size() && position_p >= 0) {
            item = (OwComboItem)this.m_items.get(position_p);
        }
        return item;
    }

    @Override
    public boolean hasItemOutOfRange() {
        return this.m_hasItemOutOfRange;
    }
}

