/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwComboItem;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.ui.OwUISubModul;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.util.OwExceptionManager;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import org.w3c.dom.Node;

public class OwLoginView
extends OwLayout {
    public static final int LOGINPART_REGION = 1;
    public static final int ERROR_REGION = 2;
    public static final int LOCALS_REGION = 3;
    protected OwMainAppContext m_MainContext;
    protected OwConfiguration m_Configuration;
    protected OwUISubModul m_LoginSubModul;
    private static final String LANG_SELECT_ID = "language_select";

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MainContext = (OwMainAppContext)this.getContext();
        this.m_Configuration = this.m_MainContext.getConfiguration();
        this.m_LoginSubModul = this.m_MainContext.getNetwork().getLoginSubModul();
        this.addView(this.m_LoginSubModul, 1, null);
    }

    @Override
    public boolean isRegion(int iRegion_p) {
        switch (iRegion_p) {
            case 3: {
                return ((OwMainAppContext)this.getContext()).getConfiguration().displayLanguageSelection();
            }
            case 2: {
                return this.m_MainContext.getError() != null;
            }
        }
        return super.isRegion(iRegion_p);
    }

    public void renderLocalsRegion(Writer w_p) throws Exception {
        if (this.isRegion(3)) {
            String strLang = null;
            Iterator it = ((OwMainAppContext)this.getContext()).getConfiguration().getAvailableLanguages().iterator();
            LinkedList<OwDefaultComboItem> lang = new LinkedList<OwDefaultComboItem>();
            String strSelectedLang = "";
            while (it.hasNext()) {
                Node langNode = (Node)it.next();
                strLang = langNode.getFirstChild().getNodeValue();
                String strDisplayName = OwXMLDOMUtil.getSafeStringAttributeValue(langNode, "displayname", strLang);
                OwDefaultComboItem item = new OwDefaultComboItem(strLang, strDisplayName);
                lang.add(item);
            }
            if (lang.size() > 1) {
                strSelectedLang = ((OwMainAppContext)this.getContext()).getLocale().getLanguage();
                OwDefaultComboModel comboModel = new OwDefaultComboModel(false, false, strSelectedLang, lang);
                OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(comboModel, LANG_SELECT_ID, null, null, null);
                renderer.addEvent("onchange", "selectLanguage();");
                renderer.renderCombo(w_p);
            } else if (lang.size() == 1) {
                ((OwMainAppContext)this.getContext()).setLocale(new Locale(((OwComboItem)lang.get(0)).getValue()));
            }
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 2: {
                Throwable e = this.m_MainContext.getError();
                if (e == null) break;
                OwExceptionManager.PrintCatchedException(this.getContext().getLocale(), e, new PrintWriter(w_p), "OwErrorStack");
                break;
            }
            case 3: {
                this.renderLocalsRegion(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwLoginView.jsp", w_p);
    }
}

