/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwClassicComboboxRenderer;
import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwComboModel;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwComboboxRendererFactory;
import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwContextBasedUOListenerFactory;
import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.app.OwPluginKeyBoardMaping;
import com.wewebu.ow.server.app.OwScript;
import com.wewebu.ow.server.app.OwSettings;
import com.wewebu.ow.server.app.OwSettingsProperty;
import com.wewebu.ow.server.app.OwUserOperationDispatch;
import com.wewebu.ow.server.app.OwUserOperationEvent;
import com.wewebu.ow.server.app.OwUserOperationExecutor;
import com.wewebu.ow.server.app.OwUserOperationListener;
import com.wewebu.ow.server.app.OwWindowPositions;
import com.wewebu.ow.server.app.viewer.OwSimpleInfoProviderRegistry;
import com.wewebu.ow.server.conf.OwBaseConfiguration;
import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwRepositoryContext;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwSessionException;
import com.wewebu.ow.server.exceptions.OwUserOperationException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.history.OwHistoryManager;
import com.wewebu.ow.server.history.OwHistoryManagerContext;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.mandator.OwMandator;
import com.wewebu.ow.server.mandator.OwMandatorManager;
import com.wewebu.ow.server.mandator.OwMandatorManagerContext;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.ui.OwAppContext;
import com.wewebu.ow.server.ui.OwDialogManager;
import com.wewebu.ow.server.ui.OwKeyAction;
import com.wewebu.ow.server.ui.OwKeySetting;
import com.wewebu.ow.server.ui.viewer.OwInfoProviderRegistry;
import com.wewebu.ow.server.util.OwAttributeBagWriteable;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import com.wewebu.ow.server.util.OwSimpleAttributeBagWriteable;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.File;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.w3c.dom.Node;

public class OwMainAppContext
extends OwAppContext
implements OwHistoryManagerContext,
OwRoleManagerContext,
OwNetworkContext,
OwMandatorManagerContext,
OwComboboxRendererFactory {
    private static final Logger LOG = OwLogCore.getLogger(OwMainAppContext.class);
    protected static final String WINDOW_POSITIONS_APP_SETTINGS_NAME = "WindowPositions";
    public static final String LITERAL_PLACEHOLDER_TODAY = "today";
    public static final String LITERAL_PLACEHOLDER_USER_ID = "userid";
    public static final String LITERAL_PLACEHOLDER_USER_NAME = "username";
    public static final String LITERAL_PLACEHOLDER_USER_LONG_NAME = "userlongname";
    public static final String LITERAL_PLACEHOLDER_USER_SHORT_NAME = "usershortname";
    public static final String LITERAL_PLACEHOLDER_USER_DISPLAY_NAME = "userdisplayname";
    private static final String LOCAL_QUERY_KEY = "owloc";
    public static final String CONFIGNODE_URLOVERWRITE = "UrlOverwrite";
    public static final String CONFIGNODE_SERVER = "Server";
    public static final String CONFIGNODE_BASE = "Base";
    public static final String PREFIX_DRAGDROP = "dragdrop_";
    private List m_DND_importedDocumentsList = new ArrayList();
    private String m_DND_currentUploadDir = null;
    private int m_DND_nextFileID = 0;
    private Map<String, OwKeySetting> pluginKeySettings = null;
    private OwConfiguration m_Configuration;
    private Throwable m_Error;
    private Vector m_Messages;
    private Locale m_local;
    private OwRepositoryContext.OwConfigChangeEvent m_configchangeevent = new OwRepositoryContext.OwConfigChangeEvent();
    private List m_strFinalScripts = new LinkedList();
    protected OwClipboard m_clipboard;
    private OwMasterView m_activemasterview;
    private final Random m_Random = new Random();
    private String m_sCurrentMasterPluginStyleClassID = "default";
    private Map<String, String> m_ajaxUpdateContainers = new HashMap<String, String>();
    private OwInfoProviderRegistry infoProvReg;
    private String overwriteServerUrl;
    private String overwriteBaseUrl;
    private OwUserOperationDispatch userOperationDispatch = new OwUserOperationDispatch();
    private List sessionCookieNames = null;
    private List m_deleteDirs;

    public OwMainAppContext() {
        this.m_Configuration = this.createConfiguration();
        this.m_clipboard = this.createClipboard();
        this.registerInterface(OwHistoryManagerContext.class, this);
        this.registerInterface(OwRoleManagerContext.class, this);
        this.registerInterface(OwNetworkContext.class, this);
        this.registerInterface(OwMandatorManagerContext.class, this);
        this.registerInterface(OwUserOperationDispatch.class, this.userOperationDispatch);
        this.registerInterface(OwUserOperationExecutor.class, this.userOperationDispatch);
        this.registerInterface(OwComboboxRendererFactory.class, this);
    }

    protected OwConfiguration createConfiguration() {
        return new OwConfiguration();
    }

    protected OwClipboard createClipboard() {
        return new OwClipboard();
    }

    public String getCurrentMasterPluginID() {
        return this.m_activemasterview.getPluginID();
    }

    public String getSafeCurrentMasterPluginStyleClassID() {
        return this.m_sCurrentMasterPluginStyleClassID;
    }

    public OwMasterView getCurrentMasterView() {
        return this.m_activemasterview;
    }

    public void onActivateMasterPlugin(OwMasterView view_p) throws Exception {
        this.m_activemasterview = view_p;
        this.m_sCurrentMasterPluginStyleClassID = OwString.replaceAll(view_p.getPluginID(), ".", "_");
        this.getHistoryManager().addEvent(1, view_p.getPluginID(), 1);
    }

    @Override
    public OwDialogManager getDialogManager() {
        try {
            return this.m_activemasterview.getDialogManager();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Throwable getError() {
        return this.m_Error;
    }

    public void setError(Throwable exception_p) {
        this.m_Error = exception_p;
    }

    public Collection getMessages() {
        if (this.m_Messages == null) {
            this.m_Messages = new Vector();
        }
        return this.m_Messages;
    }

    public void postMessage(String sMessage_p) {
        this.getMessages().add(sMessage_p);
    }

    @Override
    public void init(OwAppContext oldcontext_p) throws Exception {
        super.init(oldcontext_p);
        this.m_Configuration.init(this);
        OwXMLUtil overwriteConfig = this.getConfiguration().getBootstrapConfiguration().getSubUtil(CONFIGNODE_URLOVERWRITE);
        if (overwriteConfig != null) {
            this.overwriteServerUrl = overwriteConfig.getSafeTextValue(CONFIGNODE_SERVER, null);
            this.overwriteBaseUrl = overwriteConfig.getSafeTextValue(CONFIGNODE_BASE, null);
        }
        this.m_clipboard.init(this);
        if (oldcontext_p != null) {
            this.setLocale(oldcontext_p.getLocale());
        } else if (this.getLocale() == null) {
            Locale browserLocale;
            this.setLocale(new Locale(this.m_Configuration.getDefaultLanguage()));
            if (this.m_Configuration.getDetectBrowserLocale() && null != (browserLocale = this.getHttpRequest().getLocale()) && null != browserLocale.getLanguage()) {
                this.setLocale(this.getLocaleForString(browserLocale.getLanguage()));
            }
        }
    }

    protected void initializeUserOperationListeners() throws Exception {
        Set<OwContextBasedUOListenerFactory> factories = this.getConfiguration().getUserOperationListenerFactories();
        if (factories != null && factories.size() > 0) {
            for (OwContextBasedUOListenerFactory factory : factories) {
                this.userOperationDispatch.addUserOperationListener(factory.createListener());
            }
        }
    }

    @Override
    protected void init() throws Exception {
    }

    @Override
    public void onLogin(OwBaseUserInfo user_p) throws OwConfigurationException {
        try {
            this.getMandatorManager().loginInit(user_p);
            this.initializeUserOperationListeners();
            OwUserOperationEvent.OwUserOperationType.LOGIN.fire(this.userOperationDispatch, user_p, OwUserOperationEvent.OWD_APPLICATION);
        }
        catch (Exception e) {
            String msg = "The Mandator Manager (" + this.getMandatorManager().getClass().toString() + ") can not be initialized after login.";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwConfigurationException(OwString.localize1(this.getLocale(), "app.OwConfiguration.mandatormanageriniterror", "The Tenant Manager (%1) can not be initialized after login.", this.getMandatorManager().getClass().toString()), (Throwable)e);
        }
    }

    @Override
    public Locale getLocale() {
        return this.m_local;
    }

    @Override
    public void setLocale(Locale locale_p) {
        this.m_local = locale_p;
    }

    public boolean isAllowed(int iCategory_p, String strFunctionName_p) throws Exception {
        return this.getRoleManager().isAllowed(iCategory_p, strFunctionName_p);
    }

    @Override
    public void loginInit() throws Exception {
        this.m_Configuration.loginInit();
    }

    @Override
    public OwNetwork getNetwork() {
        return this.m_Configuration.getNetwork();
    }

    @Override
    public OwHistoryManager getHistoryManager() {
        return this.m_Configuration.getHistoryManager();
    }

    public OwRoleManager getRoleManager() {
        return this.m_Configuration.getRoleManager();
    }

    public OwFieldManager createFieldManager() throws Exception {
        return this.m_Configuration.createFieldManager();
    }

    public OwConfiguration getConfiguration() {
        return this.m_Configuration;
    }

    @Override
    public OwBaseConfiguration getBaseConfiguration() {
        return this.m_Configuration;
    }

    public OwSettings getSettings() {
        return this.m_Configuration.getSettings();
    }

    public OwCredentials getCredentials() throws Exception {
        return this.getNetwork().getCredentials();
    }

    @Override
    public boolean isLogin() throws Exception {
        return this.getNetwork().getCredentials() != null;
    }

    @Override
    public boolean isContainerBasedAuthenticated() throws Exception {
        return this.getNetwork().getCredentials() != null && this.getNetwork().getCredentials().isContainerBasedAuthenticated();
    }

    @Override
    public void logout() throws Exception {
        this.onSessionTimeOut(this.getHttpSession());
        super.logout();
    }

    public void onSessionTimeOut(HttpSession httpSession_p) {
        try {
            this.broadcast(null, 9);
        }
        catch (Exception e) {
            LOG.error((Object)("Logout broadcast failed for session: " + this.getSessionDisplayName()), (Throwable)e);
        }
        try {
            String tempDir = this.getConfiguration().getTempDir().replace('\\', '/');
            if (tempDir.endsWith("/")) {
                this.deleteDir(tempDir + httpSession_p.getId());
            } else {
                this.deleteDir(tempDir + "/" + httpSession_p.getId());
            }
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"OwMainAppContext.onSessionTimeOut: Error occured during deleting temp folder: ", (Throwable)ex);
            }
            LOG.warn((Object)"OwMainAppContext.onSessionTimeOut: Could not delete user temp folder!");
        }
        try {
            this.getNetwork().logout();
        }
        catch (Exception e) {
            LOG.error((Object)("Logout failed for session: " + this.getSessionDisplayName()), (Throwable)e);
        }
    }

    @Override
    public String getDesignDir() throws Exception {
        return "/designs/" + this.getRoleManager().getDesign();
    }

    @Override
    public String getDesignURL() throws Exception {
        return this.getBaseURL() + this.getDesignDir();
    }

    public String getLocalEventURL(String strLangID_p) {
        return this.getJSPPageURL() + "?" + LOCAL_QUERY_KEY + "=" + strLangID_p;
    }

    public void openHelp(String sHelppath_p) throws Exception {
        for (OwConfiguration.OwMasterPluginInstance inst : this.getConfiguration().getMasterPlugins(false)) {
            if (!inst.getPluginClassName().equals("com.wewebu.ow.server.plug.owhelp.OwHelpDocument")) continue;
            inst.getDocument().dispatch(1, sHelppath_p, null);
            break;
        }
    }

    @Override
    public boolean handleRequest(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        this.deleteMarkedDirectorys();
        String strLocal = request_p.getParameter(LOCAL_QUERY_KEY);
        if (strLocal != null) {
            this.setLocale(this.getLocaleForString(strLocal));
        }
        if (this.getConfiguration().getSSLMode() == 1 && !request_p.isSecure()) {
            LOG.error((Object)"OwMainAppContext.handleRequest: The session requires a secure connection, please use the https connection provided by the administrator.");
            throw new OwSessionException(OwString.localize(this.getLocale(), "app.OwMainAppContext.sslenforced", "The session requires a secure connection, please use the https connection provided by the administrator."));
        }
        this.setError(null);
        this.resetMessages();
        try {
            return super.handleRequest(request_p, response_p);
        }
        catch (Throwable handleRequestError) {
            try {
                if (this.getConfiguration().getMessageBoxOnUserError()) {
                    String sMessage = ((OwUserOperationException)handleRequestError.getCause()).getMessage(this.getLocale());
                    this.addFinalScript("alert('" + sMessage + "');");
                    LOG.error((Object)"OwMainAppContext handleRequest Exception...", handleRequestError);
                    return true;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"OwMainAppContext.handleRequest: Error creating the Message-Box-On-User-Error...", (Throwable)e);
            }
            LOG.error((Object)"OwMainAppContext handleRequest Exception...", handleRequestError);
            this.setError(handleRequestError);
            if (handleRequestError instanceof Error) {
                LOG.error((Object)"\n\n\nERROR:OwMainAppContext handleRequest ERROR", handleRequestError);
            }
            return true;
        }
    }

    public void addFinalScript(OwScript script_p) {
        int i;
        for (i = 0; i < this.m_strFinalScripts.size(); ++i) {
            OwScript element = (OwScript)this.m_strFinalScripts.get(i);
            if (script_p.getPriority() > element.getPriority()) break;
        }
        this.m_strFinalScripts.add(i, script_p);
    }

    public boolean addUniqueFinalScript(OwScript script_p) {
        boolean scriptAdded = false;
        if (!this.m_strFinalScripts.contains(script_p)) {
            this.addFinalScript(script_p);
            scriptAdded = true;
        }
        return scriptAdded;
    }

    public void addFinalScript(String strScript_p) {
        this.addFinalScript(new OwScript(strScript_p));
    }

    public void clearFinalScript() {
        this.m_strFinalScripts.clear();
    }

    public String getFinalScript() {
        StringBuilder strFinalScript = new StringBuilder();
        for (OwScript aFinalScript : this.m_strFinalScripts) {
            strFinalScript.append(aFinalScript.getScript());
        }
        return strFinalScript.toString();
    }

    @Override
    public String getSessionDisplayName() {
        try {
            return this.getNetwork().getCredentials().getUserInfo().getUserLongName();
        }
        catch (Exception e) {
            return "?";
        }
    }

    @Override
    public OwBaseUserInfo getUserInfo() {
        try {
            return this.getNetwork().getCredentials().getUserInfo();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void dump(Writer w_p) throws Exception {
        w_p.write("<table cellspacing='0' cellpadding='0' border='1' width='100%'>");
        w_p.write("<tr bgcolor='#aaaaaa'><td class='OwDump'>");
        w_p.write("<b>MainAppContext</b>");
        w_p.write("</td></tr>");
        w_p.write("</table>");
        super.dump(w_p);
    }

    public OwClipboard getClipboard() {
        return this.m_clipboard;
    }

    @Override
    public String getConfigurationName() {
        return this.getJSPPageURL();
    }

    @Override
    public String localizeLabel(String strName_p) {
        return OwString.localizeLabel(this.getLocale(), strName_p);
    }

    @Override
    public boolean hasLabel(String strName_p) {
        return OwString.hasLabel(this.getLocale(), strName_p);
    }

    public void registerPluginKeyEvent(String strPluginID_p, String strEventURL_p, String strFormName_p, String strDescription_p) throws Exception {
        OwKeySetting setting;
        if (this.pluginKeySettings == null) {
            Collection keyMapping = this.getSafeListAppSetting("KeyboardCommandMap");
            if (keyMapping.size() == 0) {
                return;
            }
            this.pluginKeySettings = OwPluginKeyBoardMaping.toKeySettings(keyMapping);
        }
        if (null != (setting = this.pluginKeySettings.get(strPluginID_p))) {
            OwKeyAction action = setting.createAction(strEventURL_p, strFormName_p, strDescription_p);
            action.register(this);
        }
    }

    public int getSafeIntAppSetting(String strName_p, int iDefault_p) {
        try {
            return (Integer)((OwSettingsProperty)this.m_Configuration.getAppSettings().getProperties().get(strName_p)).getValue();
        }
        catch (Exception e) {
            return iDefault_p;
        }
    }

    public String getSafeStringAppSetting(String strName_p, String strDefault_p) {
        try {
            return (String)((OwSettingsProperty)this.m_Configuration.getAppSettings().getProperties().get(strName_p)).getValue();
        }
        catch (Exception e) {
            return strDefault_p;
        }
    }

    public Collection getSafeListAppSetting(String strName_p) {
        try {
            return (Collection)((OwSettingsProperty)this.m_Configuration.getAppSettings().getProperties().get(strName_p)).getValue();
        }
        catch (Exception e) {
            return new Vector();
        }
    }

    public boolean getSafeBooleanAppSetting(String strName_p, boolean default_p) {
        try {
            return (Boolean)((OwSettingsProperty)this.m_Configuration.getAppSettings().getProperties().get(strName_p)).getValue();
        }
        catch (Exception e) {
            return default_p;
        }
    }

    public boolean useJS_DateControl() {
        return this.m_Configuration.getBootstrapConfiguration().getSafeBooleanValue("UseJSDateControl", false);
    }

    public String getDateFormatString() {
        return this.getSafeStringAppSetting("DateFormatString", "dd.MM.yyyy (HH:mm)");
    }

    public String getTimeFormatString() {
        return this.getSafeStringAppSetting("TimeFormatString", "HH:mm:ss");
    }

    public String getDateFormatStringWithoutTime() {
        return OwDateTimeUtil.removeTimeFormatTokens(this.getDateFormatString());
    }

    public String getDateFormatStringWithoutDate() {
        return OwDateTimeUtil.removeDateFormatTokens(this.getTimeFormatString());
    }

    public int getMaxClipboardSize() {
        return this.getSafeIntAppSetting("MaxClipboardSize", 10);
    }

    public Collection getClipboardAvailableDocFunctionIds() {
        return this.getSafeListAppSetting("DocFunctionsInClipboard");
    }

    public boolean doShowClipboard() {
        return this.getSafeBooleanAppSetting("showclipboard", true);
    }

    public boolean doShowWildCardDescriptions() {
        return this.getSafeBooleanAppSetting("showwildcarddescriptions", false);
    }

    public boolean isUseHtml5DragAndDrop() {
        return this.getSafeBooleanAppSetting("UseHtml5DragAndDrop", false);
    }

    public int getPageSizeForLists() {
        return this.getSafeIntAppSetting("pagesize", 20);
    }

    public String getStartupID() {
        return this.getSafeStringAppSetting("startupid", null);
    }

    public int getMaxSortCriteriaCount() {
        int iMaxSort = this.getSafeIntAppSetting("MaxSortCriteriaCount", 1);
        if (iMaxSort < 1) {
            iMaxSort = 1;
        }
        return iMaxSort;
    }

    public OwWindowPositions getWindowPositions() {
        try {
            OwSettingsProperty prop = (OwSettingsProperty)this.m_Configuration.getAppSettings().getProperties().get(WINDOW_POSITIONS_APP_SETTINGS_NAME);
            return (OwWindowPositions)prop.getValue();
        }
        catch (Exception e) {
            return OwWindowPositions.getUndefWindowPosition();
        }
    }

    public String getWindowPositionsSaveURL() {
        return this.getInfiniteEventURL(this, "SaveWindowPositions", null);
    }

    public void onSaveWindowPositions(HttpServletRequest request_p) throws Exception {
        OwWindowPositions pos = (OwWindowPositions)((OwSettingsProperty)this.m_Configuration.getAppSettings().getProperties().get(WINDOW_POSITIONS_APP_SETTINGS_NAME)).getValue();
        try {
            pos.setFromRequest(request_p, "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_Configuration.getSettings().saveUserPrefs();
    }

    @Override
    public void deleteTempDir(String strDir_p) {
        if (this.m_deleteDirs == null) {
            this.m_deleteDirs = new LinkedList();
        }
        this.m_deleteDirs.add(strDir_p);
    }

    private void deleteMarkedDirectorys() {
        if (this.m_deleteDirs == null) {
            return;
        }
        Iterator it = this.m_deleteDirs.iterator();
        while (it.hasNext()) {
            try {
                this.deleteDir((String)it.next());
            }
            catch (Exception exception) {}
        }
        this.m_deleteDirs = null;
    }

    private void deleteDir(String strDir_p) {
        boolean dirExists;
        File delDir = new File(strDir_p);
        String[] list = delDir.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                File file = new File(delDir, list[i]);
                if (file.isFile()) {
                    boolean fileExists = file.exists();
                    if (!fileExists || file.delete() || !LOG.isInfoEnabled()) continue;
                    LOG.warn((Object)("OwMainAppContext.deleteDir: Error deleting all files of directory, name = " + strDir_p));
                    continue;
                }
                this.deleteDir(file.getAbsolutePath());
            }
        }
        if ((dirExists = delDir.exists()) && !delDir.delete() && LOG.isInfoEnabled()) {
            LOG.warn((Object)("OwMainAppContext.deleteDir: Error deleting the directory, name = " + strDir_p));
        }
    }

    @Override
    public String createTempDir(String strPrefix_p) throws OwConfigurationException {
        boolean success;
        StringBuilder tempDir = new StringBuilder(this.getConfiguration().getTempDir());
        tempDir.append("/");
        tempDir.append(this.getHttpSession().getId());
        tempDir.append("/");
        tempDir.append(strPrefix_p);
        tempDir.append("_");
        tempDir.append(System.currentTimeMillis());
        tempDir.append("_");
        tempDir.append(this.m_Random.nextInt());
        File dir = null;
        dir = new File(tempDir.toString());
        if (!dir.exists() && !(success = dir.mkdirs())) {
            String msg = "OwMainAppContext.createTempDir: Temp directory could not be created. Check bootstrap.xml for TempDir setting.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        return tempDir.toString();
    }

    public String getDragAndDropUploadDir() {
        return null;
    }

    public void clearDragDropUploadDir() throws Exception {
    }

    public void addDNDImportedDocumentToStack(OwDocumentImportItem importedDocument_p) {
        this.m_DND_importedDocumentsList.add(importedDocument_p);
    }

    public OwDocumentImportItem getDNDImportedDocument(int i_p) {
        return (OwDocumentImportItem)this.m_DND_importedDocumentsList.get(i_p);
    }

    public int getDNDImportedDocumentsCount() {
        return this.m_DND_importedDocumentsList.size();
    }

    public void releaseDNDImportedDocuments() throws Exception {
        for (int i = 0; i < this.m_DND_importedDocumentsList.size(); ++i) {
            ((OwDocumentImportItem)this.m_DND_importedDocumentsList.get(i)).release();
        }
        this.m_DND_importedDocumentsList = new ArrayList();
        String dirToDelete = this.m_DND_currentUploadDir;
        this.m_DND_currentUploadDir = null;
        this.m_DND_nextFileID = 0;
        if (dirToDelete != null) {
            this.deleteDir(dirToDelete);
        }
    }

    public String getDNDDocumentImportTempDir() throws OwConfigurationException {
        if (this.m_DND_currentUploadDir == null) {
            this.m_DND_currentUploadDir = this.createTempDir(PREFIX_DRAGDROP);
        }
        return this.m_DND_currentUploadDir;
    }

    public int getNextDNDDocumentImportFileID() {
        return this.m_DND_nextFileID++;
    }

    public OwAttributeBagWriteable createUserAttributeBag(String sName_p) throws Exception {
        try {
            OwAttributeBagWriteable attributeBagWriteable = (OwAttributeBagWriteable)this.getNetwork().getApplicationObject(7, sName_p, true, false);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwMainAppContext.createUserAttributeBag: User AttributeBag Writable [BagName = " + sName_p + "] was successfully initialized..."));
            }
            return attributeBagWriteable;
        }
        catch (OwObjectNotFoundException e) {
            LOG.warn((Object)("OwMainAppContext.createUserAttributeBag: No persistent User AttributeBag Writable available [BagName = " + sName_p + "], use non persistent memory writer."));
            return new OwSimpleAttributeBagWriteable();
        }
    }

    @Override
    public OwBaseUserInfo getCurrentUser() throws Exception {
        return this.getNetwork().getCredentials().getUserInfo();
    }

    @Override
    public String getClientID() {
        return this.getHttpRequest().getRemoteAddr();
    }

    @Override
    public String getDefaultFolderClassName() {
        return this.getConfiguration().getDefaultFolderClassName();
    }

    @Override
    public String getClientWildCard(int wildcardtype_p) {
        return (String)this.getConfiguration().getClientWildCardDefinitions().get(wildcardtype_p);
    }

    public OwRepositoryContext.OwConfigChangeEventListener getConfigChangeEvent() {
        return this.m_configchangeevent;
    }

    @Override
    public void addConfigChangeEventListener(OwRepositoryContext.OwConfigChangeEventListener listener_p) {
        this.m_configchangeevent.addEventListener(listener_p);
    }

    public void removeConfigChangeEventListener(OwRepositoryContext.OwConfigChangeEventListener listener_p) {
        this.m_configchangeevent.removeEventListener(listener_p);
    }

    @Override
    public String getMandatorID() {
        OwMandator mandator = this.getMandator();
        if (null == mandator) {
            return null;
        }
        return mandator.getID();
    }

    @Override
    public OwMandatorManager getMandatorManager() {
        return this.getConfiguration().getMandatorManager();
    }

    @Override
    public OwMandator getMandator() {
        return this.getConfiguration().getMandatorManager().getUserMandator();
    }

    @Override
    public JdbcTemplate getJDBCTemplate() {
        return this.m_Configuration == null ? null : this.m_Configuration.getJDBCTemplate();
    }

    @Override
    public Object resolveLiteralPlaceholder(String contextname_p, String placeholdername_p) throws Exception {
        if (placeholdername_p.equals(LITERAL_PLACEHOLDER_TODAY)) {
            return new Date();
        }
        if (placeholdername_p.equals(LITERAL_PLACEHOLDER_USER_ID)) {
            try {
                return this.getCurrentUser().getUserID();
            }
            catch (Exception e) {
                LOG.error((Object)("OwMainAppContext.resolveLiteralPlaceholder: The placeholder can not be resolved for the search template; searchtemplatename = " + contextname_p + ", placeholdername = " + placeholdername_p), (Throwable)e);
                throw new OwConfigurationException(OwString.localize2(this.getLocale(), "ecm.OwSearchTemplate.placeholderCouldNotResolved", "The placeholder (%1) cannot be resolved for the search template (%2).", placeholdername_p, contextname_p), (Throwable)e);
            }
        }
        if (placeholdername_p.equals(LITERAL_PLACEHOLDER_USER_NAME)) {
            try {
                return this.getCurrentUser().getUserName();
            }
            catch (Exception e) {
                LOG.error((Object)("OwMainAppContext.resolveLiteralPlaceholder: The placeholder can not be resolved for the search template; searchtemplatename = " + contextname_p + ", placeholdername = " + placeholdername_p), (Throwable)e);
                throw new OwConfigurationException(OwString.localize2(this.getLocale(), "ecm.OwSearchTemplate.placeholderCouldNotResolved", "The placeholder (%1) cannot be resolved for the search template (%2).", placeholdername_p, contextname_p), (Throwable)e);
            }
        }
        if (placeholdername_p.equals(LITERAL_PLACEHOLDER_USER_LONG_NAME)) {
            try {
                return this.getCurrentUser().getUserLongName();
            }
            catch (Exception e) {
                LOG.error((Object)("OwMainAppContext.resolveLiteralPlaceholder: The placeholder can not be resolved for the search template; searchtemplatename = " + contextname_p + ", placeholdername = " + placeholdername_p), (Throwable)e);
                throw new OwConfigurationException(OwString.localize2(this.getLocale(), "ecm.OwSearchTemplate.placeholderCouldNotResolved", "The placeholder (%1) cannot be resolved for the search template (%2).", placeholdername_p, contextname_p), (Throwable)e);
            }
        }
        if (placeholdername_p.equals(LITERAL_PLACEHOLDER_USER_SHORT_NAME)) {
            try {
                return this.getCurrentUser().getUserShortName();
            }
            catch (Exception e) {
                LOG.error((Object)("OwMainAppContext.resolveLiteralPlaceholder: The placeholder can not be resolved for the search template; searchtemplatename = " + contextname_p + ", placeholdername = " + placeholdername_p), (Throwable)e);
                throw new OwConfigurationException(OwString.localize2(this.getLocale(), "ecm.OwSearchTemplate.placeholderCouldNotResolved", "The placeholder (%1) cannot be resolved for the search template (%2).", placeholdername_p, contextname_p), (Throwable)e);
            }
        }
        if (placeholdername_p.equals(LITERAL_PLACEHOLDER_USER_DISPLAY_NAME)) {
            try {
                return this.getCurrentUser().getUserDisplayName();
            }
            catch (Exception e) {
                LOG.error((Object)("OwMainAppContext.resolveLiteralPlaceholder: The placeholder can not be resolved for the search template; searchtemplatename = " + contextname_p + ", placeholdername = " + placeholdername_p), (Throwable)e);
                throw new OwConfigurationException(OwString.localize2(this.getLocale(), "ecm.OwSearchTemplate.placeholderCouldNotResolved", "The placeholder (%1) cannot be resolved for the search template (%2).", placeholdername_p, contextname_p), (Throwable)e);
            }
        }
        LOG.error((Object)("OwMainAppContext.resolveLiteralPlaceholderValue: Invalid placeholder for the search template used; searchtemplatename = " + contextname_p + ", placeholdername = " + placeholdername_p));
        throw new OwConfigurationException(OwString.localize2(this.getLocale(), "ecm.OwSearchTemplate.placeholderInvalid", "Invalid placeholder (%1) for the search template (%2) used.", placeholdername_p, contextname_p));
    }

    @Override
    protected URL getAppContextResource(String resourcePath_p) {
        return OwMainAppContext.class.getResource(resourcePath_p);
    }

    public OwComboboxRenderer createComboboxRenderer(OwComboModel model_p, String strID_p, OwFieldDefinition fieldDefinition_p, OwFieldProvider fieldProvider_p, OwString description_p) {
        OwComboboxRenderer rendererInstance = null;
        try {
            rendererInstance = this.createComboboxRenderer();
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot create the combobox renderer. Default implementation will be used. Reason:", (Throwable)e);
        }
        if (rendererInstance == null) {
            rendererInstance = new OwClassicComboboxRenderer();
        }
        rendererInstance.setContext(this);
        rendererInstance.setFieldId(strID_p);
        rendererInstance.setFieldDefinition(fieldDefinition_p);
        rendererInstance.setFieldProvider(fieldProvider_p);
        rendererInstance.setModel(model_p);
        rendererInstance.setFieldDescription(description_p);
        return rendererInstance;
    }

    private Locale getLocaleForString(String strLocale_p) {
        Locale loc = new Locale(this.getConfiguration().getDefaultLanguage());
        if (null != strLocale_p) {
            Iterator it = this.getConfiguration().getAvailableLanguages().iterator();
            while (it.hasNext()) {
                try {
                    OwStandardXMLUtil langNode = new OwStandardXMLUtil((Node)it.next());
                    String strLocale = langNode.getSafeTextValue(null);
                    if (null == strLocale || !strLocale_p.equals(strLocale)) continue;
                    loc = new Locale(strLocale);
                    break;
                }
                catch (Exception e) {
                    String msg = "OwMainAppContext.getLocaleForString: could not read XML node! Skiping to next.";
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)msg, (Throwable)e);
                        continue;
                    }
                    LOG.warn((Object)msg);
                }
            }
        }
        return loc;
    }

    public void addAjaxUpdateContainer(String containerId_p, String ajaxEventHandler_p) {
        this.m_ajaxUpdateContainers.put(containerId_p, ajaxEventHandler_p);
    }

    public String getAjaxUpdateURL(String containerId_p) {
        return this.m_ajaxUpdateContainers.get(containerId_p);
    }

    @Override
    public OwInfoProviderRegistry getInfoProviderRegistry() {
        if (this.infoProvReg == null) {
            this.infoProvReg = new OwSimpleInfoProviderRegistry(this);
        }
        return this.infoProvReg;
    }

    public void resetMessages() {
        if (this.m_Messages != null) {
            this.m_Messages.clear();
            this.m_Messages = null;
        }
        this.m_Messages = new Vector();
    }

    @Override
    public void addUserOperationListener(OwUserOperationListener listener_p) {
        if (listener_p != null) {
            this.userOperationDispatch.addUserOperationListener(listener_p);
        }
    }

    @Override
    public void removeUserOperationListener(OwUserOperationListener listener_p) {
        if (listener_p != null) {
            this.userOperationDispatch.removeUserOperationListener(listener_p);
        }
    }

    @Override
    public OwComboboxRenderer createComboboxRenderer() {
        OwComboboxRenderer rendererInstance = null;
        try {
            String rendererClassName = this.m_Configuration.getComboboxRendererClassName();
            Class<?> rendererClass = Class.forName(rendererClassName);
            rendererInstance = (OwComboboxRenderer)rendererClass.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot create the combobox renderer. Default implementation will be used. Reason:", (Throwable)e);
        }
        if (rendererInstance == null) {
            rendererInstance = new OwClassicComboboxRenderer();
        }
        rendererInstance.setContext(this);
        return rendererInstance;
    }

    private void initSessionCookieNames() {
        if (this.sessionCookieNames == null) {
            this.sessionCookieNames = new ArrayList();
            List sessionCookieNames_temp = this.getConfiguration().getBootstrapConfiguration().getSafeStringList("SessionCookieNames");
            if (sessionCookieNames_temp.isEmpty()) {
                sessionCookieNames_temp.add("JSESSIONID");
                sessionCookieNames_temp.add("ECLIENTJSESSIONID");
                sessionCookieNames_temp.add("LtpaToken");
                sessionCookieNames_temp.add("LtpaToken2");
            }
            Iterator it = sessionCookieNames_temp.iterator();
            while (it.hasNext()) {
                this.sessionCookieNames.add(((String)it.next()).toUpperCase());
            }
        }
    }

    public List getSessionCookieNames() {
        this.initSessionCookieNames();
        return this.sessionCookieNames;
    }

    public String getSessionCookieData(HttpServletRequest httpServletRequest) {
        this.initSessionCookieNames();
        StringBuilder cookiesData = new StringBuilder();
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies != null) {
            boolean first = true;
            for (int j = 0; j < cookies.length; ++j) {
                if (!this.sessionCookieNames.contains(cookies[j].getName().toUpperCase())) continue;
                if (!first) {
                    cookiesData.append(";");
                }
                first = false;
                cookiesData.append(" ");
                cookiesData.append(cookies[j].getName());
                cookiesData.append("=");
                cookiesData.append(cookies[j].getValue());
            }
        }
        return cookiesData.toString();
    }

    @Override
    protected String createServerUrl(HttpServletRequest req_p) {
        if (this.overwriteServerUrl != null) {
            return this.overwriteServerUrl;
        }
        return super.createServerUrl(req_p);
    }

    @Override
    protected String createBaseUrl(HttpServletRequest req_p) {
        if (this.overwriteBaseUrl != null) {
            return this.overwriteBaseUrl;
        }
        return super.createBaseUrl(req_p);
    }

    @Override
    public String getConfigPath() {
        try {
            URL url = this.getConfigURL("");
            return url.toString();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to read config path", (Throwable)e);
            throw new RuntimeException("Could not read config Path", e);
        }
    }
}

