/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwClipboardView;
import com.wewebu.ow.server.app.OwComboboxRenderer;
import com.wewebu.ow.server.app.OwConfiguration;
import com.wewebu.ow.server.app.OwDefaultComboItem;
import com.wewebu.ow.server.app.OwDefaultComboModel;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMainNavigationView;
import com.wewebu.ow.server.app.OwMasterView;
import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwBaseView;
import com.wewebu.ow.server.ui.OwDialogManager;
import com.wewebu.ow.server.ui.OwLayout;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.util.OwExceptionManager;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class OwMainLayout
extends OwLayout {
    private static final String AJAX_UPDATE_EVENT_NAME = "Update";
    private static final String CONTAINER_ID = "containerId";
    private static final Logger LOG = OwLogCore.getLogger(OwMainLayout.class);
    public static final int NAVIGATION_REGION = 0;
    public static final int MAIN_REGION = 1;
    public static final int DIALOG_REGION = 2;
    public static final int ERROR_REGION = 4;
    public static final int MAXIMIZED_REGION = 5;
    public static final int CLIPBOARD_REGION = 6;
    public static final int KEYBOARD_REGION = 7;
    public static final int ROLE_SELECT_REGION = 8;
    public static final int LOGOUT_BUTTON_REGION = 9;
    public static final int USERNAME_REGION = 10;
    public static final int CURRENT_DATE_REGION = 11;
    public static final int MESSAGE_REGION = 12;
    public static final int MANDATOR_REGION = 13;
    public static final String ERROR_CONTAINER_ID = "OwMainLayout_ERROR_container";
    public static final String MESSAGE_CONTAINER_ID = "OwMainLayout_MESSAGE_container";
    public static final String KEY_INFO_CONTAINER_ID = "owkeyinfo";
    public static final String REGISTERED_KEYS_SCRIPTS_CONTAINER_ID = "registeredKeysScripts";
    private static final String ROLE_SELECT_ID = "roleselect";
    public static final String LOGOUT_STATUS = "LOGOUT_STATUS";
    public static final String LOGOUT_DISABLED = "disabled";
    protected OwConfiguration m_Configuration;
    protected OwMainAppContext m_MainContext;
    private OwMainNavigationView m_MainNaviView;
    protected OwView m_MaximizedView;

    private void addMasterPlugins(String strPreferedStartupID_p) throws Exception {
        String strStartupID = ((OwMainAppContext)this.getContext()).getStartupID();
        int iStartupNavigationIndex = 0;
        int iPreferredStartupNavigationIndex = -1;
        List mainPlugins = ((OwMainAppContext)this.getContext()).getConfiguration().getMasterPlugins(true);
        if (mainPlugins.size() == 0) {
            return;
        }
        for (int i = 0; i < mainPlugins.size(); ++i) {
            OwConfiguration.OwMasterPluginInstance mainPlugin = (OwConfiguration.OwMasterPluginInstance)mainPlugins.get(i);
            try {
                this.m_MainNaviView.addPluginView(mainPlugin.getView(), mainPlugin.getViewID());
            }
            catch (Exception e) {
                this.m_MainNaviView.addPluginView(mainPlugin.getErrorView(e, mainPlugin.getPluginTitle()), null);
            }
            if (mainPlugin.getPluginID() != null && mainPlugin.getPluginID().equals(strStartupID)) {
                iStartupNavigationIndex = i;
            }
            if (mainPlugin.getPluginID() == null || !mainPlugin.getPluginID().equals(strPreferedStartupID_p)) continue;
            iPreferredStartupNavigationIndex = i;
        }
        if (iPreferredStartupNavigationIndex != -1) {
            this.m_MainNaviView.navigate(iPreferredStartupNavigationIndex);
        } else {
            this.m_MainNaviView.navigate(iStartupNavigationIndex);
        }
    }

    @Override
    protected OwView getMaximizeView() {
        return this.m_MaximizedView;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_MainContext = (OwMainAppContext)this.getContext();
        this.m_MainContext.addAjaxUpdateContainer(ERROR_CONTAINER_ID, this.getAjaxEventURL(AJAX_UPDATE_EVENT_NAME, "containerId=OwMainLayout_ERROR_container"));
        this.m_MainContext.addAjaxUpdateContainer(MESSAGE_CONTAINER_ID, this.getAjaxEventURL(AJAX_UPDATE_EVENT_NAME, "containerId=OwMainLayout_MESSAGE_container"));
        this.m_MainContext.addAjaxUpdateContainer(KEY_INFO_CONTAINER_ID, this.getAjaxEventURL(AJAX_UPDATE_EVENT_NAME, "containerId=owkeyinfo"));
        this.m_MainContext.addAjaxUpdateContainer(REGISTERED_KEYS_SCRIPTS_CONTAINER_ID, this.getAjaxEventURL(AJAX_UPDATE_EVENT_NAME, "containerId=registeredKeysScripts"));
        this.m_Configuration = this.m_MainContext.getConfiguration();
        this.m_MainNaviView = new OwMainNavigationView();
        this.addView(this.m_MainNaviView, 0, null);
        this.addViewReference(this.m_MainNaviView.getViewReference(), 1);
        this.addViewReference(this.m_MainContext.getDialogManagerViewReference(), 2);
        this.addMasterPlugins(null);
        this.addView(new OwClipboardView(), 6, null);
    }

    @Override
    public boolean isRegion(int iRegion_p) {
        switch (iRegion_p) {
            case 7: {
                return ((OwMainAppContext)this.getContext()).getKeyEvents() != null;
            }
            case 5: {
                return null != this.getMaximizeView();
            }
            case 13: {
                return this.m_MainContext.getMandator() != null && this.m_MainContext.getMandator().getName().length() > 0;
            }
            case 2: {
                try {
                    OwDialogManager dlgman = this.m_MainContext.getDialogManager();
                    if (null == dlgman) {
                        return false;
                    }
                    return dlgman.isDialogOpen();
                }
                catch (NullPointerException e) {
                    LOG.warn((Object)"DIALOG_REGION: No dialogmanager available, probably due to missing masterplugins.", (Throwable)e);
                    return false;
                }
            }
            case 12: {
                return this.m_MainContext.getMessages() != null;
            }
            case 4: {
                return this.m_MainContext.getError() != null;
            }
            case 6: {
                return 0 != this.m_MainContext.getClipboard().getContentType() && this.m_MainContext.doShowClipboard();
            }
            case 8: {
                try {
                    return ((OwMainAppContext)this.getContext()).getRoleManager().hasMasterRoles();
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return super.isRegion(iRegion_p);
    }

    public void onLogOut(HttpServletRequest request_p) throws Exception {
        this.m_MainContext.logout();
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwMainLayout.jsp", w_p);
    }

    public void onSelectRole(HttpServletRequest request_p) throws Exception {
        String strRole = request_p.getParameter(ROLE_SELECT_ID);
        if (((OwMainAppContext)this.getContext()).getConfiguration().setMasterRole(strRole)) {
            this.updateMasterPlugins();
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        HttpSession httpSession = this.m_MainContext.getHttpSession();
        Object logoutStatus = httpSession.getAttribute(LOGOUT_STATUS);
        switch (iRegion_p) {
            case 8: {
                this.renderRoleSelectRegion(w_p);
                break;
            }
            case 5: {
                if (this.m_MaximizedView == null) break;
                this.m_MaximizedView.render(w_p);
                break;
            }
            case 9: {
                if (LOGOUT_DISABLED.equals(logoutStatus)) break;
                w_p.write("<a class=\"OwHeaderView_Info\" href=\"" + this.getEventURL("LogOut", null) + "\">" + this.getContext().localize("app.OwMainLayout.logout", "Logout") + "</a>");
                break;
            }
            case 10: {
                w_p.write(this.m_MainContext.getCredentials().getUserInfo().getUserLongName());
                break;
            }
            case 13: {
                String name = this.m_MainContext.getMandator().getName();
                if (name.length() <= 0) break;
                w_p.write("<span title=\"");
                w_p.write(this.m_MainContext.getMandator().getDescription());
                w_p.write("\">");
                w_p.write(name);
                w_p.write("</span>");
                break;
            }
            case 11: {
                DateFormat df = DateFormat.getDateInstance(0, this.getContext().getLocale());
                w_p.write(df.format(new Date()));
                break;
            }
            case 12: {
                Collection messages = this.m_MainContext.getMessages();
                if (null == messages) break;
                for (String sText : messages) {
                    w_p.write("<div class=\"OwMessages\">");
                    w_p.write(sText);
                    w_p.write("</div>");
                }
                break;
            }
            case 4: {
                Throwable e = this.m_MainContext.getError();
                if (e == null) break;
                OwExceptionManager.PrintCatchedException(this.getContext().getLocale(), e, new PrintWriter(w_p), "OwErrorStack");
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    private void renderRoleSelectRegion(Writer w_p) throws Exception {
        if (this.isRegion(8)) {
            Collection roles = ((OwMainAppContext)this.getContext()).getRoleManager().getMasterRoles();
            String strSelectedRole = ((OwMainAppContext)this.getContext()).getRoleManager().getMasterRole();
            StringBuffer selectRoleJS = new StringBuffer();
            selectRoleJS.append("<script>\n");
            selectRoleJS.append("function selectRole() {\n");
            selectRoleJS.append("document.");
            selectRoleJS.append(this.getFormName());
            selectRoleJS.append(".action=\"");
            selectRoleJS.append(this.getEventURL("SelectRole", null));
            selectRoleJS.append("\";document.");
            selectRoleJS.append(this.getFormName());
            selectRoleJS.append(".submit();\n");
            selectRoleJS.append("}\n");
            selectRoleJS.append("</script>\n");
            w_p.write(selectRoleJS.toString());
            LinkedList<OwDefaultComboItem> roleItems = new LinkedList<OwDefaultComboItem>();
            for (String strRole : roles) {
                String strRoleDisplayName = ((OwMainAppContext)this.getContext()).getRoleManager().getMasterRoleDisplayName(this.getContext().getLocale(), strRole);
                OwDefaultComboItem item = new OwDefaultComboItem(strRole, strRoleDisplayName);
                roleItems.add(item);
            }
            OwDefaultComboModel comboModel = new OwDefaultComboModel(false, false, strSelectedRole, roleItems);
            OwComboboxRenderer renderer = ((OwMainAppContext)this.getContext()).createComboboxRenderer(comboModel, ROLE_SELECT_ID, null, null, null);
            renderer.addEvent("onchange", "selectRole();");
            renderer.renderCombo(w_p);
        }
    }

    @Override
    protected void setMaximizeView(OwView view_p) {
        this.m_MaximizedView = view_p;
    }

    @Override
    public String getTitle() {
        return ((OwBaseView)this.m_Regions.get(1)).getTitle();
    }

    @Override
    public String getBreadcrumbPart() {
        return ((OwBaseView)this.m_Regions.get(1)).getBreadcrumbPart();
    }

    private void updateMasterPlugins() throws Exception {
        String preferedStartupID = "";
        List tablist = this.m_MainNaviView.getTabList();
        if (tablist.size() > 0) {
            OwNavigationView.OwTabInfo info = (OwNavigationView.OwTabInfo)tablist.get(this.m_MainNaviView.getNavigationIndex());
            preferedStartupID = ((OwMasterView)info.getView()).getPluginID();
        }
        this.m_MainNaviView.clear();
        this.addMasterPlugins(preferedStartupID);
    }

    public void onAjaxUpdate(HttpServletRequest request_p, HttpServletResponse response_p) throws Exception {
        String container = request_p.getParameter(CONTAINER_ID);
        if (ERROR_CONTAINER_ID.equals(container)) {
            this.serverSideInclude(this.getContext().getDesignDir() + "/OwMainLayoutError.jsp", response_p.getWriter());
        }
        if (MESSAGE_CONTAINER_ID.equals(container)) {
            this.serverSideInclude(this.getContext().getDesignDir() + "/OwMainLayoutMessage.jsp", response_p.getWriter());
        }
        if (KEY_INFO_CONTAINER_ID.equals(container)) {
            this.serverSideInclude(this.getContext().getDesignDir() + "/OwMainLayoutKeyboard.jsp", response_p.getWriter());
        }
        if (REGISTERED_KEYS_SCRIPTS_CONTAINER_ID.equals(container)) {
            this.serverSideInclude(this.getContext().getDesignDir() + "/OwKeyboardScriptsRenderer.jsp", response_p.getWriter());
        }
    }

    public boolean hasError() {
        return this.m_MainContext.getError() != null;
    }

    public boolean hasMessages() {
        Collection messages = this.m_MainContext.getMessages();
        return messages != null && messages.size() > 0;
    }
}

