/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.log.OwLogCore;
import com.wewebu.ow.server.ui.OwView;
import com.wewebu.ow.server.ui.button.OwImageButton;
import com.wewebu.ow.server.ui.button.OwImageButtonView;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwMaxMinButtonControlView
extends OwImageButtonView {
    private static final Logger LOG = OwLogCore.getLogger(OwMaxMinButtonControlView.class);
    protected OwView m_view;
    public static final int MODE_MAXIMIZE_BUTTON = 1;
    public static final int MODE_MINIMIZE_BUTTON = 2;
    private int m_iMode = 1;

    public OwMaxMinButtonControlView(OwView view_p) {
        this.m_view = view_p;
    }

    public OwMaxMinButtonControlView(OwView view_p, int iMode_p) {
        this.m_view = view_p;
        this.m_iMode = iMode_p;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.getDesignClasses().add("OwMaxMinButtonControlView");
    }

    public String getMaximizeIcon() throws Exception {
        return this.getContext().getDesignURL() + "/images/OwMaxMinButtonControlView/maximize.png";
    }

    public String getMinimizeIcon() throws Exception {
        return this.getContext().getDesignURL() + "/images/OwMaxMinButtonControlView/minimize.png";
    }

    public String getNormalIcon() throws Exception {
        return this.getContext().getDesignURL() + "/images/OwMaxMinButtonControlView/normal.png";
    }

    public String getControlledViewTitle() {
        return this.m_view.getTitle();
    }

    public int getDisplayMode() {
        return this.m_iMode;
    }

    public boolean getIsShowNormal() {
        return this.m_view.isShowNormal();
    }

    public void onMaximize(HttpServletRequest request_p) throws Exception {
        this.m_view.showMaximized();
    }

    public void onNormal(HttpServletRequest request_p) throws Exception {
        this.m_view.showNormal();
    }

    public void onMinimize(HttpServletRequest request_p) throws Exception {
        this.m_view.showMinimized();
    }

    @Override
    public List<OwImageButton> getButtonList() {
        String image;
        String eventUrl;
        String tooltip;
        LinkedList<OwImageButton> buttons;
        block13: {
            buttons = new LinkedList<OwImageButton>();
            tooltip = null;
            eventUrl = null;
            image = "";
            if (!this.getIsShowNormal()) {
                tooltip = this.getContext().localize("app.OwMaxMinButtonControlView.normal", "Default view");
                eventUrl = this.getEventURL("Normal", null);
                try {
                    image = this.getNormalIcon();
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Image could not be retrieved", (Throwable)e);
                        break block13;
                    }
                    LOG.warn((Object)"Image could not be retrieved.");
                }
            } else {
                if ((this.getDisplayMode() & 2) != 0) {
                    tooltip = this.getContext().localize("app.OwMaxMinButtonControlView.minimize", "Minimize");
                    eventUrl = this.getEventURL("Minimize", null);
                    try {
                        image = this.getMinimizeIcon();
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Image could not be retrieved", (Throwable)e);
                        }
                        LOG.warn((Object)"Image could not be retrieved.");
                    }
                }
                if ((this.getDisplayMode() & 1) != 0) {
                    tooltip = this.getContext().localize("app.OwMaxMinButtonControlView.maximize", "Maximize");
                    eventUrl = this.getEventURL("Maximize", null);
                    try {
                        image = this.getMaximizeIcon();
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Image could not be retrieved", (Throwable)e);
                        }
                        LOG.warn((Object)"Image could not be retrieved.");
                    }
                }
            }
        }
        buttons.add(new OwImageButton(eventUrl, image, tooltip));
        return buttons;
    }
}

