/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwDocumentFunctionCall;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMessageBox;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class OwMultipleSelectionCall
extends OwDocumentFunctionCall {
    private int m_totalElementsToDisplay = 10;
    private Collection m_objects;
    private OwObject m_parent;
    private OwClientRefreshContext m_refreshCtx;
    private OwMainAppContext m_context;

    public OwMultipleSelectionCall(OwDocumentFunction documentFunction_p, Collection objects_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p, OwMainAppContext context_p) {
        super(documentFunction_p);
        this.m_objects = objects_p;
        this.m_parent = parent_p;
        this.m_context = context_p;
        this.m_refreshCtx = refreshCtx_p;
    }

    protected final int createDisabledObjectNamesString(StringBuffer namesBuffer_p) throws Exception {
        StringBuffer disabledObjectNames = namesBuffer_p;
        disabledObjectNames.append("<ul class=\"OwMessageBoxText\">");
        int disabledObjectsCount = 0;
        Iterator i = this.m_objects.iterator();
        while (i.hasNext()) {
            OwObject owObject = (OwObject)i.next();
            if (this.m_documentFunction.isEnabled(owObject, this.m_parent, 2)) continue;
            ++disabledObjectsCount;
            disabledObjectNames.append("<li>");
            disabledObjectNames.append(OwHTMLHelper.encodeToSecureHTML(owObject.getName()));
            disabledObjectNames.append("</li>");
            if (disabledObjectsCount < this.m_totalElementsToDisplay || !i.hasNext()) continue;
            disabledObjectNames.append("<li>");
            disabledObjectNames.append("...");
            disabledObjectNames.append("</li>");
            break;
        }
        disabledObjectNames.append("</ul>");
        return disabledObjectsCount;
    }

    @Override
    public void invokeFunction() throws Exception {
        if (!this.m_documentFunction.isEnabled(this.m_objects, this.m_parent, 2)) {
            StringBuffer namesBuffer = new StringBuffer();
            int disabledObjectsCount = this.createDisabledObjectNamesString(namesBuffer);
            if (disabledObjectsCount == 0) {
                this.invokeOnMultiselectClickEvent();
            } else if (disabledObjectsCount == this.m_objects.size()) {
                StringBuffer validatorText = new StringBuffer();
                String message = this.m_context.localize("owdocfun.OwMultipleSelectionCall.validatorMessageBox.allobjectsdisabled", "The operation cannot be executed on the selected objects!");
                validatorText.append(message);
                validatorText.append("<BR>");
                OwValidatorMessageBox validatorDialog = new OwValidatorMessageBox(0, 1, this.m_documentFunction.getDefaultLabel(), validatorText.toString());
                this.m_context.openDialog(validatorDialog, null);
            } else {
                StringBuffer validatorText = new StringBuffer();
                String objectsMessage = this.m_context.localize("owdocfun.OwMultipleSelectionCall.validatorMessageBox.objects", "Warning!<br><br>The operation cannot be executed on following objects:");
                String executeAnywayMessage = this.m_context.localize("owdocfun.OwMultipleSelectionCall.validatorMessageBox.executeAnyway", "Execute anyway?");
                validatorText.append(objectsMessage);
                validatorText.append("<BR>");
                validatorText.append(namesBuffer);
                validatorText.append("<BR>");
                validatorText.append(executeAnywayMessage);
                OwValidatorMessageBox validatorDialog = new OwValidatorMessageBox(this.m_documentFunction.getDefaultLabel(), validatorText.toString());
                this.m_context.openDialog(validatorDialog, null);
            }
        } else {
            this.invokeOnMultiselectClickEvent();
        }
    }

    protected final void invokeOnMultiselectClickEvent() throws Exception {
        this.m_documentFunction.onMultiselectClickEvent(this.m_objects, this.m_parent, this.m_refreshCtx);
    }

    public class OwValidatorMessageBox
    extends OwMessageBox {
        public OwValidatorMessageBox(String title_p, String strText_p) {
            this(3, 0, title_p, strText_p);
        }

        public OwValidatorMessageBox(int type_p, int iconType_p, String title_p, String strText_p) {
            super(type_p, 2, iconType_p, title_p, strText_p);
        }

        @Override
        public void onYes(HttpServletRequest request_p) throws Exception {
            this.closeDialog();
            OwMultipleSelectionCall.this.invokeOnMultiselectClickEvent();
        }

        @Override
        public void onNo(HttpServletRequest request_p) throws Exception {
            this.closeDialog();
        }

        @Override
        public void onCancel(HttpServletRequest request_p) throws Exception {
            this.closeDialog();
        }
    }
}

