/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwWildCardDefinition;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class OwSearchCriteriaView
extends OwView
implements OwFieldProvider {
    public static final int VIEW_MASK_RENDER_VERTICAL = 1;
    public static final String RUNTIME_PLACEHOLDER_BASE_URL = "ow_baseurl";
    public static final String RUNTIME_PLACEHOLDER_DESIGN_URL = "ow_designurl";
    public static final String PLACEHOLDER_ERROR_PREFIX = "ow_err_";
    public static final String PLACEHOLDER_INSTRUCTION_PREFIX = "ow_inst_";
    public static final String PLACEHOLDER_VALIDATION_PREFIX = "ow_validate_";
    public static final int ERRORS_REGION = 9;
    protected OwFieldManager m_theFieldManager;
    protected List m_CriteriaList;
    protected String m_strHtmlFormular;
    protected String m_strJspFormular;
    protected Map m_CriteriaMap;
    protected int m_iViewMask = 0;

    public void setViewMask(int iViewMask_p) {
        this.m_iViewMask = iViewMask_p;
    }

    protected boolean hasViewMask(int iViewMask_p) {
        return (iViewMask_p & this.m_iViewMask) != 0;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_theFieldManager = ((OwMainAppContext)this.getContext()).createFieldManager();
        this.m_theFieldManager.setExternalFormTarget(this.getFormTarget());
    }

    @Override
    public OwField getField(String strFieldClassName_p) throws Exception {
        return this.m_theFieldManager.getFieldProvider().getField(strFieldClassName_p);
    }

    @Override
    public Object getFieldProviderSource() {
        return this.m_theFieldManager.getFieldProvider().getFieldProviderSource();
    }

    @Override
    public int getFieldProviderType() {
        return this.m_theFieldManager.getFieldProvider().getFieldProviderType();
    }

    @Override
    public void detach() {
        super.detach();
        this.m_theFieldManager.detach();
    }

    public void setFieldProvider(OwFieldProvider fieldProvider_p) {
        this.m_theFieldManager.setFieldProvider(fieldProvider_p);
    }

    public void setCriteriaList(List criteriaList_p) {
        this.m_CriteriaList = criteriaList_p;
        this.m_CriteriaMap = null;
    }

    public void setHTMLFormular(String strFormular_p) {
        this.m_strHtmlFormular = strFormular_p;
    }

    public void setJspFormular(String strJspUrl_p) {
        this.m_strJspFormular = strJspUrl_p;
    }

    public OwSearchCriteria lookupCriteria(String strName_p) throws Exception {
        if (this.m_CriteriaList != null && this.m_CriteriaMap == null) {
            this.m_CriteriaMap = new HashMap();
            for (int i = 0; i < this.m_CriteriaList.size(); ++i) {
                OwSearchCriteria SearchCriteria = (OwSearchCriteria)this.m_CriteriaList.get(i);
                this.m_CriteriaMap.put(SearchCriteria.getUniqueName(), SearchCriteria);
            }
        }
        if (this.m_CriteriaMap != null) {
            return (OwSearchCriteria)this.m_CriteriaMap.get(strName_p);
        }
        return null;
    }

    private boolean tryRenderRuntimePlaceholder(Writer w_p, String strPlaceholder_p) throws Exception {
        if (strPlaceholder_p.equals(RUNTIME_PLACEHOLDER_BASE_URL)) {
            w_p.write(this.getContext().getBaseURL());
            return true;
        }
        if (strPlaceholder_p.equals(RUNTIME_PLACEHOLDER_DESIGN_URL)) {
            w_p.write(this.getContext().getDesignURL());
            return true;
        }
        return false;
    }

    @Override
    public void renderNamedRegion(Writer w_p, String strPlaceholder_p) throws Exception {
        if (this.tryRenderRuntimePlaceholder(w_p, strPlaceholder_p)) {
            return;
        }
        if (strPlaceholder_p.startsWith(PLACEHOLDER_ERROR_PREFIX)) {
            OwSearchCriteria SearchCriteria = this.lookupCriteria(strPlaceholder_p = strPlaceholder_p.substring(PLACEHOLDER_ERROR_PREFIX.length()));
            if (SearchCriteria != null) {
                w_p.write(this.m_theFieldManager.getSafeFieldError(SearchCriteria));
                if (SearchCriteria.isCriteriaOperatorRange()) {
                    w_p.write(this.m_theFieldManager.getSafeFieldError(SearchCriteria.getSecondRangeCriteria()));
                }
            } else {
                w_p.write("Criteria not found: " + strPlaceholder_p);
            }
        } else if (strPlaceholder_p.startsWith(PLACEHOLDER_VALIDATION_PREFIX)) {
            OwSearchCriteria SearchCriteria = this.lookupCriteria(strPlaceholder_p = strPlaceholder_p.substring(PLACEHOLDER_VALIDATION_PREFIX.length()));
            if (SearchCriteria != null) {
                w_p.write("<span class=\"OwPropertyError\" id=\"HotInfo_" + this.m_theFieldManager.getFieldJSErrorCtrlID(SearchCriteria) + "\"></span>");
            } else {
                w_p.write("Criteria not found: " + strPlaceholder_p);
            }
        } else if (strPlaceholder_p.startsWith(PLACEHOLDER_INSTRUCTION_PREFIX)) {
            OwSearchCriteria SearchCriteria = this.lookupCriteria(strPlaceholder_p = strPlaceholder_p.substring(PLACEHOLDER_INSTRUCTION_PREFIX.length()));
            if (SearchCriteria != null) {
                w_p.write(this.getSafeInstruction(SearchCriteria));
            } else {
                w_p.write("Criteria not found: " + strPlaceholder_p);
            }
        } else {
            OwSearchCriteria SearchCriteria = this.lookupCriteria(strPlaceholder_p);
            if (SearchCriteria != null) {
                this.renderEditCriteria(w_p, SearchCriteria);
            } else {
                w_p.write("Criteria not found: " + strPlaceholder_p);
            }
        }
    }

    @Override
    public void onRender(Writer w_p) throws Exception {
        this.m_theFieldManager.reset();
        if (this.m_strJspFormular != null) {
            this.serverSideDesignInclude(this.m_strJspFormular, w_p);
        } else if (this.m_strHtmlFormular != null) {
            this.renderHTMLFormular(w_p, this.m_strHtmlFormular);
        } else if (this.hasViewMask(1)) {
            this.onRenderVertical(w_p);
        } else {
            this.onRenderHorizontal(w_p);
        }
        ((OwMainAppContext)this.getContext()).setFocusControlID(this.m_theFieldManager.getFocusControlID());
    }

    @Override
    public void renderRegion(Writer w_p, int region_p) throws Exception {
        if (region_p == 9) {
            w_p.write(this.m_theFieldManager.renderErrors());
        } else {
            super.renderRegion(w_p, region_p);
        }
    }

    @Override
    protected String usesFormWithAttributes() {
        return "";
    }

    public String getSafeInstruction(OwSearchCriteria searchCriteria_p) throws Exception {
        String strInstruction = searchCriteria_p.getInstruction();
        String sWildCardInfo = this.getSafeWildCardInfo(searchCriteria_p);
        if (strInstruction == null) {
            return sWildCardInfo;
        }
        if (sWildCardInfo.equals("")) {
            return strInstruction;
        }
        return strInstruction + ", " + sWildCardInfo;
    }

    private String getSafeWildCardInfo(OwSearchCriteria searchCriteria_p) throws Exception {
        if (!((OwMainAppContext)this.getContext()).doShowWildCardDescriptions()) {
            return "";
        }
        Collection defs = searchCriteria_p.getWildCardDefinitions();
        if (defs == null) {
            return "";
        }
        StringBuffer ret = new StringBuffer();
        Iterator it = defs.iterator();
        while (it.hasNext()) {
            OwWildCardDefinition def = (OwWildCardDefinition)it.next();
            ret.append(def.getDescription(this.getContext().getLocale()));
            if (!it.hasNext()) continue;
            ret.append(", ");
        }
        return ret.toString();
    }

    protected void renderPropertyLabel(Writer w_p, OwSearchCriteria criteria_p, String suffix_p) throws Exception {
        OwFieldDefinition fieldDefinition_p = criteria_p.getFieldDefinition();
        String label = null;
        String strOperator = criteria_p.getOperatorDisplayName(this.getContext().getLocale());
        label = strOperator.equalsIgnoreCase("") ? criteria_p.getFieldDefinition().getDisplayName(this.getContext().getLocale()) + ":&nbsp;" : criteria_p.getFieldDefinition().getDisplayName(this.getContext().getLocale()) + "&nbsp;" + strOperator + ":&nbsp;";
        if (criteria_p.isReadonly() || fieldDefinition_p.isArray() || fieldDefinition_p.isComplex()) {
            w_p.write(label);
            if (suffix_p != null) {
                w_p.write(suffix_p);
            }
        } else {
            w_p.write("<label for=\"");
            String fieldId = String.valueOf(fieldDefinition_p.hashCode());
            w_p.write(fieldId);
            w_p.write("\">");
            w_p.write(label);
            if (suffix_p != null) {
                w_p.write(suffix_p);
            }
            w_p.write("</label>");
        }
    }

    protected void onRenderHorizontal(Writer w_p) throws Exception {
        if (this.m_CriteriaList != null) {
            w_p.write("\n\n<div class=\"OwSearchCriteriaView OwNowrapLabel OwPropertyBlockLayout " + (this.m_CriteriaList.size() > 4 ? "OwScrollable" : "") + "\">");
            for (int i = 0; i < this.m_CriteriaList.size(); ++i) {
                OwSearchCriteria SearchCriteria = (OwSearchCriteria)this.m_CriteriaList.get(i);
                if (SearchCriteria.isReadonly() && !SearchCriteria.isHidden()) {
                    w_p.write("<div class=\"OwPropertyBlock\">\n");
                    w_p.write("<div class=\"OwPropertyLabel\"><label>" + SearchCriteria.getFieldDefinition().getDisplayName(this.getContext().getLocale()) + "&nbsp;" + SearchCriteria.getOperatorDisplayName(this.getContext().getLocale()) + ":</label></div>\n");
                    w_p.write("<div class=\"OwPropertyValue\">\n");
                    this.renderReadOnlyCriteria(w_p, SearchCriteria);
                    w_p.write("<div class=\"OwPropertyError\" id=\"HotInfo_" + this.m_theFieldManager.getFieldJSErrorCtrlID(SearchCriteria) + "\">&nbsp</div>\n");
                    w_p.write("</div>\n");
                    w_p.write("</div>\n");
                    continue;
                }
                if (SearchCriteria.isHidden()) continue;
                w_p.write("<div class=\"OwPropertyBlock\">\n");
                w_p.write("<div class=\"OwPropertyLabel\">");
                this.renderPropertyLabel(w_p, SearchCriteria, null);
                w_p.write("</div>\n");
                w_p.write("<div class=\"OwPropertyValue\">\n");
                this.renderEditCriteria(w_p, SearchCriteria);
                w_p.write("<div class=\"OwInstructionName\">");
                w_p.write(this.getSafeInstruction(SearchCriteria));
                w_p.write("</div>\n");
                this.writeSearchCriteriaError(w_p, SearchCriteria);
                w_p.write("<div class=\"OwPropertyError\" id=\"HotInfo_" + this.m_theFieldManager.getFieldJSErrorCtrlID(SearchCriteria) + "\"></div>\n");
                w_p.write("</div>\n");
                w_p.write("</div>\n");
            }
            w_p.write("</div>\n");
        }
    }

    private void writeSearchCriteriaError(Writer w_p, OwSearchCriteria searchCriteria_p) throws Exception {
        w_p.write("<div class=\"OwPropertyError\">");
        String searchCriteriaError = this.m_theFieldManager.getSafeFieldError(searchCriteria_p);
        w_p.write(searchCriteriaError);
        if (searchCriteria_p.isCriteriaOperatorRange()) {
            if (searchCriteriaError != null && searchCriteriaError.trim().length() != 0) {
                w_p.write("<br>");
            }
            w_p.write(this.m_theFieldManager.getSafeFieldError(searchCriteria_p.getSecondRangeCriteria()));
        }
        w_p.write("</div>\n");
    }

    protected void onRenderVertical(Writer w_p) throws Exception {
        if (this.m_CriteriaList != null) {
            w_p.write("\n\n<table class=\"OwSearchCriteriaView OwNowrapLabel\">");
            String strOperator = "";
            for (int i = 0; i < this.m_CriteriaList.size(); ++i) {
                OwSearchCriteria SearchCriteria = (OwSearchCriteria)this.m_CriteriaList.get(i);
                if (SearchCriteria.isReadonly() && !SearchCriteria.isHidden()) {
                    w_p.write("\n<tr><td class=\"OwPropertyName\" >" + SearchCriteria.getFieldDefinition().getDisplayName(this.getContext().getLocale()) + "&nbsp;" + SearchCriteria.getOperatorDisplayName(this.getContext().getLocale()) + ":</td></tr>");
                    w_p.write("\n<tr><td class=\"OwPropertyControl\">");
                    this.renderReadOnlyCriteria(w_p, SearchCriteria);
                    w_p.write("</td></tr>");
                    w_p.write("\n<tr><td>&nbsp;</td></tr>");
                    continue;
                }
                if (SearchCriteria.isHidden()) continue;
                strOperator = SearchCriteria.getOperatorDisplayName(this.getContext().getLocale());
                if (strOperator.equalsIgnoreCase("")) {
                    w_p.write("\n<tr><td class=\"OwPropertyName\">" + SearchCriteria.getFieldDefinition().getDisplayName(this.getContext().getLocale()) + ":&nbsp;</td></tr>");
                } else {
                    w_p.write("\n<tr><td class=\"OwPropertyName\">" + SearchCriteria.getFieldDefinition().getDisplayName(this.getContext().getLocale()) + "&nbsp;" + strOperator + ":</td></tr>");
                }
                w_p.write("\n<tr><td class=\"OwPropertyControl\">");
                this.renderEditCriteria(w_p, SearchCriteria);
                w_p.write("</td></tr>");
                if (this.m_theFieldManager.getSafeFieldError(SearchCriteria).length() > 0) {
                    String secondSearchCriteriaError;
                    w_p.write("\n<tr><td class=\"OwPropertyError\">&nbsp;&nbsp;");
                    w_p.write(this.m_theFieldManager.getSafeFieldError(SearchCriteria));
                    w_p.write("</td>");
                    if (SearchCriteria.isCriteriaOperatorRange() && (secondSearchCriteriaError = this.m_theFieldManager.getSafeFieldError(SearchCriteria.getSecondRangeCriteria())) != null && secondSearchCriteriaError.trim().length() != 0) {
                        w_p.write("\n<td class=\"OwPropertyError\">&nbsp;&nbsp;");
                        w_p.write(secondSearchCriteriaError);
                        w_p.write("\n</td>\n");
                    }
                    w_p.write("</tr>");
                }
                w_p.write("\n<tr><td class=\"OwPropertyError\" id=\"HotInfo_" + this.m_theFieldManager.getFieldJSErrorCtrlID(SearchCriteria) + "\">&nbsp;</td></tr>");
                String sInstr = this.getSafeInstruction(SearchCriteria);
                if (sInstr.length() > 0) {
                    w_p.write("\n<tr><td class=\"OwInstructionName\">");
                    w_p.write(sInstr);
                    w_p.write("</td></tr>");
                }
                w_p.write("\n<tr><td>&nbsp;</td></tr>");
            }
            w_p.write("</table>\n");
        }
    }

    protected void renderEditCriteria(Writer w_p, OwSearchCriteria crit_p) throws Exception {
        if (crit_p.isCriteriaOperatorRange()) {
            w_p.write("<table><tr><td>");
            this.m_theFieldManager.insertEditField(w_p, crit_p);
            w_p.write("</td><td>&nbsp;&nbsp;-&nbsp;&nbsp;</td><td>");
            this.m_theFieldManager.insertEditField(w_p, crit_p.getSecondRangeCriteria());
            w_p.write("</td></tr></table>");
        } else {
            if (crit_p.getFieldDefinition().isArray() && crit_p.getValue() == null) {
                crit_p.setValue(new Object[]{null});
            }
            this.m_theFieldManager.insertEditField(w_p, crit_p);
        }
    }

    protected void renderReadOnlyCriteria(Writer w_p, OwSearchCriteria crit_p) throws Exception {
        if (crit_p.isCriteriaOperatorRange()) {
            this.m_theFieldManager.insertReadOnlyField(w_p, crit_p);
            w_p.write("&nbsp; - &nbsp;");
            this.m_theFieldManager.insertReadOnlyField(w_p, crit_p.getSecondRangeCriteria());
        } else {
            this.m_theFieldManager.insertReadOnlyField(w_p, crit_p);
        }
    }

    public boolean onSubmitSearch(HttpServletRequest request_p) throws Exception {
        return this.m_theFieldManager.update(request_p, null, null);
    }

    @Override
    public boolean updateExternalFormTarget(HttpServletRequest request_p, boolean fSave_p) throws Exception {
        return this.m_theFieldManager.update(request_p, null, null);
    }

    @Override
    public String getFieldProviderName() {
        return this.m_theFieldManager.getFieldProvider().getFieldProviderName();
    }

    @Override
    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        OwField field = this.getField(sName_p);
        field.setValue(value_p);
    }

    @Override
    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            OwField field = this.getField(sName_p);
            return field.getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    @Override
    public Collection getFields() throws Exception {
        return this.m_CriteriaList;
    }

    public void resetErrors() {
        if (this.m_theFieldManager != null) {
            this.m_theFieldManager.resetErrors();
        }
    }
}

