/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwHelpDialog;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;

public class OwStandardDialog
extends OwDialog {
    public static final int CLOSE_BTN_REGION = 1;
    public static final int MAIN_REGION = 2;
    public static final int TITLE_REGION = 3;
    public static final int HELP_BTN_REGION = 4;
    public static final int INFO_ICON_REGION = 5;
    public static final int MENU_REGION = 6;
    public static final int FOOTER_REGION = 7;
    public static final int LEFT_REGION = 8;
    public static final int RIGHT_REGION = 9;
    public static final int STANDARD_DIALOG_REGION_MAX = 10;
    protected String m_strHelpPath;
    protected String m_strTitle;
    protected String m_strInfoIconURL;

    public void setInfoIcon(String strInfoIconURL_p) {
        this.m_strInfoIconURL = strInfoIconURL_p;
    }

    public String getInfoIcon() {
        return this.m_strInfoIconURL;
    }

    public void setTitle(String strTitle_p) {
        this.m_strTitle = strTitle_p;
    }

    @Override
    public String getTitle() {
        return this.m_strTitle;
    }

    public void setHelp(String strHelpPath_p) {
        this.m_strHelpPath = strHelpPath_p;
    }

    @Override
    public boolean isRegion(int iRegion_p) {
        switch (iRegion_p) {
            case 3: {
                return this.getTitle() != null;
            }
            case 4: {
                return this.hasHelpButton();
            }
            case 5: {
                return this.m_strInfoIconURL != null;
            }
        }
        return super.isRegion(iRegion_p);
    }

    public boolean hasHelpButton() {
        return this.m_strHelpPath != null;
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 3: {
                if (this.getTitle() == null) break;
                w_p.write("<span class=\"OwStandardDialog_TITLE\">");
                w_p.write(this.getTitle());
                w_p.write("</span>");
                break;
            }
            case 5: {
                if (this.m_strInfoIconURL == null) break;
                w_p.write("<img class=\"OwStandardDialog_icon\" src=\"");
                w_p.write(this.m_strInfoIconURL);
                w_p.write("\" alt=\"\" title=\"\" />");
                break;
            }
            case 4: {
                if (!this.hasHelpButton()) break;
                this.renderHelpButton(w_p);
                break;
            }
            case 1: {
                this.renderCloseButton(w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    public void renderHelpButton(Writer w_p) throws Exception {
        String helpToolTip = this.getContext().localize("app.OwStandardDialog.helptooltip", "Help for Dialog");
        helpToolTip = OwHTMLHelper.encodeToSecureHTML(helpToolTip);
        w_p.write("<a href=\"");
        w_p.write(this.getEventURL("Help", null));
        w_p.write("\" title=\"");
        w_p.write(helpToolTip);
        w_p.write("\"><img class=\"OwStandardDialog_icon\" src=\"");
        w_p.write(this.getContext().getDesignURL() + "/images/OwStandardDialog/help.png\"");
        w_p.write(" alt=\"");
        w_p.write(helpToolTip);
        w_p.write("\" title=\"");
        w_p.write(helpToolTip);
        w_p.write("\"/></a>");
    }

    public void renderCloseButton(Writer w_p) throws Exception {
        String strEventURL = this.getEventURL("Close", null);
        String strToolTip = this.getContext().localize("app.OwStandardDialog.closetooltip", "Close Dialog");
        strToolTip = OwHTMLHelper.encodeToSecureHTML(strToolTip);
        w_p.write("<a href=\"");
        w_p.write(strEventURL);
        w_p.write("\" title=\"");
        w_p.write(strToolTip);
        w_p.write("\" onclick=\"closeViewerWindow()\"><img class=\"OwStandardDialog_icon\" src=\"");
        w_p.write(this.getContext().getDesignURL());
        w_p.write("/images/OwStandardDialog/back.png\" alt=\"");
        w_p.write(strToolTip);
        w_p.write("\" title=\"");
        w_p.write(strToolTip);
        w_p.write("\" /></a>");
        this.getContext().registerKeyEvent(27, 0, strEventURL, strToolTip);
    }

    public void onHelp(HttpServletRequest request_p) throws Exception {
        if (this.hasHelpButton()) {
            ((OwMainAppContext)this.getContext()).openDialog(new OwHelpDialog(this.getTitle(), this.m_strHelpPath), null);
        }
    }

    public void onClose(HttpServletRequest request_p) throws Exception {
        this.closeDialog();
    }

    @Override
    protected void onRender(Writer w_p) throws Exception {
        this.serverSideDesignInclude("OwStandardDialog.jsp", w_p);
    }
}

