/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.util.upload.UploadHelper;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class OwStandardDocumentImportItem
implements OwDocumentImportItem {
    protected String m_tempDir;
    protected int m_id;
    protected String m_originalFileName;
    protected String m_mimeType;
    protected String m_mimeParameter;

    public OwStandardDocumentImportItem(String tempDir_p, int id_p, String originalFileName_p) throws Exception {
        this.m_tempDir = tempDir_p;
        this.m_id = id_p;
        this.m_originalFileName = originalFileName_p;
        if (this.m_originalFileName != null) {
            ArrayList<String> fnlist = new ArrayList<String>();
            fnlist.add(this.m_originalFileName);
            this.m_mimeParameter = "";
            this.m_mimeType = (String)UploadHelper.getDocumentFormatProperty(fnlist);
            int iMimeIndex = this.m_mimeType.indexOf(59);
            if (iMimeIndex != -1) {
                this.m_mimeParameter = this.m_mimeType.substring(iMimeIndex + 1);
                this.m_mimeType = this.m_mimeType.substring(0, iMimeIndex);
            }
        }
    }

    @Override
    public InputStream getContentStream(int i_p) throws Exception {
        if (i_p != 0) {
            throw new IndexOutOfBoundsException("Invalid stream index: " + i_p);
        }
        return new DataInputStream(new FileInputStream(new File(this.m_tempDir, Integer.toString(this.m_id))));
    }

    @Override
    public String getPreviewFilePath(int i_p) {
        if (i_p != 0) {
            throw new IndexOutOfBoundsException("Invalid stream index: " + i_p);
        }
        return this.m_tempDir + File.separatorChar + Integer.toString(this.m_id);
    }

    @Override
    public int getContentStreamCount() {
        return 1;
    }

    @Override
    public String getDisplayName() {
        return this.m_originalFileName;
    }

    @Override
    public Map getPropertyValueMap() {
        return new HashMap();
    }

    @Override
    public String getProposedDocumentName() {
        String proposedName = this.m_originalFileName;
        int pos = proposedName.lastIndexOf(46);
        if (pos >= 0) {
            proposedName = proposedName.substring(0, pos);
        }
        return proposedName;
    }

    @Override
    public void release() throws Exception {
        File f = new File(this.m_tempDir, Integer.toString(this.m_id));
        f.delete();
    }

    @Override
    public String getContentMimeParameter(int i_p) {
        return this.m_mimeParameter;
    }

    @Override
    public String getContentMimeType(int i_p) {
        return this.m_mimeType;
    }

    @Override
    public Boolean getCheckinAsMajor() {
        return null;
    }

    @Override
    public String getObjectClassName() {
        return null;
    }
}

