/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.app;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import java.util.List;

public class OwUserSelectDialog
extends OwStandardDialog
implements OwUIUserSelectModul.OwEventListner {
    private int[] m_filterType;
    private List m_selectedUsers;
    private List m_SelectedRoles;
    private boolean m_fMultiselect = false;

    public OwUserSelectDialog(int[] filterType_p, boolean fMultiselect_p) {
        this.m_filterType = filterType_p;
        this.m_fMultiselect = fMultiselect_p;
    }

    @Override
    public void init() throws Exception {
        StringBuffer strTitle;
        super.init();
        if (((OwMainAppContext)this.getContext()).getNetwork().canUserSelect()) {
            OwUIUserSelectModul userView = ((OwMainAppContext)this.getContext()).getNetwork().getUserSelectSubModul(null, this.m_filterType);
            userView.setEventListner(this);
            userView.setMultiselect(this.m_fMultiselect);
            this.addView(userView, 2, null);
            strTitle = new StringBuffer();
            for (int i = 0; i < this.m_filterType.length; ++i) {
                if (this.m_filterType[i] == 2) {
                    strTitle.append(this.getContext().localize("app.OwUserSelectDialog.group", "Group"));
                }
                if (this.m_filterType[i] == 1) {
                    strTitle.append(this.getContext().localize("app.OwUserSelectDialog.user", "User"));
                }
                if (this.m_filterType[i] == 3) {
                    strTitle.append(this.getContext().localize("app.OwUserSelectDialog.role", "Role"));
                }
                if (i >= this.m_filterType.length - 1) continue;
                strTitle.append(" / ");
            }
        } else {
            throw new OwInvalidOperationException(this.getContext().localize("app.OwUserSelectDialog.userselectmodulnotavailable", "Users / roles cannot be selected."));
        }
        strTitle.append(" ");
        strTitle.append(this.getContext().localize("app.OwUserSelectDialog.title", "Selection"));
        this.setTitle(strTitle.toString());
    }

    public List getSelectedUsers() {
        return this.m_selectedUsers;
    }

    public List getSelectedRoles() {
        return this.m_SelectedRoles;
    }

    @Override
    public void onSelectRoles(List roleNames_p) throws Exception {
        this.m_SelectedRoles = roleNames_p;
        this.closeDialog();
    }

    @Override
    public void onSelectUsers(List users_p) throws Exception {
        this.m_selectedUsers = users_p;
        this.closeDialog();
    }
}

