/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.dmsdialogs.views;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwPageSelectorComponent;
import com.wewebu.ow.server.dmsdialogs.views.OwPageableView;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import java.io.Writer;
import org.w3c.dom.Node;

public class OwNumberBlockPageSelectorComponent
extends OwPageSelectorComponent {
    private boolean m_useImages = true;

    public OwNumberBlockPageSelectorComponent(OwPageableView view_p) {
        super(view_p);
    }

    @Override
    public void render(Writer w_p) throws Exception {
        if (this.hasPaging() && this.shouldRenderComponent()) {
            int iPageSize = ((OwMainAppContext)this.m_view.getContext()).getPageSizeForLists();
            w_p.write("<div class=\"OwNumberBlockPageSelector\">\n");
            this.renderAccessibilityMark(w_p);
            if (this.m_view.canPagePrev()) {
                String text = this.m_view.getContext().localize("dmsdialogs.views.OwObjectListViewEXTJSGrid.PagingPrevBlockText", "Previous Pages");
                w_p.write("<div class=\"OwNumberBlockPageSelector_page\"><a title=\"" + text + "\" href=\"" + this.getPagePrevURL() + "\">\n");
                if (this.m_useImages) {
                    w_p.write(" <img title=\"" + text + "\" alt=\"" + text + "\" src=\"" + this.m_view.getContext().getDesignURL() + "/images/navigate_left_blue.gif\"/>");
                } else {
                    w_p.write("&lt;");
                }
                w_p.write("</a></div>\n");
            }
            int iPageCount = this.m_view.getPageCount();
            int iCurrentPage = this.m_view.getCurrentPage();
            if (iPageCount > 1) {
                for (int iPage = 0; iPage < iPageCount; ++iPage) {
                    int iStartIndex = iPage * iPageSize + 1;
                    int iEndIndex = (iPage + 1) * iPageSize;
                    if (iEndIndex >= this.m_view.getCount()) {
                        iEndIndex = this.m_view.getCount();
                    }
                    StringBuffer strPageSet = new StringBuffer();
                    strPageSet.append(iStartIndex);
                    strPageSet.append("..");
                    strPageSet.append(iEndIndex);
                    if (iCurrentPage == iPage) {
                        w_p.write("<div  class=\"OwNumberBlockPageSelector_page_selected\">" + strPageSet.toString() + "</div>\n");
                        continue;
                    }
                    w_p.write("<div class=\"OwNumberBlockPageSelector_page\"><a href=\"" + this.getPageAbsolutURL(iPage) + "\">\n");
                    w_p.write("" + strPageSet);
                    w_p.write("</a></div>\n");
                }
            }
            if (this.m_view.canPageNext()) {
                String text = this.m_view.getContext().localize("dmsdialogs.views.OwObjectListViewEXTJSGrid.PagingNextBlockText", "Next Pages");
                w_p.write("<div class=\"OwNumberBlockPageSelector_page\"><a title=\"" + text + "\" href=\"" + this.getPageNextURL() + "\">\n");
                if (this.m_useImages) {
                    w_p.write("<img title=\"" + text + "\" alt=\"" + text + "\" src=\"" + this.m_view.getContext().getDesignURL() + "/images/navigate_right_blue.gif\" />");
                } else {
                    w_p.write("&gt;");
                }
                w_p.write("</a></div>\n");
            }
            w_p.write(" </div>");
        }
    }

    @Override
    public void init() throws Exception {
        if (this.m_configNode != null) {
            Node node = OwXMLDOMUtil.getChildNode(this.m_configNode, "UseImages");
            if (node != null) {
                String useImages = node.getFirstChild().getNodeValue().trim();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("OwNumberBlockPageSelectorComponent.init: Read from the configuration, UseImages = " + useImages));
                }
                this.m_useImages = Boolean.valueOf(useImages);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwNumberBlockPageSelectorComponent.init: No <UseImages> element found in the configuration, using default value = " + this.m_useImages));
            }
        } else {
            LOG.debug((Object)"OwNumberBlockPageSelectorComponent.init: No config node set! Using the default paging component...");
        }
    }
}

